/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.units.Converter;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

public class DefaultTemporalCRS
extends AbstractSingleCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    public static Unit MILLISECOND = SI.MILLI((Unit)SI.SECOND);
    private transient Converter toMillis;
    private transient long origin;

    public DefaultTemporalCRS(String name, TemporalDatum datum, TimeCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultTemporalCRS(Map properties, TemporalDatum datum, TimeCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public static DefaultTemporalCRS wrap(TemporalCRS crs) {
        if (crs instanceof DefaultTemporalCRS) {
            return (DefaultTemporalCRS)crs;
        }
        return new DefaultTemporalCRS(DefaultTemporalCRS.getProperties((IdentifiedObject)crs), (TemporalDatum)crs.getDatum(), (TimeCS)crs.getCoordinateSystem());
    }

    private void initializeConverter() {
        this.origin = ((TemporalDatum)this.datum).getOrigin().getTime();
        this.toMillis = this.coordinateSystem.getAxis(0).getUnit().getConverterTo(MILLISECOND);
    }

    public Date toDate(double value) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(value)) + this.origin);
    }

    public double toValue(Date time) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert((double)(time.getTime() - this.origin));
    }

    public int hashCode() {
        return 0x86FFB877 ^ super.hashCode();
    }
}

