/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.util.NameFactory;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = 1449284160523432645L;
    public static final DefaultCoordinateSystemAxis LONGITUDE = new DefaultCoordinateSystemAxis(39, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LATITUDE = new DefaultCoordinateSystemAxis(35, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ALTITUDE = new DefaultCoordinateSystemAxis(3, "h", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis DEPTH = new DefaultCoordinateSystemAxis(11, "d", AxisDirection.DOWN, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEODETIC_LONGITUDE = new DefaultCoordinateSystemAxis(27, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis GEODETIC_LATITUDE = new DefaultCoordinateSystemAxis(26, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = new DefaultCoordinateSystemAxis(17, "h", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GRAVITY_RELATED_HEIGHT = new DefaultCoordinateSystemAxis(30, "h", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_RADIUS = new DefaultCoordinateSystemAxis(21, "r", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis SPHERICAL_LONGITUDE = new DefaultCoordinateSystemAxis(53, "\u03a9", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis SPHERICAL_LATITUDE = new DefaultCoordinateSystemAxis(52, "\u03b8", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis X = new DefaultCoordinateSystemAxis("x", AxisDirection.EAST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis Y = new DefaultCoordinateSystemAxis("y", AxisDirection.NORTH, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis Z = new DefaultCoordinateSystemAxis("z", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_X = new DefaultCoordinateSystemAxis(23, "X", AxisDirection.OTHER, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Y = new DefaultCoordinateSystemAxis(24, "Y", AxisDirection.EAST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Z = new DefaultCoordinateSystemAxis(25, "Z", AxisDirection.NORTH, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis EASTING = new DefaultCoordinateSystemAxis(15, "E", AxisDirection.EAST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis WESTING = new DefaultCoordinateSystemAxis(64, "W", AxisDirection.WEST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis NORTHING = new DefaultCoordinateSystemAxis(44, "N", AxisDirection.NORTH, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis SOUTHING = new DefaultCoordinateSystemAxis(51, "S", AxisDirection.SOUTH, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis TIME = new DefaultCoordinateSystemAxis(56, "t", AxisDirection.FUTURE, NonSI.DAY);
    public static final DefaultCoordinateSystemAxis COLUMN = new DefaultCoordinateSystemAxis(140, "i", AxisDirection.COLUMN_POSITIVE, Unit.ONE);
    public static final DefaultCoordinateSystemAxis ROW = new DefaultCoordinateSystemAxis(141, "j", AxisDirection.ROW_POSITIVE, Unit.ONE);
    private final String abbreviation;
    private final AxisDirection direction;
    private final Unit unit;

    public DefaultCoordinateSystemAxis(Map properties, String abbreviation, AxisDirection direction, Unit unit) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", abbreviation);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
    }

    public DefaultCoordinateSystemAxis(String abbreviation, AxisDirection direction, Unit unit) {
        this(Collections.singletonMap("name", abbreviation), abbreviation, direction, unit);
    }

    public DefaultCoordinateSystemAxis(InternationalString name, String abbreviation, AxisDirection direction, Unit unit) {
        this(DefaultCoordinateSystemAxis.toMap(name), abbreviation, direction, unit);
    }

    private static Map toMap(InternationalString name) {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        if (name != null) {
            properties.put("name", name.toString(Locale.US));
            properties.put("alias", (String)NameFactory.create((CharSequence[])new InternationalString[]{name}));
        }
        return properties;
    }

    private DefaultCoordinateSystemAxis(int name, String abbreviation, AxisDirection direction, Unit unit) {
        this(Resources.formatInternational(name), abbreviation, direction, unit);
    }

    public static AxisDirection getDirection(String direction) throws NoSuchElementException {
        String search = direction.trim();
        AxisDirection[] values = AxisDirection.values();
        for (int i = 0; i < values.length; ++i) {
            AxisDirection candidate = values[i];
            String name = candidate.name();
            if (!search.equalsIgnoreCase(name)) continue;
            return candidate;
        }
        throw new NoSuchElementException("Unknow axis direction: \"" + direction + "\".");
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public AxisDirection getDirection() {
        return this.direction;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultCoordinateSystemAxis that = (DefaultCoordinateSystemAxis)object;
            if (compareMetadata ? !Utilities.equals(this.abbreviation, that.abbreviation) : !this.nameMatches(that.getName().getCode()) && !DefaultCoordinateSystemAxis.nameMatches(that, this.getName().getCode())) {
                return false;
            }
            return Utilities.equals(this.direction, that.direction) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    public int hashCode() {
        int code = -291933499;
        code = code * 37 + this.abbreviation.hashCode();
        code = code * 37 + this.direction.hashCode();
        code = code * 37 + this.unit.hashCode();
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.append((CodeList)this.direction);
        return "AXIS";
    }
}

