/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    public static final String ANCHOR_POINT_PROPERTY = "anchorPoint";
    public static final String REALIZATION_EPOCH_PROPERTY = "realizationEpoch";
    public static final String VALID_AREA_PROPERTY = "validArea";
    public static final String SCOPE_PROPERTY = "scope";
    private static final String[] LOCALIZABLES = new String[]{"anchorPoint", "scope"};
    private final InternationalString anchorPoint;
    private final long realizationEpoch;
    private final Extent validArea;
    private final InternationalString scope;

    public AbstractDatum(Map properties) {
        this(properties, new HashMap());
    }

    private AbstractDatum(Map properties, Map subProperties) {
        super(properties, subProperties, LOCALIZABLES);
        this.anchorPoint = (InternationalString)subProperties.get(ANCHOR_POINT_PROPERTY);
        Date realizationEpoch = (Date)subProperties.get(REALIZATION_EPOCH_PROPERTY);
        this.validArea = (Extent)subProperties.get(VALID_AREA_PROPERTY);
        this.scope = (InternationalString)subProperties.get(SCOPE_PROPERTY);
        this.realizationEpoch = realizationEpoch != null ? realizationEpoch.getTime() : Long.MIN_VALUE;
    }

    public InternationalString getAnchorPoint() {
        return this.anchorPoint;
    }

    public Date getRealizationEpoch() {
        return this.realizationEpoch != Long.MIN_VALUE ? new Date(this.realizationEpoch) : null;
    }

    public Extent getValidArea() {
        return this.validArea;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    int getLegacyDatumType() {
        return 0;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (!compareMetadata) {
                return this.nameMatches(object.getName().getCode()) || AbstractDatum.nameMatches(object, this.getName().getCode());
            }
            AbstractDatum that = (AbstractDatum)object;
            return this.realizationEpoch == that.realizationEpoch && Utilities.equals(this.validArea, that.validArea) && Utilities.equals(this.anchorPoint, that.anchorPoint) && Utilities.equals(this.scope, that.scope);
        }
        return false;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.append(this.getLegacyDatumType());
        return Utilities.getShortClassName(this);
    }
}

