/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.factory.AbstractFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.resources.Utilities;
import org.geotools.util.NameFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public abstract class AbstractAuthorityFactory
extends AbstractFactory
implements DatumAuthorityFactory,
CSAuthorityFactory,
CRSAuthorityFactory {
    protected final FactoryGroup factories;

    protected AbstractAuthorityFactory(FactoryGroup factories, int priority) {
        super(priority);
        this.factories = factories;
        AbstractAuthorityFactory.ensureNonNull("factories", factories);
    }

    boolean isReady() {
        return true;
    }

    public abstract Citation getAuthority();

    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    public final ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        AbstractAuthorityFactory.ensureNonNull("code", code);
        throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
    }

    public Datum createDatum(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Datum)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Datum.class, code, exception);
        }
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (EngineeringDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringDatum.class, code, exception);
        }
    }

    public ImageDatum createImageDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (ImageDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageDatum.class, code, exception);
        }
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (VerticalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalDatum.class, code, exception);
        }
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (TemporalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalDatum.class, code, exception);
        }
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (GeodeticDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeodeticDatum.class, code, exception);
        }
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Ellipsoid)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code, exception);
        }
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (PrimeMeridian)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code, exception);
        }
    }

    public Extent createExtent(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Extent)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Extent.class, code, exception);
        }
    }

    public String geoidFromWktName(String wkt) {
        throw new UnsupportedOperationException();
    }

    public String wktFromGeoidName(String geoid) {
        throw new UnsupportedOperationException();
    }

    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateSystem)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code, exception);
        }
    }

    public CartesianCS createCartesianCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CartesianCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CartesianCS.class, code, exception);
        }
    }

    public PolarCS createPolarCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (PolarCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PolarCS.class, code, exception);
        }
    }

    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CylindricalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CylindricalCS.class, code, exception);
        }
    }

    public SphericalCS createSphericalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (SphericalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(SphericalCS.class, code, exception);
        }
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (EllipsoidalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EllipsoidalCS.class, code, exception);
        }
    }

    public VerticalCS createVerticalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (VerticalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCS.class, code, exception);
        }
    }

    public TimeCS createTimeCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (TimeCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TimeCS.class, code, exception);
        }
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateSystemAxis)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code, exception);
        }
    }

    public Unit createUnit(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Unit)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Unit.class, code, exception);
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateReferenceSystem)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code, exception);
        }
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (CompoundCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CompoundCRS.class, code, exception);
        }
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (DerivedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(DerivedCRS.class, code, exception);
        }
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (EngineeringCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringCRS.class, code, exception);
        }
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeographicCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeographicCRS.class, code, exception);
        }
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeocentricCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeocentricCRS.class, code, exception);
        }
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ImageCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageCRS.class, code, exception);
        }
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ProjectedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ProjectedCRS.class, code, exception);
        }
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (TemporalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalCRS.class, code, exception);
        }
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (VerticalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCRS.class, code, exception);
        }
    }

    public void dispose() throws FactoryException {
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code, ClassCastException cause) {
        NoSuchAuthorityCodeException exception = this.noSuchAuthorityCode(type, code);
        exception.initCause((Throwable)cause);
        return exception;
    }

    protected String trimAuthority(String code) throws NoSuchAuthorityCodeException {
        GenericName name = NameFactory.create(code = code.trim());
        GenericName scope = name.getScope();
        if (scope == null) {
            return code;
        }
        if (CitationImpl.titleMatches(this.getAuthority(), scope.toString())) {
            return name.asLocalName().toString();
        }
        InternationalString authority = this.getAuthority().getTitle();
        throw new NoSuchAuthorityCodeException("\"" + scope.toInternationalString() + "\" is outside the scope of " + authority + "factory.", authority.toString(), code);
    }

    protected final NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code) {
        String authority = this.getAuthority().getTitle().toString();
        return new NoSuchAuthorityCodeException("No code \"" + code + "\" from the authority \"" + authority + "\" was found for object of type " + Utilities.getShortName(type) + ".", authority, code);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Iterator it = registry.getServiceProviders(category, false);
        while (it.hasNext()) {
            Object provider = it.next();
            if (!(provider instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory factory = (AbstractAuthorityFactory)provider;
            Citation authority = this.getAuthority();
            if (authority == null || !authority.equals(factory.getAuthority())) continue;
            if (this.priority > factory.priority) {
                registry.setOrdering(category, this, factory);
                continue;
            }
            if (this.priority >= factory.priority) continue;
            registry.setOrdering(category, factory, this);
        }
    }
}

