/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.units.Unit;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.InternationalString;

public class BufferedAuthorityFactory
extends AbstractAuthorityFactory {
    static final int DEFAULT_MAX = 20;
    AbstractAuthorityFactory backingStore;
    private final LinkedHashMap pool = new LinkedHashMap(32, 0.75f, true);
    private final int maxStrongReferences;

    public BufferedAuthorityFactory(AbstractAuthorityFactory factory) {
        this(factory, 20);
    }

    public BufferedAuthorityFactory(AbstractAuthorityFactory factory, int maxStrongReferences) {
        super(factory.factories, factory.priority);
        while (factory instanceof BufferedAuthorityFactory) {
            factory = ((BufferedAuthorityFactory)factory).backingStore;
        }
        this.backingStore = factory;
        this.maxStrongReferences = maxStrongReferences;
    }

    BufferedAuthorityFactory(FactoryGroup factories, int priority, int maxStrongReferences) {
        super(factories, priority);
        this.maxStrongReferences = maxStrongReferences;
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            throw new FactoryException("The factory has been disposed.");
        }
        return this.backingStore;
    }

    synchronized boolean isReady() {
        try {
            return this.getBackingStore().isReady();
        }
        catch (FactoryException exception) {
            Citation citation = this.getAuthority();
            Collection titles = citation.getAlternateTitles();
            InternationalString title = citation.getTitle();
            if (titles != null) {
                Iterator it = titles.iterator();
                while (it.hasNext()) {
                    InternationalString candidate = (InternationalString)it.next();
                    if (candidate.length() <= title.length()) continue;
                    title = candidate;
                }
            }
            LogRecord record = new LogRecord(Level.FINE, "Unavailable factory: " + title);
            record.setSourceClassName(Utilities.getShortClassName(this));
            record.setSourceMethodName("isReady");
            record.setThrown(exception);
            LOGGER.log(record);
            return false;
        }
    }

    public synchronized Citation getVendor() {
        return this.backingStore != null ? this.backingStore.getVendor() : super.getVendor();
    }

    public synchronized Citation getAuthority() {
        return this.backingStore != null ? this.backingStore.getAuthority() : null;
    }

    public synchronized String getBackingStoreDescription() throws FactoryException {
        return this.getBackingStore().getBackingStoreDescription();
    }

    public synchronized Set getAuthorityCodes(Class type) throws FactoryException {
        return this.getBackingStore().getAuthorityCodes(type);
    }

    public synchronized InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getBackingStore().getDescriptionText(code);
    }

    public synchronized IdentifiedObject createObject(String code) throws FactoryException {
        Object cached = this.get(code);
        IdentifiedObject object = cached instanceof IdentifiedObject ? (IdentifiedObject)cached : this.getBackingStore().createObject(code);
        this.put(code, object);
        return object;
    }

    public synchronized Datum createDatum(String code) throws FactoryException {
        Object cached = this.get(code);
        Datum datum = cached instanceof Datum ? (Datum)cached : this.getBackingStore().createDatum(code);
        this.put(code, datum);
        return datum;
    }

    public synchronized EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        Object cached = this.get(code);
        EngineeringDatum datum = cached instanceof EngineeringDatum ? (EngineeringDatum)cached : this.getBackingStore().createEngineeringDatum(code);
        this.put(code, datum);
        return datum;
    }

    public synchronized ImageDatum createImageDatum(String code) throws FactoryException {
        Object cached = this.get(code);
        ImageDatum datum = cached instanceof ImageDatum ? (ImageDatum)cached : this.getBackingStore().createImageDatum(code);
        this.put(code, datum);
        return datum;
    }

    public synchronized VerticalDatum createVerticalDatum(String code) throws FactoryException {
        Object cached = this.get(code);
        VerticalDatum datum = cached instanceof VerticalDatum ? (VerticalDatum)cached : this.getBackingStore().createVerticalDatum(code);
        this.put(code, datum);
        return datum;
    }

    public synchronized TemporalDatum createTemporalDatum(String code) throws FactoryException {
        Object cached = this.get(code);
        TemporalDatum datum = cached instanceof TemporalDatum ? (TemporalDatum)cached : this.getBackingStore().createTemporalDatum(code);
        this.put(code, datum);
        return datum;
    }

    public synchronized GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        Object cached = this.get(code);
        GeodeticDatum datum = cached instanceof GeodeticDatum ? (GeodeticDatum)cached : this.getBackingStore().createGeodeticDatum(code);
        this.put(code, datum);
        return datum;
    }

    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        Object cached = this.get(code);
        Ellipsoid ellipsoid = cached instanceof Ellipsoid ? (Ellipsoid)cached : this.getBackingStore().createEllipsoid(code);
        this.put(code, ellipsoid);
        return ellipsoid;
    }

    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        Object cached = this.get(code);
        PrimeMeridian meridian = cached instanceof PrimeMeridian ? (PrimeMeridian)cached : this.getBackingStore().createPrimeMeridian(code);
        this.put(code, meridian);
        return meridian;
    }

    public synchronized Extent createExtent(String code) throws FactoryException {
        Object cached = this.get(code);
        Extent extent = cached instanceof Extent ? (Extent)cached : this.getBackingStore().createExtent(code);
        this.put(code, extent);
        return extent;
    }

    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        Object cached = this.get(code);
        CoordinateSystem cs = cached instanceof CoordinateSystem ? (CoordinateSystem)cached : this.getBackingStore().createCoordinateSystem(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized CartesianCS createCartesianCS(String code) throws FactoryException {
        Object cached = this.get(code);
        CartesianCS cs = cached instanceof CartesianCS ? (CartesianCS)cached : this.getBackingStore().createCartesianCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized PolarCS createPolarCS(String code) throws FactoryException {
        Object cached = this.get(code);
        PolarCS cs = cached instanceof PolarCS ? (PolarCS)cached : this.getBackingStore().createPolarCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized CylindricalCS createCylindricalCS(String code) throws FactoryException {
        Object cached = this.get(code);
        CylindricalCS cs = cached instanceof CylindricalCS ? (CylindricalCS)cached : this.getBackingStore().createCylindricalCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized SphericalCS createSphericalCS(String code) throws FactoryException {
        Object cached = this.get(code);
        SphericalCS cs = cached instanceof SphericalCS ? (SphericalCS)cached : this.getBackingStore().createSphericalCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        Object cached = this.get(code);
        EllipsoidalCS cs = cached instanceof EllipsoidalCS ? (EllipsoidalCS)cached : this.getBackingStore().createEllipsoidalCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized VerticalCS createVerticalCS(String code) throws FactoryException {
        Object cached = this.get(code);
        VerticalCS cs = cached instanceof VerticalCS ? (VerticalCS)cached : this.getBackingStore().createVerticalCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized TimeCS createTimeCS(String code) throws FactoryException {
        Object cached = this.get(code);
        TimeCS cs = cached instanceof TimeCS ? (TimeCS)cached : this.getBackingStore().createTimeCS(code);
        this.put(code, cs);
        return cs;
    }

    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        Object cached = this.get(code);
        CoordinateSystemAxis axis = cached instanceof CoordinateSystemAxis ? (CoordinateSystemAxis)cached : this.getBackingStore().createCoordinateSystemAxis(code);
        this.put(code, axis);
        return axis;
    }

    public synchronized Unit createUnit(String code) throws FactoryException {
        Object cached = this.get(code);
        Unit unit = cached instanceof Unit ? (Unit)cached : this.getBackingStore().createUnit(code);
        this.put(code, unit);
        return unit;
    }

    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        Object cached = this.get(code);
        CoordinateReferenceSystem crs = cached instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)cached : this.getBackingStore().createCoordinateReferenceSystem(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        CompoundCRS crs = cached instanceof CompoundCRS ? (CompoundCRS)cached : this.getBackingStore().createCompoundCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized DerivedCRS createDerivedCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        DerivedCRS crs = cached instanceof DerivedCRS ? (DerivedCRS)cached : this.getBackingStore().createDerivedCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        EngineeringCRS crs = cached instanceof EngineeringCRS ? (EngineeringCRS)cached : this.getBackingStore().createEngineeringCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized GeographicCRS createGeographicCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        GeographicCRS crs = cached instanceof GeographicCRS ? (GeographicCRS)cached : this.getBackingStore().createGeographicCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        GeocentricCRS crs = cached instanceof GeocentricCRS ? (GeocentricCRS)cached : this.getBackingStore().createGeocentricCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized ImageCRS createImageCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        ImageCRS crs = cached instanceof ImageCRS ? (ImageCRS)cached : this.getBackingStore().createImageCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        ProjectedCRS crs = cached instanceof ProjectedCRS ? (ProjectedCRS)cached : this.getBackingStore().createProjectedCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized TemporalCRS createTemporalCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        TemporalCRS crs = cached instanceof TemporalCRS ? (TemporalCRS)cached : this.getBackingStore().createTemporalCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized VerticalCRS createVerticalCRS(String code) throws FactoryException {
        Object cached = this.get(code);
        VerticalCRS crs = cached instanceof VerticalCRS ? (VerticalCRS)cached : this.getBackingStore().createVerticalCRS(code);
        this.put(code, crs);
        return crs;
    }

    public synchronized void dispose() throws FactoryException {
        if (this.backingStore != null) {
            this.backingStore.dispose();
            this.backingStore = null;
        }
        this.pool.clear();
        super.dispose();
    }

    private Object get(String code) {
        Object object = this.pool.get(code);
        if (object instanceof Reference) {
            object = ((Reference)object).get();
        }
        return object;
    }

    private void put(String code, Object object) {
        this.pool.put(code, object);
        int toReplace = this.maxStrongReferences - this.pool.size();
        if (toReplace > 0) {
            Iterator it = this.pool.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                if (value instanceof Reference) {
                    if (((Reference)value).get() != null) continue;
                    it.remove();
                    continue;
                }
                entry.setValue(new WeakReference(value));
                if (--toReplace != 0) continue;
                break;
            }
        }
    }
}

