/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.units.Unit;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AbstractFactory;
import org.geotools.resources.XArray;
import org.geotools.util.LocalName;
import org.geotools.util.NameFactory;
import org.geotools.util.ScopedName;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.GenericName;

public class DatumAliases
extends AbstractFactory
implements DatumFactory {
    private static final String ALIAS_TABLE = "DatumAliasesTable.txt";
    private static final String SEPARATORS = ";";
    private static final Object[] NEED_LOADING;
    private final URL aliasURL;
    private final Map aliasMap = new HashMap();
    private LocalName[] authorities;
    private DatumFactory factory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DatumAliases() {
        super(60);
        this.aliasURL = DatumAliases.class.getResource(ALIAS_TABLE);
        if (this.aliasURL == null) {
            throw new NoSuchElementException(ALIAS_TABLE);
        }
    }

    public DatumAliases(DatumFactory factory) {
        this();
        this.factory = factory;
        DatumAliases.ensureNonNull("factory", factory);
    }

    public DatumAliases(DatumFactory factory, URL aliasURL) {
        super(60);
        this.factory = factory;
        this.aliasURL = aliasURL;
        DatumAliases.ensureNonNull("factory", factory);
        DatumAliases.ensureNonNull("aliasURL", aliasURL);
    }

    private DatumFactory getDatumFactory() throws NoSuchElementException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.factory == null) {
            DatumFactory candidate;
            Iterator it = FactoryFinder.getDatumFactories().iterator();
            while ((candidate = (DatumFactory)it.next()) == this) {
            }
            this.factory = candidate;
        }
        return this.factory;
    }

    private static String toCaseless(String key) {
        return key.replace('_', ' ').trim().toLowerCase();
    }

    private static String readLine(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null && ((line = line.trim()).length() == 0 || line.charAt(0) == '#')) {
        }
        return line;
    }

    private void reload() throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        LOGGER.fine("Loading datum aliases from \"" + this.aliasURL.toString() + "\".");
        BufferedReader in = new BufferedReader(new InputStreamReader(this.aliasURL.openStream()));
        String line = DatumAliases.readLine(in);
        if (line != null) {
            ArrayList<Object> elements = new ArrayList<Object>();
            StringTokenizer st = new StringTokenizer(line, SEPARATORS);
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                elements.add(name.length() != 0 ? new LocalName(name) : null);
            }
            this.authorities = elements.toArray(new LocalName[elements.size()]);
            HashMap<String, String> canonical = new HashMap<String, String>();
            while ((line = DatumAliases.readLine(in)) != null) {
                elements.clear();
                canonical.clear();
                st = new StringTokenizer(line, SEPARATORS);
                while (st.hasMoreTokens()) {
                    String alias = st.nextToken().trim();
                    if (alias.length() != 0) {
                        String previous = canonical.put(alias, alias);
                        if (previous != null) {
                            canonical.put(previous, previous);
                            alias = previous;
                        }
                    } else {
                        alias = null;
                    }
                    elements.add(alias);
                }
                int i = elements.size();
                while (--i >= 0 && elements.get(i) == null) {
                    elements.remove(i);
                }
                if (elements.isEmpty()) continue;
                Object[] names = elements.toArray(new String[elements.size()]);
                for (int i2 = 0; i2 < names.length; ++i2) {
                    String name = names[i2];
                    String key = DatumAliases.toCaseless(name);
                    Object[] previous = this.aliasMap.put(key, names);
                    if (previous == null || previous == NEED_LOADING) continue;
                    if (previous instanceof GenericName[]) {
                        this.aliasMap.put(key, previous);
                        continue;
                    }
                    if (Arrays.equals(previous, names)) continue;
                    LOGGER.warning("Inconsistent aliases for datum \"" + name + "\".");
                }
            }
        }
        in.close();
    }

    private void log(IOException exception) {
        LogRecord record = new LogRecord(Level.WARNING, "Can't read \"" + this.aliasURL + "\".");
        record.setSourceClassName("DatumAliases");
        record.setSourceMethodName("reload");
        record.setThrown(exception);
        LOGGER.log(record);
    }

    private GenericName[] getAliases(String name) {
        CharSequence alias;
        int i;
        Object[] aliases;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.aliasMap.isEmpty()) {
            try {
                this.reload();
            }
            catch (IOException exception) {
                this.log(exception);
            }
        }
        if ((aliases = (Object[])this.aliasMap.get(name = DatumAliases.toCaseless(name))) == null) {
            return null;
        }
        if (aliases == NEED_LOADING) {
            try {
                this.reload();
            }
            catch (IOException exception) {
                this.log(exception);
            }
            aliases = (Object[])this.aliasMap.get(name);
            if (aliases == NEED_LOADING) {
                return null;
            }
        }
        if (aliases instanceof GenericName[]) {
            return (GenericName[])aliases;
        }
        int count = 0;
        Object[] names = new GenericName[aliases.length];
        for (i = 0; i < aliases.length; ++i) {
            LocalName authority;
            alias = (CharSequence)aliases[i];
            if (alias == null) continue;
            names[count++] = count < this.authorities.length && (authority = this.authorities[count]) != null ? new ScopedName(authority, alias) : new LocalName(alias);
        }
        names = (GenericName[])XArray.resize(names, count);
        for (i = 0; i < names.length; ++i) {
            alias = names[i].asLocalName().toString();
            Object[] previous = this.aliasMap.put(DatumAliases.toCaseless((String)alias), names);
            if (!$assertionsDisabled && previous != names && !Arrays.equals(aliases, previous)) {
                throw new AssertionError(alias);
            }
        }
        return names;
    }

    private Map addAliases(Map properties) {
        DatumAliases.ensureNonNull("properties", properties);
        Object value = properties.get("name");
        DatumAliases.ensureNonNull("name", value);
        String name = value instanceof Identifier ? ((Identifier)value).getCode() : value.toString();
        GenericName[] aliases = this.getAliases(name);
        if (aliases != null) {
            int count = aliases.length;
            value = properties.get("alias");
            if (value != null) {
                LinkedHashMap merged = new LinkedHashMap();
                DatumAliases.putAll(NameFactory.toArray(value), merged);
                count -= DatumAliases.putAll(aliases, merged);
                Collection c = merged.values();
                aliases = c.toArray(new GenericName[c.size()]);
            }
            if (count > 0) {
                properties = new HashMap<String, GenericName[]>(properties);
                properties.put("alias", aliases);
            }
        }
        return properties;
    }

    private static final int putAll(GenericName[] names, Map map) {
        int ignored = 0;
        for (int i = 0; i < names.length; ++i) {
            GenericName name = names[i];
            org.opengis.util.ScopedName scoped = name.asScopedName();
            String key = DatumAliases.toCaseless((scoped != null ? scoped : name).toString());
            GenericName old = map.put(key, name);
            if (!(old instanceof org.opengis.util.ScopedName)) continue;
            map.put(key, old);
            ++ignored;
        }
        return ignored;
    }

    public synchronized EngineeringDatum createEngineeringDatum(Map properties) throws FactoryException {
        return this.getDatumFactory().createEngineeringDatum(this.addAliases(properties));
    }

    public synchronized GeodeticDatum createGeodeticDatum(Map properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        return this.getDatumFactory().createGeodeticDatum(this.addAliases(properties), ellipsoid, primeMeridian);
    }

    public synchronized ImageDatum createImageDatum(Map properties, PixelInCell pixelInCell) throws FactoryException {
        return this.getDatumFactory().createImageDatum(this.addAliases(properties), pixelInCell);
    }

    public synchronized TemporalDatum createTemporalDatum(Map properties, Date origin) throws FactoryException {
        return this.getDatumFactory().createTemporalDatum(this.addAliases(properties), origin);
    }

    public synchronized VerticalDatum createVerticalDatum(Map properties, VerticalDatumType type) throws FactoryException {
        return this.getDatumFactory().createVerticalDatum(this.addAliases(properties), type);
    }

    public synchronized Ellipsoid createEllipsoid(Map properties, double semiMajorAxis, double semiMinorAxis, Unit unit) throws FactoryException {
        return this.getDatumFactory().createEllipsoid(this.addAliases(properties), semiMajorAxis, semiMinorAxis, unit);
    }

    public synchronized Ellipsoid createFlattenedSphere(Map properties, double semiMajorAxis, double inverseFlattening, Unit unit) throws FactoryException {
        return this.getDatumFactory().createFlattenedSphere(this.addAliases(properties), semiMajorAxis, inverseFlattening, unit);
    }

    public synchronized PrimeMeridian createPrimeMeridian(Map properties, double longitude, Unit angularUnit) throws FactoryException {
        return this.getDatumFactory().createPrimeMeridian(this.addAliases(properties), longitude, angularUnit);
    }

    public synchronized void freeUnused() {
        if (this.aliasMap != null) {
            Iterator it = this.aliasMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() instanceof GenericName[]) continue;
                entry.setValue(NEED_LOADING);
            }
        }
    }

    static {
        $assertionsDisabled = !DatumAliases.class.desiredAssertionStatus();
        NEED_LOADING = new Object[0];
    }
}

