/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.units.ConversionException;
import javax.units.Unit;
import org.geotools.factory.Hints;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.XArray;
import org.geotools.util.Singleton;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class FactoryGroup {
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private MathTransformFactory mtFactory;

    public FactoryGroup() {
    }

    public FactoryGroup(Hints hints) {
        if (hints != null && !hints.isEmpty()) {
            this.datumFactory = FactoryFinder.getDatumFactory(hints);
            this.csFactory = FactoryFinder.getCSFactory(hints);
            this.crsFactory = FactoryFinder.getCRSFactory(hints);
            this.mtFactory = FactoryFinder.getMathTransformFactory(hints);
        }
    }

    public FactoryGroup(DatumFactory datumFactory, CSFactory csFactory, CRSFactory crsFactory, MathTransformFactory mtFactory) {
        this.datumFactory = datumFactory;
        this.csFactory = csFactory;
        this.crsFactory = crsFactory;
        this.mtFactory = mtFactory;
    }

    public DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = FactoryFinder.getDatumFactory(null);
        }
        return this.datumFactory;
    }

    public CSFactory getCSFactory() {
        if (this.csFactory == null) {
            this.csFactory = FactoryFinder.getCSFactory(null);
        }
        return this.csFactory;
    }

    public CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = FactoryFinder.getCRSFactory(null);
        }
        return this.crsFactory;
    }

    public MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = FactoryFinder.getMathTransformFactory(null);
        }
        return this.mtFactory;
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters, Collection methods) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform;
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (methods == null) {
            return mtFactory.createParameterizedTransform(parameters);
        }
        if (mtFactory instanceof DefaultMathTransformFactory) {
            transform = ((DefaultMathTransformFactory)mtFactory).createParameterizedTransform(parameters, methods);
        } else {
            transform = mtFactory.createParameterizedTransform(parameters);
            Set operations = mtFactory.getAvailableMethods(Operation.class);
            String classification = parameters.getDescriptor().getName().getCode();
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                OperationMethod method = (OperationMethod)it.next();
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method.getParameters(), classification)) continue;
                methods.add(method);
                break;
            }
        }
        return transform;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS, Collection methods) throws NoSuchIdentifierException, FactoryException {
        Matrix swap3;
        Matrix swap1;
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(baseCRS);
        Unit axisUnit = ellipsoid.getAxisUnit();
        Parameters.ensureSet(parameters, "semi_major", ellipsoid.getSemiMajorAxis(), axisUnit, false);
        Parameters.ensureSet(parameters, "semi_minor", ellipsoid.getSemiMinorAxis(), axisUnit, false);
        EllipsoidalCS geoCS = (EllipsoidalCS)baseCRS.getCoordinateSystem();
        try {
            swap1 = DefaultEllipsoidalCS.swapAndScaleAxis((CoordinateSystem)geoCS, DefaultEllipsoidalCS.GEODETIC_2D);
            swap3 = DefaultCartesianCS.swapAndScaleAxis(DefaultCartesianCS.PROJECTED, derivedCS);
        }
        catch (IllegalArgumentException cause) {
            throw new FactoryException((Exception)cause);
        }
        catch (ConversionException cause) {
            throw new FactoryException((Exception)((Object)cause));
        }
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        MathTransform step1 = mtFactory.createAffineTransform(swap1);
        MathTransform step2 = this.createParameterizedTransform(parameters, methods);
        MathTransform step3 = mtFactory.createAffineTransform(swap3);
        MathTransform mt = mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(step1, step2), step3);
        return mt;
    }

    public ProjectedCRS createProjectedCRS(Map properties, GeographicCRS baseCRS, Conversion conversionFromBase, CartesianCS derivedCS) throws FactoryException {
        MathTransform mt = this.createBaseToDerived((CoordinateReferenceSystem)baseCRS, conversionFromBase.getParameterValues(), (CoordinateSystem)derivedCS, null);
        return new DefaultProjectedCRS(properties, conversionFromBase, baseCRS, mt, derivedCS);
    }

    public ProjectedCRS createProjectedCRS(Map properties, GeographicCRS baseCRS, OperationMethod method, ParameterValueGroup parameters, CartesianCS derivedCS) throws FactoryException {
        Singleton methods = method == null ? new Singleton() : null;
        MathTransform mt = this.createBaseToDerived((CoordinateReferenceSystem)baseCRS, parameters, (CoordinateSystem)derivedCS, methods);
        if (method == null) {
            method = (OperationMethod)methods.get();
        }
        return this.getCRSFactory().createProjectedCRS(properties, method, baseCRS, mt, derivedCS);
    }

    public CoordinateReferenceSystem toGeodetic3D(CompoundCRS crs) throws FactoryException {
        SingleCRS[] components = DefaultCompoundCRS.getSingleCRS((CoordinateReferenceSystem)crs);
        GeographicCRS horizontal = null;
        VerticalCRS vertical = null;
        int hi = 0;
        int vi = 0;
        for (int i = 0; i < components.length; ++i) {
            SingleCRS candidate = components[i];
            if (candidate instanceof VerticalCRS) {
                if (vertical == null && VerticalDatumType.ELLIPSOIDAL.equals(((VerticalDatum)(vertical = (VerticalCRS)candidate).getDatum()).getVerticalDatumType())) {
                    vi = i;
                    continue;
                }
                return crs;
            }
            if (!(candidate instanceof GeographicCRS)) continue;
            if (horizontal == null && (horizontal = (GeographicCRS)candidate).getCoordinateSystem().getDimension() == 2) {
                hi = i;
                continue;
            }
            return crs;
        }
        if (horizontal != null && vertical != null && Math.abs(vi - hi) == 1) {
            Map crsName;
            Map csName;
            boolean classic = hi < vi;
            CoordinateSystemAxis[] axis = new CoordinateSystemAxis[3];
            EllipsoidalCS cs = (EllipsoidalCS)horizontal.getCoordinateSystem();
            axis[classic ? 0 : 1] = cs.getAxis(0);
            axis[classic ? 1 : 2] = cs.getAxis(1);
            axis[classic ? 2 : 0] = vertical.getCoordinateSystem().getAxis(0);
            if (components.length == 2) {
                csName = AbstractIdentifiedObject.getProperties((IdentifiedObject)crs.getCoordinateSystem());
                crsName = AbstractIdentifiedObject.getProperties((IdentifiedObject)crs);
            } else {
                csName = FactoryGroup.getTemporaryName((IdentifiedObject)cs);
                crsName = FactoryGroup.getTemporaryName((IdentifiedObject)horizontal);
            }
            CSFactory csFactory = this.getCSFactory();
            CRSFactory crsFactory = this.getCRSFactory();
            GeographicCRS single = crsFactory.createGeographicCRS(crsName, (GeodeticDatum)horizontal.getDatum(), csFactory.createEllipsoidalCS(csName, axis[0], axis[1], axis[2]));
            if (components.length == 2) {
                return single;
            }
            CoordinateReferenceSystem[] c = new CoordinateReferenceSystem[components.length - 1];
            int i = classic ? hi : vi;
            System.arraycopy(components, 0, c, 0, i);
            c[i] = single;
            System.arraycopy(components, i + 2, c, i + 1, components.length - (i + 2));
            return crsFactory.createCompoundCRS(AbstractIdentifiedObject.getProperties((IdentifiedObject)crs), c);
        }
        return crs;
    }

    public CoordinateReferenceSystem separate(CoordinateReferenceSystem crs, int[] dimensions) throws FactoryException {
        int length = dimensions.length;
        int crsDimension = crs.getCoordinateSystem().getDimension();
        if (length == 0 || dimensions[0] < 0 || dimensions[length - 1] >= crsDimension || !XArray.isStrictlySorted(dimensions)) {
            throw new IllegalArgumentException("Illegal dimension array.");
        }
        if (length == crsDimension) {
            return crs;
        }
        if (crs instanceof CompoundCRS) {
            int count = 0;
            int lowerDimension = 0;
            int lowerIndex = 0;
            List sources = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Object[] targets = new CoordinateReferenceSystem[sources.size()];
            Iterator it = sources.iterator();
            block0: while (it.hasNext()) {
                CoordinateReferenceSystem source = (CoordinateReferenceSystem)it.next();
                int upperDimension = lowerDimension + source.getCoordinateSystem().getDimension();
                if (lowerIndex == dimensions.length) break;
                while (dimensions[lowerIndex] < lowerDimension) {
                    if (++lowerIndex != dimensions.length) continue;
                    break block0;
                }
                int upperIndex = lowerIndex;
                while (dimensions[upperIndex] < upperDimension && ++upperIndex != dimensions.length) {
                }
                if (lowerIndex != upperIndex) {
                    int[] sub = new int[upperIndex - lowerIndex];
                    for (int j = 0; j < sub.length; ++j) {
                        sub[j] = dimensions[j + lowerIndex] - lowerDimension;
                    }
                    targets[count++] = this.separate(source, sub);
                }
                lowerDimension = upperDimension;
                lowerIndex = upperIndex;
            }
            if (count == 1) {
                return targets[0];
            }
            return this.getCRSFactory().createCompoundCRS(FactoryGroup.getTemporaryName((IdentifiedObject)crs), (CoordinateReferenceSystem[])XArray.resize(targets, count));
        }
        throw new FactoryException("Can't separate the CRS.");
    }

    private static Map getTemporaryName(IdentifiedObject source) {
        return Collections.singletonMap("name", source.getName().getCode() + " (3D)");
    }
}

