/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FactoryUsingSQL
extends AbstractAuthorityFactory {
    private static final String[] OBJECT_TABLES;
    private transient Citation authority;
    private int lastObjectType = -2;
    private final Calendar calendar = Calendar.getInstance();
    private final Map statements = new IdentityHashMap();
    private final Map scopes = new HashMap();
    private final Map properties = new HashMap();
    private final StringBuffer prefix = new StringBuffer();
    private final Set safetyGuard = new HashSet();
    AbstractAuthorityFactory buffered = this;
    protected final Connection connection;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$opengis$referencing$operation$Projection;
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;

    private static Unit getUnit(int code) {
        switch (code) {
            case 9001: {
                return SI.METER;
            }
            case 9002: {
                return NonSI.FOOT;
            }
            case 9030: {
                return NonSI.NAUTICAL_MILE;
            }
            case 9036: {
                return SI.KILO((Unit)SI.METER);
            }
            case 9101: {
                return SI.RADIAN;
            }
            case 9102: {
                return NonSI.DEGREE_ANGLE;
            }
            case 9103: {
                return NonSI.MINUTE_ANGLE;
            }
            case 9104: {
                return NonSI.SECOND_ANGLE;
            }
            case 9105: {
                return NonSI.GRADE;
            }
            case 9107: {
                return Units.DEGREE_MINUTE_SECOND;
            }
            case 9108: {
                return Units.DEGREE_MINUTE_SECOND;
            }
            case 9109: {
                return SI.MICRO((Unit)SI.RADIAN);
            }
            case 9110: {
                return Units.SEXAGESIMAL_DMS;
            }
            case 9201: {
                return Unit.ONE;
            }
            case 9202: {
                return Units.PPM;
            }
        }
        return null;
    }

    private static void setBursaWolfParameter(BursaWolfParameters parameters, int code, double value, Unit unit) throws FactoryException {
        Unit target = unit;
        if (code >= 8605) {
            if (code <= 8607) {
                target = SI.METER;
            } else if (code <= 8710) {
                target = NonSI.SECOND_ANGLE;
            } else if (code == 8611) {
                target = Units.PPM;
            }
        }
        if (target != unit) {
            value = unit.getConverterTo(target).convert(value);
        }
        switch (code) {
            case 8605: {
                parameters.dx = value;
                break;
            }
            case 8606: {
                parameters.dy = value;
                break;
            }
            case 8607: {
                parameters.dz = value;
                break;
            }
            case 8608: {
                parameters.ex = value;
                break;
            }
            case 8609: {
                parameters.ey = value;
                break;
            }
            case 8610: {
                parameters.ez = value;
                break;
            }
            case 8611: {
                parameters.ppm = value;
                break;
            }
            default: {
                throw new FactoryException("Unexpected parameter code: " + code);
            }
        }
    }

    public FactoryUsingSQL(FactoryGroup factories, Connection connection) {
        super(factories, 80);
        this.connection = connection;
        FactoryUsingSQL.ensureNonNull("connection", connection);
    }

    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            try {
                String query = this.adaptSQL("SELECT VERSION_NUMBER, VERSION_DATE FROM [Version History] ORDER BY VERSION_DATE DESC");
                DatabaseMetaData metadata = this.connection.getMetaData();
                Statement statement = this.connection.createStatement();
                ResultSet result = statement.executeQuery(query);
                if (result.next()) {
                    String version = result.getString(1);
                    Date date = result.getDate(2);
                    String engine = metadata.getDatabaseProductName();
                    CitationImpl c = new CitationImpl(CitationImpl.EPSG);
                    c.getAlternateTitles().add(new SimpleInternationalString("EPSG database version " + version + " on " + engine));
                    c.setEdition(new SimpleInternationalString(version));
                    c.setEditionDate(date);
                    this.authority = c;
                } else {
                    this.authority = CitationImpl.EPSG;
                }
                result.close();
                statement.close();
            }
            catch (SQLException exception) {
                Utilities.unexpectedException(LOGGER.getName(), "FactoryUsingSQL", "getAuthority", exception);
                return CitationImpl.EPSG;
            }
        }
        return this.authority;
    }

    public synchronized String getBackingStoreDescription() throws FactoryException {
        String lineSeparator = System.getProperty("line.separator", "\r");
        StringBuffer buffer = new StringBuffer();
        Citation authority = this.getAuthority();
        Object s = authority.getEdition();
        if (s != null) {
            buffer.append("EPSG version:    ");
            buffer.append((CharSequence)s);
            buffer.append(lineSeparator);
        }
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            s = metadata.getDatabaseProductName();
            if (s != null) {
                buffer.append("Database engine: ");
                buffer.append((CharSequence)s);
                s = metadata.getDatabaseProductVersion();
                if (s != null) {
                    buffer.append(" version ");
                    buffer.append((CharSequence)s);
                }
                buffer.append(lineSeparator);
            }
            if ((s = metadata.getURL()) != null) {
                buffer.append("Database URL:    ");
                buffer.append((CharSequence)s);
                buffer.append(lineSeparator);
            }
        }
        catch (SQLException exception) {
            throw new FactoryException((Exception)exception);
        }
        return buffer.toString();
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private PreparedStatement prepareStatement(String key, String sql) throws SQLException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        PreparedStatement stmt = (PreparedStatement)this.statements.get(key);
        if (stmt == null) {
            stmt = this.connection.prepareStatement(this.adaptSQL(sql));
            this.statements.put(key, stmt);
        }
        return stmt;
    }

    private static String getString(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        String str = result.getString(columnIndex);
        if (result.wasNull()) {
            String column = result.getMetaData().getColumnName(columnIndex);
            result.close();
            throw new FactoryException(Resources.format(116, code, column));
        }
        return str.trim();
    }

    private static double getDouble(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        double value = result.getDouble(columnIndex);
        if (result.wasNull()) {
            String column = result.getMetaData().getColumnName(columnIndex);
            result.close();
            throw new FactoryException(Resources.format(116, code, column));
        }
        return value;
    }

    private static int getInt(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        int value = result.getInt(columnIndex);
        if (result.wasNull()) {
            String column = result.getMetaData().getColumnName(columnIndex);
            result.close();
            throw new FactoryException(Resources.format(116, code, column));
        }
        return value;
    }

    private static Object ensureSingleton(Object newValue, Object oldValue, String code) throws FactoryException {
        if (oldValue == null) {
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return oldValue;
        }
        throw new FactoryException(Resources.format(75, code));
    }

    private String prepend(String key) {
        int base = this.prefix.length();
        if (base != 0) {
            this.prefix.append(key);
            key = this.prefix.toString();
            this.prefix.setLength(base);
        }
        return key;
    }

    private Map createProperties(String name, String code, String remarks) throws SQLException, FactoryException {
        Citation authority = this.getAuthority();
        if (this.prefix.length() == 0) {
            this.properties.clear();
        }
        if (name != null) {
            this.properties.put(this.prepend("name"), new NamedIdentifier(authority, name.trim()));
        }
        if (code != null) {
            this.properties.put(this.prepend("identifiers"), new NamedIdentifier(authority, code.trim()));
        }
        if (remarks != null && (remarks = remarks.trim()).length() != 0) {
            this.properties.put(this.prepend("remarks"), remarks);
        }
        ArrayList<LocalName> alias = null;
        PreparedStatement stmt = this.prepareStatement("Alias", "SELECT NAMING_SYSTEM_NAME, ALIAS FROM [Alias] INNER JOIN [Naming System] ON [Alias].NAMING_SYSTEM_CODE = [Naming System].NAMING_SYSTEM_CODE WHERE OBJECT_CODE = ?");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            org.geotools.util.GenericName generic;
            String scope = result.getString(1);
            String local = FactoryUsingSQL.getString(result, 2, code);
            if (scope == null) {
                generic = new LocalName(local);
            } else {
                LocalName cached = (LocalName)this.scopes.get(scope);
                if (cached == null) {
                    cached = new LocalName(scope);
                    this.scopes.put(scope, cached);
                }
                generic = new ScopedName(cached, local);
            }
            if (alias == null) {
                alias = new ArrayList<LocalName>();
            }
            alias.add((LocalName)generic);
        }
        result.close();
        if (alias != null) {
            this.properties.put(this.prepend("alias"), alias.toArray(new GenericName[alias.size()]));
        }
        return this.properties;
    }

    private Map createProperties(String name, String code, String area, String scope, String remarks) throws SQLException, FactoryException {
        Map properties = this.createProperties(name, code, remarks);
        if (area != null && (area = area.trim()).length() != 0) {
            Extent extent = this.buffered.createExtent(area);
            properties.put(this.prepend("validArea"), extent);
        }
        if (scope != null && (scope = scope.trim()).length() != 0) {
            properties.put(this.prepend("scope"), scope);
        }
        return properties;
    }

    public synchronized IdentifiedObject createObject(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        String KEY = "IdentifiedObject";
        PreparedStatement stmt = (PreparedStatement)this.statements.get("IdentifiedObject");
        StringBuffer query = null;
        String epsg = this.trimAuthority(code);
        for (int i = -2; i < OBJECT_TABLES.length; i += 2) {
            if (i == this.lastObjectType) continue;
            try {
                if (i >= 0) {
                    String table = OBJECT_TABLES[i];
                    String column = OBJECT_TABLES[i + 1];
                    if (query == null) {
                        query = new StringBuffer("SELECT ");
                    }
                    query.setLength(7);
                    query.append(column);
                    query.append(" FROM ");
                    query.append(table);
                    query.append(" WHERE ");
                    query.append(column);
                    query.append(" = ?");
                    if (!$assertionsDisabled && this.statements.containsKey("IdentifiedObject")) {
                        throw new AssertionError();
                    }
                    stmt = this.prepareStatement("IdentifiedObject", query.toString());
                }
                stmt.setString(1, epsg);
                ResultSet result = stmt.executeQuery();
                boolean present = result.next();
                result.close();
                if (present) {
                    if (i >= 0) {
                        this.lastObjectType = i;
                    }
                    switch (this.lastObjectType) {
                        case 0: {
                            return this.buffered.createCoordinateReferenceSystem(code);
                        }
                        case 2: {
                            return this.buffered.createCoordinateSystem(code);
                        }
                        case 4: {
                            return this.buffered.createCoordinateSystemAxis(code);
                        }
                        case 6: {
                            return this.buffered.createDatum(code);
                        }
                        case 8: {
                            return this.buffered.createEllipsoid(code);
                        }
                        case 10: {
                            return this.buffered.createPrimeMeridian(code);
                        }
                    }
                    throw new AssertionError(i);
                }
                this.statements.remove("IdentifiedObject");
                stmt.close();
                continue;
            }
            catch (SQLException exception) {
                throw FactoryUsingSQL.databaseFailure(IdentifiedObject.class, code, exception);
            }
        }
        return super.createObject(code);
    }

    public synchronized Unit createUnit(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        Unit returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Unit", "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE FROM [Unit of Measure] WHERE UOM_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                int source = FactoryUsingSQL.getInt(result, 1, code);
                double b = result.getDouble(2);
                double c = result.getDouble(3);
                int target = FactoryUsingSQL.getInt(result, 4, code);
                Unit base = FactoryUsingSQL.getUnit(target);
                if (base == null) {
                    throw this.noSuchAuthorityCode(Unit.class, String.valueOf(target));
                }
                Unit unit = FactoryUsingSQL.getUnit(source);
                if (unit == null) {
                    if (b != 0.0 && c != 0.0) {
                        unit = b == c ? base : base.multiply(b / c);
                    } else {
                        throw new FactoryException("Unsupported unit: " + code);
                    }
                }
                returnValue = (Unit)FactoryUsingSQL.ensureSingleton(unit, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw FactoryUsingSQL.databaseFailure(Unit.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Unit.class, code);
        }
        return returnValue;
    }

    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        Ellipsoid returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Ellipsoid", "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS FROM [Ellipsoid] WHERE ELLIPSOID_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Ellipsoid ellipsoid;
                String epsg = FactoryUsingSQL.getString(result, 1, code);
                String name = FactoryUsingSQL.getString(result, 2, code);
                double semiMajorAxis = FactoryUsingSQL.getDouble(result, 3, code);
                double inverseFlattening = result.getDouble(4);
                double semiMinorAxis = result.getDouble(5);
                String unitCode = FactoryUsingSQL.getString(result, 6, code);
                String remarks = result.getString(7);
                Unit unit = this.buffered.createUnit(unitCode);
                Map properties = this.createProperties(name, epsg, remarks);
                if (inverseFlattening == 0.0) {
                    if (semiMinorAxis == 0.0) {
                        String column = result.getMetaData().getColumnName(3);
                        result.close();
                        throw new FactoryException(Resources.format(116, code, column));
                    }
                    ellipsoid = this.factories.getDatumFactory().createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
                } else {
                    if (semiMinorAxis != 0.0) {
                        LOGGER.warning(Resources.format(65));
                    }
                    ellipsoid = this.factories.getDatumFactory().createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
                }
                returnValue = (Ellipsoid)FactoryUsingSQL.ensureSingleton(ellipsoid, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw FactoryUsingSQL.databaseFailure(Ellipsoid.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code);
        }
        return returnValue;
    }

    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        PrimeMeridian returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("PrimeMeridian", "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS FROM [Prime Meridian] WHERE PRIME_MERIDIAN_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String epsg = FactoryUsingSQL.getString(result, 1, code);
                String name = FactoryUsingSQL.getString(result, 2, code);
                double longitude = FactoryUsingSQL.getDouble(result, 3, code);
                String unit_code = FactoryUsingSQL.getString(result, 4, code);
                String remarks = result.getString(5);
                Unit unit = this.buffered.createUnit(unit_code);
                Map properties = this.createProperties(name, epsg, remarks);
                PrimeMeridian primeMeridian = this.factories.getDatumFactory().createPrimeMeridian(properties, longitude, unit);
                returnValue = (PrimeMeridian)FactoryUsingSQL.ensureSingleton(primeMeridian, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw FactoryUsingSQL.databaseFailure(PrimeMeridian.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code);
        }
        return returnValue;
    }

    public synchronized Extent createExtent(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        Extent returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Area", "SELECT AREA_OF_USE, AREA_SOUTH_BOUND_LAT, AREA_NORTH_BOUND_LAT, AREA_WEST_BOUND_LON, AREA_EAST_BOUND_LON FROM [Area] WHERE AREA_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                ExtentImpl extent = null;
                String description = result.getString(1);
                if (description != null) {
                    extent = new ExtentImpl();
                    extent.setDescription(new SimpleInternationalString(description));
                }
                double ymin = result.getDouble(2);
                if (!result.wasNull()) {
                    double ymax = result.getDouble(3);
                    if (!result.wasNull()) {
                        double xmin = result.getDouble(4);
                        if (!result.wasNull()) {
                            double xmax = result.getDouble(5);
                            if (!result.wasNull()) {
                                if (extent == null) {
                                    extent = new ExtentImpl();
                                }
                                extent.setGeographicElements(Collections.singleton(new GeographicBoundingBoxImpl(xmin, xmax, ymin, ymax)));
                            }
                        }
                    }
                }
                if (extent == null) continue;
                returnValue = (Extent)FactoryUsingSQL.ensureSingleton(extent.unmodifiable(), returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw FactoryUsingSQL.databaseFailure(Extent.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Extent.class, code);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BursaWolfParameters[] createBursaWolfParameters(String code, ResultSet toClose) throws SQLException, FactoryException {
        if (this.safetyGuard.contains(code)) {
            return null;
        }
        ArrayList<Info> list = null;
        PreparedStatement stmt = this.prepareStatement("BursaWolfParametersSet", "SELECT MIN(CO.COORD_OP_CODE), MIN(CO.COORD_OP_METHOD_CODE), CRS2.DATUM_CODE FROM ([Coordinate_Operation] AS CO INNER JOIN [Coordinate Reference System] AS CRS1 ON CO.SOURCE_CRS_CODE = CRS1.COORD_REF_SYS_CODE) INNER JOIN [Coordinate Reference System] AS CRS2 ON CO.TARGET_CRS_CODE = CRS2.COORD_REF_SYS_CODE WHERE CO.COORD_OP_METHOD_CODE >= 9603 AND CO.COORD_OP_METHOD_CODE <= 9607 AND CRS1.DATUM_CODE = ? GROUP BY CRS2.DATUM_CODE");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            if (list == null) {
                list = new ArrayList<Info>();
            }
            list.add(new Info(FactoryUsingSQL.getString(result, 1, code), FactoryUsingSQL.getInt(result, 2, code), FactoryUsingSQL.getString(result, 3, code)));
        }
        result.close();
        if (list == null) {
            return null;
        }
        toClose.close();
        stmt = this.prepareStatement("BursaWolfParameters", "SELECT PARAMETER_CODE, PARAMETER_VALUE, UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE COORD_OP_CODE = ? AND COORD_OP_METHOD_CODE = ?");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            GeodeticDatum datum;
            Info info = (Info)list.get(i);
            try {
                this.safetyGuard.add(code);
                datum = this.buffered.createGeodeticDatum(info.target);
            }
            finally {
                this.safetyGuard.remove(code);
            }
            BursaWolfParameters parameters = new BursaWolfParameters(datum);
            stmt.setString(1, info.operation);
            stmt.setInt(2, info.method);
            result = stmt.executeQuery();
            while (result.next()) {
                FactoryUsingSQL.setBursaWolfParameter(parameters, FactoryUsingSQL.getInt(result, 1, info.operation), FactoryUsingSQL.getDouble(result, 2, info.operation), this.buffered.createUnit(FactoryUsingSQL.getString(result, 3, info.operation)));
            }
            result.close();
            if (info.method == 9607) {
                parameters.ex = -parameters.ex;
                parameters.ey = -parameters.ey;
                parameters.ey = -parameters.ey;
            }
            list.set(i, (Info)((Object)parameters));
        }
        return list.toArray(new BursaWolfParameters[size]);
    }

    public synchronized Datum createDatum(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        Datum returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("Datum", "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, REALIZATION_EPOCH, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE FROM [Datum] WHERE DATUM_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                VerticalDatum datum;
                String epsg = FactoryUsingSQL.getString(result, 1, code);
                String name = FactoryUsingSQL.getString(result, 2, code);
                String type = FactoryUsingSQL.getString(result, 3, code);
                String anchor = result.getString(4);
                int epoch = result.getInt(5);
                String area = result.getString(6);
                String scope = result.getString(7);
                String remarks = result.getString(8);
                HashMap<String, Object> properties = this.createProperties(name, epsg, area, scope, remarks);
                if (anchor != null) {
                    properties.put("anchorPoint", anchor);
                }
                if (epoch != 0) {
                    this.calendar.clear();
                    this.calendar.set(epoch, 0, 1);
                    properties.put("realizationEpoch", this.calendar.getTime());
                }
                DatumFactory factory = this.factories.getDatumFactory();
                if (type.equalsIgnoreCase("geodetic")) {
                    properties = new HashMap<String, Object>(properties);
                    Ellipsoid ellipsoid = this.buffered.createEllipsoid(FactoryUsingSQL.getString(result, 9, code));
                    PrimeMeridian meridian = this.buffered.createPrimeMeridian(FactoryUsingSQL.getString(result, 10, code));
                    BursaWolfParameters[] param = this.createBursaWolfParameters(code, result);
                    if (param != null) {
                        result = null;
                        properties.put("bursaWolf", param);
                    }
                    datum = factory.createGeodeticDatum(properties, ellipsoid, meridian);
                } else if (type.equalsIgnoreCase("vertical")) {
                    datum = factory.createVerticalDatum(properties, VerticalDatumType.GEOIDAL);
                } else if (type.equalsIgnoreCase("engineering")) {
                    datum = factory.createEngineeringDatum(properties);
                } else {
                    result.close();
                    throw new FactoryException(Resources.format(122, type));
                }
                returnValue = (Datum)FactoryUsingSQL.ensureSingleton(datum, returnValue, code);
                if (result != null) continue;
                return returnValue;
            }
            result.close();
        }
        catch (SQLException exception) {
            throw FactoryUsingSQL.databaseFailure(Datum.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Datum.class, code);
        }
        return returnValue;
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        throw new FactoryException("Not yet implemented.");
    }

    private CoordinateSystemAxis[] createCoordinateSystemAxis(String code, int dimension) throws SQLException, FactoryException {
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[dimension];
        PreparedStatement stmt = this.prepareStatement("Axis", "SELECT CA.COORD_AXIS_CODE, CAN.COORD_AXIS_NAME, CA.COORD_AXIS_ORIENTATION, CA.COORD_AXIS_ABBREVIATION, CA.UOM_CODE, CAN.DESCRIPTION, CAN.REMARKS FROM [Coordinate Axis] AS CA INNER JOIN [Coordinate Axis Name] AS CAN ON CA.COORD_AXIS_NAME_CODE = CAN.COORD_AXIS_NAME_CODE WHERE CA.COORD_SYS_CODE = ? ORDER BY [CA.ORDER]");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        CSFactory factory = this.factories.getCSFactory();
        int i = 0;
        while (result.next()) {
            AxisDirection direction;
            if (i >= axis.length) continue;
            code = FactoryUsingSQL.getString(result, 1, code);
            String name = FactoryUsingSQL.getString(result, 2, code);
            String orientation = FactoryUsingSQL.getString(result, 3, code);
            String abbreviation = FactoryUsingSQL.getString(result, 4, code);
            String unit = FactoryUsingSQL.getString(result, 5, code);
            String description = result.getString(6);
            String remarks = result.getString(7);
            try {
                direction = DefaultCoordinateSystemAxis.getDirection(orientation);
            }
            catch (NoSuchElementException exception) {
                if (orientation.equalsIgnoreCase("Geocentre > equator/PM")) {
                    direction = AxisDirection.OTHER;
                }
                if (orientation.equalsIgnoreCase("Geocentre > equator/90dE")) {
                    direction = AxisDirection.EAST;
                }
                if (orientation.equalsIgnoreCase("Geocentre > north pole")) {
                    direction = AxisDirection.NORTH;
                }
                throw new FactoryException(Resources.format(122, orientation), (Throwable)exception);
            }
            if (description == null) {
                description = remarks;
            } else if (remarks != null) {
                description = description + System.getProperty("line.separator", "\n") + remarks;
            }
            Map properties = this.createProperties(name, code, description);
            axis[i++] = factory.createCoordinateSystemAxis(properties, abbreviation, direction, this.buffered.createUnit(unit));
        }
        result.close();
        if (i != axis.length) {
            throw new FactoryException(Resources.format(98, new Integer(axis.length), new Integer(i)));
        }
        return axis;
    }

    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        CoordinateSystem returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("CoordinateSystem", "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS FROM [Coordinate System] WHERE COORD_SYS_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String epsg = FactoryUsingSQL.getString(result, 1, code);
                String name = FactoryUsingSQL.getString(result, 2, code);
                String type = FactoryUsingSQL.getString(result, 3, code);
                int dimension = FactoryUsingSQL.getInt(result, 4, code);
                String remarks = result.getString(5);
                CoordinateSystemAxis[] axis = this.createCoordinateSystemAxis(code, dimension);
                Map properties = this.createProperties(name, epsg, remarks);
                CSFactory factory = this.factories.getCSFactory();
                EllipsoidalCS cs = null;
                if (type.equalsIgnoreCase("ellipsoidal")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createEllipsoidalCS(properties, axis[0], axis[1]);
                            break;
                        }
                        case 3: {
                            cs = factory.createEllipsoidalCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equalsIgnoreCase("cartesian")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createCartesianCS(properties, axis[0], axis[1]);
                            break;
                        }
                        case 3: {
                            cs = factory.createCartesianCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equalsIgnoreCase("spherical")) {
                    switch (dimension) {
                        case 3: {
                            cs = factory.createSphericalCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equalsIgnoreCase("gravity-related")) {
                    switch (dimension) {
                        case 1: {
                            cs = factory.createVerticalCS(properties, axis[0]);
                        }
                    }
                } else if (type.equalsIgnoreCase("linear")) {
                    switch (dimension) {
                        case 1: {
                            cs = factory.createLinearCS(properties, axis[0]);
                        }
                    }
                } else if (type.equalsIgnoreCase("polar")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createPolarCS(properties, axis[0], axis[1]);
                        }
                    }
                } else if (type.equalsIgnoreCase("cylindrical")) {
                    switch (dimension) {
                        case 3: {
                            cs = factory.createCylindricalCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equalsIgnoreCase("affine")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createAffineCS(properties, axis[0], axis[1]);
                            break;
                        }
                        case 3: {
                            cs = factory.createAffineCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else {
                    result.close();
                    throw new FactoryException(Resources.format(122, type));
                }
                if (cs == null) {
                    result.close();
                    throw new FactoryException("Unexpected dimensions.");
                }
                returnValue = (CoordinateSystem)FactoryUsingSQL.ensureSingleton(cs, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw FactoryUsingSQL.databaseFailure(CoordinateSystem.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        FactoryUsingSQL.ensureNonNull("code", code);
        CoordinateReferenceSystem returnValue = null;
        try {
            PreparedStatement stmt = this.prepareStatement("CoordinateReferenceSystem", "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?");
            stmt.setString(1, this.trimAuthority(code));
            ResultSet result = stmt.executeQuery();
            do {
                GeographicCRS crs;
                block18: {
                    Map properties;
                    OperationMethod method;
                    GeographicCRS geoCRS;
                    CartesianCS cs;
                    String conversion;
                    String remarks;
                    String scope;
                    String area;
                    String name;
                    String epsg;
                    block22: {
                        Class clazz;
                        block19: {
                            GeodeticDatum datum;
                            EllipsoidalCS cs2;
                            String dmCode;
                            String csCode;
                            CRSFactory factory;
                            String type;
                            block24: {
                                block23: {
                                    block21: {
                                        block20: {
                                            if (!result.next()) break block19;
                                            epsg = FactoryUsingSQL.getString(result, 1, code);
                                            name = FactoryUsingSQL.getString(result, 2, code);
                                            area = result.getString(3);
                                            scope = result.getString(4);
                                            remarks = result.getString(5);
                                            type = FactoryUsingSQL.getString(result, 6, code);
                                            factory = this.factories.getCRSFactory();
                                            if (!type.equalsIgnoreCase("geographic 2D") && !type.equalsIgnoreCase("geographic 3D")) break block20;
                                            csCode = FactoryUsingSQL.getString(result, 7, code);
                                            dmCode = FactoryUsingSQL.getString(result, 8, code);
                                            cs2 = this.buffered.createEllipsoidalCS(csCode);
                                            datum = this.buffered.createGeodeticDatum(dmCode);
                                            crs = factory.createGeographicCRS(this.createProperties(name, epsg, area, scope, remarks), datum, cs2);
                                            break block18;
                                        }
                                        if (!type.equalsIgnoreCase("projected")) break block21;
                                        csCode = FactoryUsingSQL.getString(result, 7, code);
                                        String geoCode = FactoryUsingSQL.getString(result, 9, code);
                                        conversion = FactoryUsingSQL.getString(result, 10, code);
                                        result.close();
                                        cs = this.buffered.createCartesianCS(csCode);
                                        geoCRS = this.buffered.createGeographicCRS(geoCode);
                                        stmt = this.prepareStatement("Projection", "SELECT COORD_OP_NAME, AREA_OF_USE_CODE, COORD_OP_SCOPE, COORD_OP_METHOD_CODE, REMARKS FROM [Coordinate_Operation] WHERE COORD_OP_CODE = ?");
                                        stmt.setString(1, conversion);
                                        result = stmt.executeQuery();
                                        method = null;
                                        properties = null;
                                        break block22;
                                    }
                                    if (!type.equalsIgnoreCase("vertical")) break block23;
                                    csCode = FactoryUsingSQL.getString(result, 7, code);
                                    dmCode = FactoryUsingSQL.getString(result, 8, code);
                                    cs2 = this.buffered.createVerticalCS(csCode);
                                    datum = this.buffered.createVerticalDatum(dmCode);
                                    crs = factory.createVerticalCRS(this.createProperties(name, epsg, area, scope, remarks), (VerticalDatum)datum, (VerticalCS)cs2);
                                    break block18;
                                }
                                if (!type.equalsIgnoreCase("compound")) break block24;
                                String code1 = FactoryUsingSQL.getString(result, 11, code);
                                String code2 = FactoryUsingSQL.getString(result, 12, code);
                                result.close();
                                result = null;
                                CoordinateReferenceSystem crs1 = this.buffered.createCoordinateReferenceSystem(code1);
                                CoordinateReferenceSystem crs2 = this.buffered.createCoordinateReferenceSystem(code2);
                                crs = factory.createCompoundCRS(this.createProperties(name, epsg, area, scope, remarks), new CoordinateReferenceSystem[]{crs1, crs2});
                                break block18;
                            }
                            if (type.equalsIgnoreCase("geocentric")) {
                                csCode = FactoryUsingSQL.getString(result, 7, code);
                                dmCode = FactoryUsingSQL.getString(result, 8, code);
                                cs2 = this.buffered.createCoordinateSystem(csCode);
                                datum = this.buffered.createGeodeticDatum(dmCode);
                                Map properties2 = this.createProperties(name, epsg, area, scope, remarks);
                                if (cs2 instanceof CartesianCS) {
                                    crs = factory.createGeocentricCRS(properties2, datum, (CartesianCS)cs2);
                                    break block18;
                                } else {
                                    if (!(cs2 instanceof SphericalCS)) {
                                        result.close();
                                        throw new FactoryException("Incompatible CS type.");
                                    }
                                    crs = factory.createGeocentricCRS(properties2, datum, (SphericalCS)cs2);
                                }
                                break block18;
                            } else {
                                if (!type.equalsIgnoreCase("engineering")) {
                                    result.close();
                                    throw new FactoryException(Resources.format(122, code));
                                }
                                csCode = FactoryUsingSQL.getString(result, 7, code);
                                dmCode = FactoryUsingSQL.getString(result, 8, code);
                                cs2 = this.buffered.createCoordinateSystem(csCode);
                                datum = this.buffered.createEngineeringDatum(dmCode);
                                crs = factory.createEngineeringCRS(this.createProperties(name, epsg, area, scope, remarks), (EngineeringDatum)datum, (CoordinateSystem)cs2);
                            }
                            break block18;
                        }
                        result.close();
                        if (returnValue != null) return returnValue;
                        if (class$org$opengis$referencing$crs$CoordinateReferenceSystem == null) {
                            clazz = class$org$opengis$referencing$crs$CoordinateReferenceSystem = FactoryUsingSQL.class$("org.opengis.referencing.crs.CoordinateReferenceSystem");
                            throw this.noSuchAuthorityCode(clazz, code);
                        }
                        clazz = class$org$opengis$referencing$crs$CoordinateReferenceSystem;
                        throw this.noSuchAuthorityCode(clazz, code);
                    }
                    while (result.next()) {
                        String opName = FactoryUsingSQL.getString(result, 1, conversion);
                        String opArea = result.getString(2);
                        String opScope = result.getString(3);
                        String opCode = FactoryUsingSQL.getString(result, 4, conversion);
                        String opRemarks = result.getString(5);
                        method = (OperationMethod)FactoryUsingSQL.ensureSingleton(this.createOperationMethod(opCode, conversion, 2, 2, true), method, code);
                        properties = this.createProperties(name, epsg, area, scope, remarks);
                        if (!$assertionsDisabled && this.prefix.length() != 0) {
                            throw new AssertionError(this.prefix);
                        }
                        try {
                            this.prefix.append("conversion.");
                            properties = this.createProperties(opName, conversion, opArea, opScope, opRemarks);
                        }
                        finally {
                            this.prefix.setLength(0);
                        }
                    }
                    if (method == null) {
                        Class clazz;
                        if (class$org$opengis$referencing$operation$Projection == null) {
                            clazz = class$org$opengis$referencing$operation$Projection = FactoryUsingSQL.class$("org.opengis.referencing.operation.Projection");
                            throw this.noSuchAuthorityCode(clazz, conversion);
                        }
                        clazz = class$org$opengis$referencing$operation$Projection;
                        throw this.noSuchAuthorityCode(clazz, conversion);
                    }
                    result.close();
                    result = null;
                    ParameterValueGroup parameters = (ParameterValueGroup)method.getParameters().createValue();
                    Ellipsoid ellipsoid = ((GeodeticDatum)geoCRS.getDatum()).getEllipsoid();
                    Unit axisUnit = ellipsoid.getAxisUnit();
                    parameters.parameter("semi-major axis").setValue(ellipsoid.getSemiMajorAxis(), axisUnit);
                    parameters.parameter("semi-minor axis").setValue(ellipsoid.getSemiMinorAxis(), axisUnit);
                    crs = this.factories.createProjectedCRS(properties, geoCRS, method, parameters, cs);
                }
                returnValue = (CoordinateReferenceSystem)FactoryUsingSQL.ensureSingleton(crs, returnValue, code);
            } while (result != null);
            return returnValue;
        }
        catch (SQLException exception) {
            Class clazz;
            if (class$org$opengis$referencing$crs$CoordinateReferenceSystem == null) {
                clazz = class$org$opengis$referencing$crs$CoordinateReferenceSystem = FactoryUsingSQL.class$("org.opengis.referencing.crs.CoordinateReferenceSystem");
                throw FactoryUsingSQL.databaseFailure(clazz, code, exception);
            }
            clazz = class$org$opengis$referencing$crs$CoordinateReferenceSystem;
            throw FactoryUsingSQL.databaseFailure(clazz, code, exception);
        }
    }

    private ParameterDescriptor[] createParameters(String method, String operation, boolean isProjection) throws SQLException, FactoryException {
        ArrayList<ParameterDescriptor> descriptors = new ArrayList<ParameterDescriptor>();
        if (isProjection) {
            descriptors.add(MapProjection.AbstractProvider.SEMI_MAJOR);
            descriptors.add(MapProjection.AbstractProvider.SEMI_MINOR);
        }
        PreparedStatement stmt = this.prepareStatement("Parameters", "SELECT CP.PARAMETER_NAME, CP.DESCRIPTION, CV.PARAMETER_VALUE, CV.PARAM_VALUE_FILE_REF, CV.UOM_CODE FROM ([Coordinate_Operation Parameter] AS CP INNER JOIN [Coordinate_Operation Parameter Value] AS CV ON CV.PARAMETER_CODE = CP.PARAMETER_CODE) INNER JOIN [Coordinate_Operation Parameter Usage] AS CU ON (CP.PARAMETER_CODE = CU.PARAMETER_CODE) AND (CV.COORD_OP_METHOD_CODE = CU.COORD_OP_METHOD_CODE) WHERE CV.COORD_OP_METHOD_CODE = ? AND CV.COORD_OP_CODE = ? ORDER BY CU.SORT_ORDER");
        stmt.setString(1, method);
        stmt.setString(2, operation);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            DefaultParameterDescriptor parameter;
            String name = FactoryUsingSQL.getString(result, 1, operation);
            String remarks = result.getString(2);
            double value = result.getDouble(3);
            if (!result.wasNull()) {
                Unit unit = this.buffered.createUnit(FactoryUsingSQL.getString(result, 5, operation));
                Map properties = this.createProperties(name, null, remarks);
                parameter = new DefaultParameterDescriptor(properties, value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, unit, true);
            } else {
                Object ref = FactoryUsingSQL.getString(result, 4, operation);
                try {
                    ref = new URI((String)ref);
                }
                catch (URISyntaxException exception) {
                    ref = new File((String)ref);
                }
                parameter = new DefaultParameterDescriptor(name, remarks, ref, true);
            }
            descriptors.add(parameter);
        }
        result.close();
        return descriptors.toArray(new ParameterDescriptor[descriptors.size()]);
    }

    private OperationMethod createOperationMethod(String code, String operation, int sourceDimensions, int targetDimensions, boolean isProjection) throws SQLException, FactoryException {
        OperationMethod returnValue = null;
        PreparedStatement stmt = this.prepareStatement("OperationMethod", "SELECT COORD_OP_METHOD_NAME, FORMULA, REMARKS FROM [Coordinate_Operation Method] WHERE COORD_OP_METHOD_CODE = ?");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        ParameterDescriptor[] descriptors = null;
        DefaultOperationMethod method = null;
        while (result.next()) {
            String name = FactoryUsingSQL.getString(result, 1, code);
            String formula = result.getString(2);
            String remarks = result.getString(3);
            if (descriptors == null) {
                descriptors = this.createParameters(code, operation, isProjection);
            }
            Map properties = this.createProperties(name, code, remarks);
            if (formula != null) {
                properties.put("formula", formula);
            }
            method = new DefaultOperationMethod(properties, sourceDimensions, targetDimensions, new DefaultParameterDescriptorGroup(properties, (GeneralParameterDescriptor[])descriptors));
            returnValue = (OperationMethod)FactoryUsingSQL.ensureSingleton(method, returnValue, code);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    protected String adaptSQL(String statement) {
        return statement;
    }

    public synchronized void dispose() throws FactoryException {
        try {
            Iterator it = this.statements.values().iterator();
            while (it.hasNext()) {
                ((PreparedStatement)it.next()).close();
                it.remove();
            }
            this.shutdown(true);
            this.connection.close();
        }
        catch (SQLException exception) {
            throw new FactoryException((Exception)exception);
        }
        super.dispose();
        LOGGER.fine("EPSG connection closed.");
    }

    void shutdown(boolean active) throws SQLException {
    }

    protected final void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static FactoryException databaseFailure(Class type, String code, SQLException cause) {
        return new FactoryException("Database failure will constructing a " + Utilities.getShortName(type) + "for code \"" + code + "\".", (Throwable)cause);
    }

    static {
        $assertionsDisabled = !FactoryUsingSQL.class.desiredAssertionStatus();
        OBJECT_TABLES = new String[]{"[Coordinate Reference System]", "COORD_REF_SYS_CODE", "[Coordinate System]", "COORD_SYS_CODE", "[Coordinate Axis]", "COORD_AXIS_CODE", "[Datum]", "DATUM_CODE", "[Ellipsoid]", "ELLIPSOID_CODE", "[Prime Meridian]", "PRIME_MERIDIAN_CODE"};
    }

    private static final class Info {
        final String operation;
        final int method;
        final String target;

        Info(String operation, int method, String target) {
            this.operation = operation;
            this.method = method;
            this.target = target;
        }
    }
}

