/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;

public class FactoryUsingWKT
extends DeferredAuthorityFactory {
    public static final String FILENAME = "epsg.properties";

    public FactoryUsingWKT() {
        super(new FactoryGroup(), 21);
        this.setTimeout(900000L);
    }

    public Citation getAuthority() {
        return CitationImpl.EPSG;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = FactoryUsingWKT.class.getResource(FILENAME);
            if (url == null) {
                throw new FileNotFoundException(FILENAME);
            }
            LOGGER.config("Using \"" + url.getPath() + "\" as EPSG factory.");
            return new PropertyAuthorityFactory(this.factories, this.getAuthority(), url);
        }
        catch (IOException exception) {
            throw new FactoryException("Failed to read \"epsg.properties\".", (Throwable)exception);
        }
    }
}

