/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;

public class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    public final MathTransform transform1;
    public final MathTransform transform2;
    private ConcatenatedTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ConcatenatedTransform(MathTransform transform1, MathTransform transform2) {
        this.transform1 = transform1;
        this.transform2 = transform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Resources.format(71, ConcatenatedTransform.getName(transform1), ConcatenatedTransform.getName(transform2)));
        }
    }

    private static GeneralMatrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)transform).getMatrix();
            if (matrix instanceof GeneralMatrix) {
                return (GeneralMatrix)matrix;
            }
            return new GeneralMatrix(matrix);
        }
        if (transform instanceof AffineTransform) {
            return new GeneralMatrix((AffineTransform)transform);
        }
        return null;
    }

    private static boolean areInverse(MathTransform tr1, MathTransform tr2) {
        if (tr2 instanceof AbstractMathTransform.Inverse) {
            return tr1.equals(((AbstractMathTransform.Inverse)tr2).inverse());
        }
        return false;
    }

    public static MathTransform create(MathTransform tr1, MathTransform tr2) {
        MathTransform optimized;
        ConcatenatedTransform ctr;
        GeneralMatrix matrix2;
        if (tr1.isIdentity()) {
            return tr2;
        }
        if (tr2.isIdentity()) {
            return tr1;
        }
        GeneralMatrix matrix1 = ConcatenatedTransform.getMatrix(tr1);
        if (matrix1 != null && (matrix2 = ConcatenatedTransform.getMatrix(tr2)) != null) {
            GeneralMatrix matrix;
            int numRow = matrix2.getNumRow();
            int numCol = matrix1.getNumCol();
            if (numCol == matrix2.getNumCol()) {
                matrix = matrix2;
                matrix2.mul(matrix1);
            } else {
                matrix = new GeneralMatrix(numRow, numCol);
                matrix.mul(matrix2, matrix1);
            }
            return ProjectiveTransform.create(matrix);
        }
        if (ConcatenatedTransform.areInverse(tr1, tr2) || ConcatenatedTransform.areInverse(tr2, tr1)) {
            if (!$assertionsDisabled && tr1.getSourceDimensions() != tr2.getTargetDimensions()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tr1.getTargetDimensions() != tr2.getSourceDimensions()) {
                throw new AssertionError();
            }
            return IdentityTransform.create(tr1.getSourceDimensions());
        }
        if (tr1 instanceof ConcatenatedTransform) {
            ctr = (ConcatenatedTransform)tr1;
            tr1 = ctr.transform1;
            tr2 = ConcatenatedTransform.create(ctr.transform2, tr2);
        }
        if (tr2 instanceof ConcatenatedTransform) {
            ctr = (ConcatenatedTransform)tr2;
            tr1 = ConcatenatedTransform.create(tr1, ctr.transform1);
            tr2 = ctr.transform2;
        }
        if (tr1 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr1).concatenate(tr2, false)) != null) {
            return optimized;
        }
        if (tr2 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr2).concatenate(tr1, true)) != null) {
            return optimized;
        }
        return ConcatenatedTransform.createConcatenatedTransform(tr1, tr2);
    }

    static ConcatenatedTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) {
        int dimSource = tr1.getSourceDimensions();
        int dimTarget = tr2.getTargetDimensions();
        if (dimSource == 1 && dimTarget == 1) {
            if (tr1 instanceof MathTransform1D && tr2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)tr1, (MathTransform1D)tr2);
            }
            return new ConcatenatedTransform1D(tr1, tr2);
        }
        if (dimSource == 2 && dimTarget == 2) {
            if (tr1 instanceof MathTransform2D && tr2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)tr1, (MathTransform2D)tr2);
            }
            return new ConcatenatedTransform2D(tr1, tr2);
        }
        if (dimSource == tr1.getTargetDimensions() && tr2.getSourceDimensions() == dimTarget) {
            return new ConcatenatedTransformDirect(tr1, tr2);
        }
        return new ConcatenatedTransform(tr1, tr2);
    }

    private static final String getName(MathTransform transform) {
        String name;
        ParameterValueGroup params;
        if (transform instanceof AbstractMathTransform && (params = ((AbstractMathTransform)transform).getParameterValues()) != null && (name = params.getDescriptor().getName().getCode()) != null && (name = name.trim()).length() != 0) {
            return name;
        }
        return Utilities.getShortClassName(transform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        return this.transform2.transform(this.transform1.transform(ptSrc, null), ptDst);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        double[] tmp = new double[numPts * this.transform1.getTargetDimensions()];
        this.transform1.transform(srcPts, srcOff, tmp, 0, numPts);
        this.transform2.transform(tmp, 0, dstPts, dstOff, numPts);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        float[] tmp = new float[numPts * this.transform1.getTargetDimensions()];
        this.transform1.transform(srcPts, srcOff, tmp, 0, numPts);
        this.transform2.transform(tmp, 0, dstPts, dstOff, numPts);
    }

    public final synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        if (this.inverse == null) {
            this.inverse = ConcatenatedTransform.createConcatenatedTransform(this.transform2.inverse(), this.transform1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    public Matrix derivative(Point2D point) throws TransformException {
        return this.derivative(new GeneralDirectPosition(point));
    }

    public Matrix derivative(DirectPosition point) throws TransformException {
        GeneralMatrix matrix;
        Matrix matrix1 = this.transform1.derivative(point);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(point, null));
        int numRow = matrix2.getNumRow();
        int numCol = matrix1.getNumCol();
        if (numCol == matrix2.getNumCol()) {
            matrix = ConcatenatedTransform.wrap(matrix2);
            matrix.mul(ConcatenatedTransform.wrap(matrix1));
        } else {
            matrix = new GeneralMatrix(numRow, numCol);
            matrix.mul(ConcatenatedTransform.wrap(matrix2), ConcatenatedTransform.wrap(matrix1));
        }
        return matrix;
    }

    public final boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    public final int hashCode() {
        return this.transform1.hashCode() + 37 * this.transform2.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ConcatenatedTransform that = (ConcatenatedTransform)object;
            return Utilities.equals(this.transform1, that.transform1) && Utilities.equals(this.transform2, that.transform2);
        }
        return false;
    }

    protected String formatWKT(Formatter formatter) {
        ConcatenatedTransform.addWKT(formatter, this.transform1);
        ConcatenatedTransform.addWKT(formatter, this.transform2);
        return "CONCAT_MT";
    }

    private static void addWKT(Formatter formatter, MathTransform transform) {
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concat = (ConcatenatedTransform)transform;
            ConcatenatedTransform.addWKT(formatter, concat.transform1);
            ConcatenatedTransform.addWKT(formatter, concat.transform2);
        } else {
            formatter.append(transform);
        }
    }

    static {
        $assertionsDisabled = !ConcatenatedTransform.class.desiredAssertionStatus();
    }
}

