/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.LogarithmicTransform1D;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

public class ExponentialTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = 5331178990358868947L;
    public final double base;
    final double lnBase;
    public final double scale;
    private MathTransform inverse;
    static /* synthetic */ Class class$org$opengis$referencing$operation$Conversion;

    ExponentialTransform1D(LogarithmicTransform1D inverse) {
        this.base = inverse.base;
        this.lnBase = inverse.lnBase;
        this.scale = Math.pow(this.base, -inverse.offset);
        this.inverse = inverse;
    }

    protected ExponentialTransform1D(double base, double scale) {
        this.base = base;
        this.scale = scale;
        this.lnBase = Math.log(base);
    }

    public static MathTransform1D create(double base, double scale) {
        if (base == 0.0 || scale == 0.0) {
            return LinearTransform1D.create(0.0, 0.0);
        }
        if (base == 1.0) {
            return LinearTransform1D.create(0.0, scale);
        }
        return new ExponentialTransform1D(base, scale);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])new ParameterValue[]{new FloatParameter(Provider.BASE, this.base), new FloatParameter(Provider.SCALE, this.scale)});
    }

    public int getSourceDimensions() {
        return 1;
    }

    public int getTargetDimensions() {
        return 1;
    }

    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new LogarithmicTransform1D(this);
        }
        return this.inverse;
    }

    public double derivative(double value) {
        return this.lnBase * this.transform(value);
    }

    public double transform(double value) {
        return this.scale * Math.pow(this.base, value);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(this.scale * Math.pow(this.base, srcPts[srcOff++]));
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(this.scale * Math.pow(this.base, srcPts[--srcOff]));
            }
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.scale * Math.pow(this.base, srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.scale * Math.pow(this.base, srcPts[--srcOff]);
            }
        }
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        if (other instanceof LinearTransform) {
            LinearTransform1D linear = (LinearTransform1D)other;
            if (applyOtherFirst) {
                double newBase = Math.pow(this.base, linear.scale);
                double newScale = Math.pow(this.base, linear.offset) * this.scale;
                if (!Double.isNaN(newBase) && !Double.isNaN(newScale)) {
                    return ExponentialTransform1D.create(newBase, newScale);
                }
            } else if (linear.offset == 0.0) {
                return ExponentialTransform1D.create(this.base, this.scale * linear.scale);
            }
        } else if (other instanceof LogarithmicTransform1D) {
            return this.concatenateLog((LogarithmicTransform1D)other, applyOtherFirst);
        }
        return super.concatenate(other, applyOtherFirst);
    }

    MathTransform concatenateLog(LogarithmicTransform1D other, boolean applyOtherFirst) {
        if (applyOtherFirst) {
            double newScale = this.scale * Math.pow(this.base, other.offset);
            double newPower = this.lnBase / other.lnBase;
            if (!Double.isNaN(newScale) && newPower == 1.0) {
                return LinearTransform1D.create(newScale, 0.0);
            }
        } else if (this.scale > 0.0) {
            return LinearTransform1D.create(this.lnBase / other.lnBase, Math.log(this.scale) / other.lnBase + other.offset);
        }
        return null;
    }

    public int hashCode() {
        long code = 5331178990358868947L + Double.doubleToLongBits(this.base);
        code = code * 37L + Double.doubleToLongBits(this.scale);
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ExponentialTransform1D that = (ExponentialTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(that.base) && Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(that.scale);
        }
        return false;
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -5838840021166379987L;
        public static final ParameterDescriptor BASE = LogarithmicTransform1D.Provider.BASE;
        public static final ParameterDescriptor SCALE = new DefaultParameterDescriptor("scale", 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(18))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{BASE, SCALE});

        public Provider() {
            super(1, 1, PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$Conversion == null ? (class$org$opengis$referencing$operation$Conversion = ExponentialTransform1D.class$("org.opengis.referencing.operation.Conversion")) : class$org$opengis$referencing$operation$Conversion;
        }

        public MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            return ExponentialTransform1D.create(Provider.doubleValue(BASE, values), Provider.doubleValue(SCALE, values));
        }
    }
}

