/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConstantTransform1D;
import org.geotools.referencing.operation.transform.IdentityTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;

public class LinearTransform1D
extends AbstractMathTransform
implements MathTransform1D,
LinearTransform,
Serializable {
    private static final long serialVersionUID = -7595037195668813000L;
    public static final LinearTransform1D IDENTITY = IdentityTransform1D.ONE;
    public final double scale;
    public final double offset;
    private transient MathTransform inverse;

    protected LinearTransform1D(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public static LinearTransform1D create(double scale, double offset) {
        if (scale == 0.0) {
            return new ConstantTransform1D(offset);
        }
        if (scale == 1.0 && offset == 0.0) {
            return IDENTITY;
        }
        return new LinearTransform1D(scale, offset);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return ProjectiveTransform.Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    public int getSourceDimensions() {
        return 1;
    }

    public int getTargetDimensions() {
        return 1;
    }

    public Matrix getMatrix() {
        return new GeneralMatrix(2, 2, new double[]{this.scale, this.offset, 0.0, 1.0});
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else if (this.scale != 0.0) {
                LinearTransform1D inverse = LinearTransform1D.create(1.0 / this.scale, -this.offset / this.scale);
                inverse.inverse = this;
                this.inverse = inverse;
            } else {
                this.inverse = super.inverse();
            }
        }
        return this.inverse;
    }

    public boolean isIdentity() {
        return this.offset == 0.0 && this.scale == 1.0;
    }

    public Matrix derivative(DirectPosition point) throws TransformException {
        return new GeneralMatrix(1, 1, new double[]{this.scale});
    }

    public double derivative(double value) {
        return this.scale;
    }

    public double transform(double value) {
        return this.offset + this.scale * value;
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(this.offset + this.scale * (double)srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(this.offset + this.scale * (double)srcPts[--srcOff]);
            }
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.offset + this.scale * srcPts[srcOff++];
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.offset + this.scale * srcPts[--srcOff];
            }
        }
    }

    public int hashCode() {
        long code = 675810104L + Double.doubleToRawLongBits(this.offset);
        code = code * 37L + Double.doubleToRawLongBits(this.scale);
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LinearTransform1D that = (LinearTransform1D)object;
            return Double.doubleToRawLongBits(this.scale) == Double.doubleToRawLongBits(that.scale) && Double.doubleToRawLongBits(this.offset) == Double.doubleToRawLongBits(that.offset);
        }
        return false;
    }
}

