/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.AbstractSet;
import java.util.Iterator;

public final class LazySet
extends AbstractSet {
    private final Iterator iterator;
    private Object[] elements = new Object[4];
    private int size;

    public LazySet(Iterator iterator) {
        this.iterator = iterator;
    }

    private void addNext() {
        if (this.size >= this.elements.length) {
            Object[] old = this.elements;
            this.elements = new Object[this.size * 2];
            System.arraycopy(old, 0, this.elements, 0, this.size);
        }
        this.elements[this.size++] = this.iterator.next();
    }

    public Iterator iterator() {
        return new Iter();
    }

    public int size() {
        while (this.iterator.hasNext()) {
            this.addNext();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0 && !this.iterator.hasNext();
    }

    final boolean exists(int index) {
        return index < this.size || this.iterator.hasNext();
    }

    public Object get(int index) {
        while (index >= this.size) {
            if (!this.iterator.hasNext()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.addNext();
        }
        return this.elements[index];
    }

    private final class Iter
    implements Iterator {
        private int cursor;

        private Iter() {
        }

        public boolean hasNext() {
            return LazySet.this.exists(this.cursor);
        }

        public Object next() {
            return LazySet.this.get(this.cursor++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

