/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.opengis.util.Cloneable;

public class ExternalGraphicImpl
implements ExternalGraphic,
Symbol,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private URL location = null;
    private String format = null;
    private String uri = null;
    private Map customProps = null;

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getFormat() {
        return this.format;
    }

    public URL getLocation() throws MalformedURLException {
        if (this.location == null) {
            this.location = new URL(this.uri);
        }
        return this.location;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLocation(URL location) {
        this.uri = location.toString();
        this.location = location;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.format != null) {
            result = 1000003 * result + this.format.hashCode();
        }
        if (this.uri != null) {
            result = 1000003 * result + this.uri.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof ExternalGraphicImpl) {
            ExternalGraphicImpl other = (ExternalGraphicImpl)oth;
            return Utilities.equals(this.uri, other.uri) && Utilities.equals(this.format, other.format);
        }
        return false;
    }

    public Map getCustomProperties() {
        return this.customProps;
    }

    public void setCustomProperties(Map list) {
        this.customProps = list;
    }
}

