/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.geotools.resources.Utilities;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.StyleVisitor;
import org.opengis.util.Cloneable;

public class HaloImpl
implements Halo,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private Fill fill = new FillImpl();
    private Expression radius = null;

    public HaloImpl() {
        try {
            this.radius = filterFactory.createLiteralExpression(new Integer(1));
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultHalo: " + ife);
        }
        this.fill.setColor(filterFactory.createLiteralExpression("#FFFFFF"));
    }

    public Fill getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        this.fill = fill;
    }

    public Expression getRadius() {
        return this.radius;
    }

    public void setRadius(Expression radius) {
        this.radius = radius;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            HaloImpl clone = (HaloImpl)super.clone();
            clone.fill = (Fill)((Cloneable)this.fill).clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HaloImpl) {
            HaloImpl other = (HaloImpl)obj;
            return Utilities.equals(this.radius, other.radius) && Utilities.equals(this.fill, other.fill);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.radius != null) {
            result = result * 37 + this.radius.hashCode();
        }
        if (this.fill != null) {
            result = result * 37 + this.fill.hashCode();
        }
        return result;
    }
}

