/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;

public class RasterSymbolizerImpl
implements RasterSymbolizer {
    private FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private ChannelSelection channelSelction = new ChannelSelectionImpl();
    private ColorMap colorMap = new ColorMapImpl();
    private ContrastEnhancement contrastEnhancement = new ContrastEnhancementImpl();
    private ShadedRelief shadedRelief = new ShadedReliefImpl();
    private String geometryName = "raster";
    private Symbolizer symbolizer;
    private Expression opacity = this.filterFactory.createLiteralExpression(1.0);
    private Expression overlap = this.filterFactory.createLiteralExpression("Random");

    public int hashcode() {
        int key = 0;
        key = this.channelSelction.hashCode();
        key = key * 13 + this.colorMap.hashCode();
        key = key * 13 + this.contrastEnhancement.hashCode();
        key = key * 13 + this.shadedRelief.hashCode();
        key = key * 13 + this.opacity.hashCode();
        key = key * 13 + this.overlap.hashCode();
        key = key * 13 + this.geometryName.hashCode();
        return key;
    }

    public ChannelSelection getChannelSelection() {
        return this.channelSelction;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public ContrastEnhancement getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    public Symbolizer getImageOutline() {
        return this.symbolizer;
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getOverlap() {
        return this.overlap;
    }

    public ShadedRelief getShadedRelief() {
        return this.shadedRelief;
    }

    public void setChannelSelection(ChannelSelection channel) {
        this.channelSelction = channel;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void setContrastEnhancement(ContrastEnhancement cEnhancement) {
        this.contrastEnhancement = cEnhancement;
    }

    public void setGeometryPropertyName(String geometryPropertyName) {
        this.geometryName = geometryPropertyName;
    }

    public void setImageOutline(Symbolizer symbolizer) {
        if (symbolizer instanceof LineSymbolizer || symbolizer instanceof PolygonSymbolizer) {
            this.symbolizer = symbolizer;
            return;
        }
        throw new IllegalArgumentException("Only a line or polygon symbolizer may be used to outline a raster");
    }

    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    public void setOverlap(Expression overlap) {
        this.overlap = overlap;
    }

    public void setShadedRelief(ShadedRelief relief) {
        this.shadedRelief = relief;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }
}

