/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.filter.Filter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;

public class StyleAttributeExtractor
extends FilterAttributeExtractor
implements StyleVisitor {
    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        for (int i = 0; i < ftStyles.length; ++i) {
            ftStyles[i].accept(this);
        }
    }

    public void visit(Rule rule) {
        Graphic[] legendGraphics;
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept(this);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            for (int i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept(this);
            }
        }
        if ((legendGraphics = rule.getLegendGraphic()) != null) {
            // empty if block
        }
    }

    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = rules[i];
            rule.accept(this);
        }
    }

    public void visit(Fill fill) {
        if (fill.getBackgroundColor() != null) {
            fill.getBackgroundColor().accept(this);
        }
        if (fill.getColor() != null) {
            fill.getColor().accept(this);
        }
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept(this);
        }
        if (fill.getOpacity() != null) {
            fill.getOpacity().accept(this);
        }
    }

    public void visit(Stroke stroke) {
        if (stroke.getColor() != null) {
            stroke.getColor().accept(this);
        }
        if (stroke.getDashOffset() != null) {
            stroke.getDashOffset().accept(this);
        }
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept(this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept(this);
        }
        if (stroke.getLineCap() != null) {
            stroke.getLineCap().accept(this);
        }
        if (stroke.getLineJoin() != null) {
            stroke.getLineJoin().accept(this);
        }
        if (stroke.getOpacity() != null) {
            stroke.getOpacity().accept(this);
        }
        if (stroke.getWidth() != null) {
            stroke.getWidth().accept(this);
        }
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(RasterSymbolizer rs) {
        if (rs.getGeometryPropertyName() != null) {
            this.attributeNames.add(rs.getGeometryPropertyName());
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept(this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept(this);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGeometryPropertyName() != null) {
            this.attributeNames.add(ps.getGeometryPropertyName());
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept(this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getGeometryPropertyName() != null) {
            this.attributeNames.add(line.getGeometryPropertyName());
        }
        if (line.getStroke() != null) {
            line.getStroke().accept(this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getGeometryPropertyName() != null) {
            this.attributeNames.add(poly.getGeometryPropertyName());
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept(this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept(this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text.getGeometryPropertyName() != null) {
            this.attributeNames.add(text.getGeometryPropertyName());
        }
        if (text.getFill() != null) {
            text.getFill().accept(this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getFonts() != null) {
            Font[] fonts = text.getFonts();
            for (int i = 0; i < fonts.length; ++i) {
                Font font = fonts[i];
                if (font.getFontFamily() != null) {
                    font.getFontFamily().accept(this);
                }
                if (font.getFontSize() != null) {
                    font.getFontSize().accept(this);
                }
                if (font.getFontStyle() != null) {
                    font.getFontStyle().accept(this);
                }
                if (font.getFontWeight() == null) continue;
                font.getFontWeight().accept(this);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getLabel() != null) {
            text.getLabel().accept(this);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept(this);
        }
    }

    public void visit(Graphic gr) {
        if (gr.getSymbols() != null) {
            Symbol[] symbols = gr.getSymbols();
            for (int i = 0; i < symbols.length; ++i) {
                Symbol symbol = symbols[i];
                symbol.accept(this);
            }
        }
        if (gr.getOpacity() != null) {
            gr.getOpacity().accept(this);
        }
        if (gr.getRotation() != null) {
            gr.getRotation().accept(this);
        }
        if (gr.getSize() != null) {
            gr.getSize().accept(this);
        }
    }

    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept(this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept(this);
        }
        if (mark.getRotation() != null) {
            mark.getRotation().accept(this);
        }
        if (mark.getSize() != null) {
            mark.getSize().accept(this);
        }
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept(this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept(this);
        }
        if (pp.getRotation() != null) {
            pp.getRotation().accept(this);
        }
    }

    public void visit(AnchorPoint ap) {
        if (ap.getAnchorPointX() != null) {
            ap.getAnchorPointX().accept(this);
        }
        if (ap.getAnchorPointY() != null) {
            ap.getAnchorPointY().accept(this);
        }
    }

    public void visit(Displacement dis) {
        if (dis.getDisplacementX() != null) {
            dis.getDisplacementX().accept(this);
        }
        if (dis.getDisplacementY() != null) {
            dis.getDisplacementY().accept(this);
        }
    }

    public void visit(LinePlacement lp) {
        if (lp.getPerpendicularOffset() != null) {
            lp.getPerpendicularOffset().accept(this);
        }
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept(this);
        }
        if (halo.getRadius() != null) {
            halo.getRadius().accept(this);
        }
    }
}

