/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.opengis.util.Cloneable;

public class StyleImpl
implements Style,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.styling");
    private List featureTypeStyleList = new ArrayList();
    private String abstractText = "";
    private String name = "Default Styler";
    private String title = "Default Styler";
    private boolean defaultB = false;

    protected StyleImpl() {
    }

    public String getAbstract() {
        return this.abstractText;
    }

    public FeatureTypeStyle[] getFeatureTypeStyles() {
        FeatureTypeStyle[] ret = new FeatureTypeStyleImpl[]{new FeatureTypeStyleImpl()};
        if (this.featureTypeStyleList != null && this.featureTypeStyleList.size() != 0) {
            LOGGER.fine("number of fts set " + this.featureTypeStyleList.size());
            ret = this.featureTypeStyleList.toArray(new FeatureTypeStyle[0]);
        }
        return ret;
    }

    public void setFeatureTypeStyles(FeatureTypeStyle[] featureTypeStyles) {
        this.featureTypeStyleList.clear();
        for (int i = 0; i < featureTypeStyles.length; ++i) {
            this.addFeatureTypeStyle(featureTypeStyles[i]);
        }
        LOGGER.fine("StyleImpl added " + this.featureTypeStyleList.size() + " feature types");
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDefault() {
        return this.defaultB;
    }

    public void setAbstract(String abstractStr) {
        this.abstractText = abstractStr;
    }

    public void setDefault(boolean isDefault) {
        this.defaultB = isDefault;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addFeatureTypeStyle(FeatureTypeStyle type) {
        this.featureTypeStyleList.add(type);
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Style clone;
        try {
            clone = (Style)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        FeatureTypeStyle[] ftsArray = new FeatureTypeStyle[this.featureTypeStyleList.size()];
        for (int i = 0; i < ftsArray.length; ++i) {
            FeatureTypeStyle fts = (FeatureTypeStyle)this.featureTypeStyleList.get(i);
            ftsArray[i] = (FeatureTypeStyle)((Cloneable)fts).clone();
        }
        clone.setFeatureTypeStyles(ftsArray);
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.featureTypeStyleList != null) {
            result = 1000003 * result + ((Object)this.featureTypeStyleList).hashCode();
        }
        if (this.abstractText != null) {
            result = 1000003 * result + this.abstractText.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        result = 1000003 * result + (this.defaultB ? 1 : 0);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyleImpl) {
            StyleImpl other = (StyleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.title, other.title) && Utilities.equals(this.abstractText, other.abstractText) && Utilities.equals(this.featureTypeStyleList, other.featureTypeStyleList);
        }
        return false;
    }
}

