/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.LinkedHashSet;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.util.Cloneable;

public class CheckedHashSet
extends LinkedHashSet
implements Cloneable {
    private static final long serialVersionUID = -9014541457174735097L;
    private final Class type;

    public CheckedHashSet(Class type) {
        this.type = type;
        if (type == null) {
            throw new NullPointerException(Resources.format(115, "type"));
        }
    }

    protected void ensureValidType(Object element) throws IllegalArgumentException {
        if (element != null && !this.type.isInstance(element)) {
            throw new IllegalArgumentException(Resources.format(85, Utilities.getShortClassName(element), Utilities.getShortName(this.type)));
        }
    }

    public boolean add(Object element) {
        this.ensureValidType(element);
        return super.add(element);
    }
}

