/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.geotools.util.DerivedSet;

public abstract class DerivedMap
extends AbstractMap
implements Serializable {
    private static final long serialVersionUID = -6994867383669885934L;
    protected final Map base;
    private transient Set keySet;
    private transient Set entrySet;

    public DerivedMap(Map base) {
        this.base = base;
    }

    protected abstract Object baseToDerived(Object var1);

    protected abstract Object derivedToBase(Object var1);

    public int size() {
        return super.size();
    }

    public boolean isEmpty() {
        return this.base.isEmpty() || super.isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.base.containsKey(this.derivedToBase(key));
    }

    public Object get(Object key) {
        return this.base.get(this.derivedToBase(key));
    }

    public Object put(Object key, Object value) throws UnsupportedOperationException {
        return this.base.put(this.derivedToBase(key), value);
    }

    public Object remove(Object key) throws UnsupportedOperationException {
        return this.base.remove(this.derivedToBase(key));
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this.base.keySet());
        }
        return this.keySet;
    }

    public Collection values() {
        return this.base.values();
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this.base.entrySet());
        }
        return this.entrySet;
    }

    private static final class Entry
    implements Map.Entry {
        public final Map.Entry entry;
        private final Object derived;

        public Entry(Map.Entry entry, Object derived) {
            this.entry = entry;
            this.derived = derived;
        }

        public Object getKey() {
            return this.derived;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object value) {
            return this.entry.setValue(value);
        }
    }

    private final class EntrySet
    extends DerivedSet {
        private static final long serialVersionUID = -2931806200277420177L;

        public EntrySet(Set base) {
            super(base);
        }

        protected Object baseToDerived(Object element) {
            Map.Entry entry = (Map.Entry)element;
            Object derived = DerivedMap.this.baseToDerived(entry.getKey());
            return derived != null ? new Entry(entry, derived) : null;
        }

        protected Object derivedToBase(Object element) {
            return ((Entry)element).entry;
        }
    }

    private final class KeySet
    extends DerivedSet {
        private static final long serialVersionUID = -2931806200277420177L;

        public KeySet(Set base) {
            super(base);
        }

        protected Object baseToDerived(Object element) {
            return DerivedMap.this.baseToDerived(element);
        }

        protected Object derivedToBase(Object element) {
            return DerivedMap.this.derivedToBase(element);
        }
    }
}

