/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import org.geotools.util.KeySortedLinkedListIterator;
import org.geotools.util.KeySortedListNode;

public class KeySortedLinkedList {
    KeySortedListNode header = new KeySortedListNode(null, null);

    public boolean isEmpty() {
        return this.header.next == null;
    }

    public KeySortedLinkedListIterator first() {
        return new KeySortedLinkedListIterator(this.header.next);
    }

    public void insert(Comparable x, Object o) {
        KeySortedLinkedListIterator location = this.findPrevious(x);
        while (!location.isPastEnd()) {
            if (location.current == this.header || location.current.next == null || location.current.next.element == null || location.current.next.key.compareTo(x) != 0) {
                location.current.next = new KeySortedListNode(x, o, location.current.next);
                break;
            }
            location.advance();
        }
    }

    public boolean contains(Comparable x) {
        KeySortedListNode itr = this.header.next;
        boolean found = false;
        while (itr != null && !found) {
            found = itr.key.compareTo(x) == 0;
            itr = itr.next;
        }
        return found;
    }

    public String toString() {
        KeySortedListNode itr = this.header.next;
        String s = new String();
        s = s + "(";
        while (itr.next != null) {
            s = s + itr.element.toString() + ",";
            itr = itr.next;
        }
        s = s + itr.element.toString() + ")";
        return s;
    }

    public KeySortedLinkedListIterator find(Comparable x) {
        KeySortedListNode itr = this.header.next;
        while (itr != null && itr.key.compareTo(x) < 0) {
            itr = itr.next;
        }
        return new KeySortedLinkedListIterator(itr);
    }

    public KeySortedLinkedListIterator findPrevious(Comparable x) {
        KeySortedListNode itr = this.header;
        while (itr.next != null && itr.next.element != null && itr.next.key.compareTo(x) < 0) {
            itr = itr.next;
        }
        return new KeySortedLinkedListIterator(itr);
    }

    public void remove(Comparable x) {
        if (this.isEmpty()) {
            return;
        }
        KeySortedLinkedListIterator p = this.findPrevious(x);
        if (p.current.next != null) {
            p.current.next = p.current.next.next;
        }
    }

    public KeySortedLinkedListIterator getAt(int index) {
        if (index < 0) {
            return null;
        }
        KeySortedLinkedListIterator it = this.first();
        int i = 0;
        while (!it.isPastEnd() && i++ != index) {
            it.advance();
        }
        return it;
    }
}

