/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.geotools.resources.Utilities;
import org.geotools.util.AbstractInternationalString;

public class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 6339944890723487336L;
    private final String resources;
    private final String key;

    public ResourceInternationalString(String resources, String key) {
        this.resources = resources;
        this.key = key;
        ResourceInternationalString.ensureNonNull("resources", resources);
        ResourceInternationalString.ensureNonNull("key", key);
    }

    public String toString(Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return ResourceBundle.getBundle(this.resources, locale).getString(this.key);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            ResourceInternationalString that = (ResourceInternationalString)object;
            return Utilities.equals(this.key, that.key) && Utilities.equals(this.resources, that.resources);
        }
        return false;
    }

    public int hashCode() {
        return 0xA3204E68 ^ this.key.hashCode() ^ this.resources.hashCode();
    }
}

