/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.util.Iterator;
import java.util.List;
import org.geotools.xml.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMXPath
extends XPath {
    public DOMXPath(String path) {
        super(path);
    }

    protected Object solve(List path) {
        Node node = (Node)path.get(path.size() - 1);
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            String value = node.getNodeValue();
            value = value.replaceAll("\n+", " ");
            value = value.trim();
            return value;
        }
        return null;
    }

    protected Iterator getChildren(Object o) {
        Node n = (Node)o;
        return new ElementIterator(n);
    }

    protected String getNodeName(Object o) {
        Node node = (Node)o;
        return node.getNodeName();
    }

    protected boolean isLegalNode(Object o, int operation, boolean isList) {
        return o instanceof Node;
    }

    private class ElementIterator
    implements Iterator {
        Node next;
        NodeList children;
        int index = 0;

        ElementIterator(Node n) {
            if (n instanceof Document) {
                this.next = ((Document)n).getDocumentElement();
            } else {
                this.children = n.getChildNodes();
                this.next = this.findNext();
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Node tmp = this.next;
            this.next = this.findNext();
            return tmp;
        }

        private Node findNext() {
            if (this.children == null) {
                return null;
            }
            for (int i = this.index + 1; i < this.children.getLength(); ++i) {
                if (this.children.item(i).getNodeType() != 1) continue;
                this.index = i;
                return this.children.item(i);
            }
            return null;
        }

        public void remove() {
        }
    }
}

