/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.swing.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.slidertext.listeners.SliderEvent;
import org.gvsig.gui.beans.slidertext.listeners.SliderListener;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.roimask.swing.ROIMaskData;
import org.gvsig.raster.roimask.swing.ROIMaskPanel;
import org.gvsig.raster.roimask.swing.impl.ROIMaskDataImpl;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.slider.SliderText;

public class ROIMaskPanelImpl
extends JPanel
implements ROIMaskPanel,
TableModelListener,
ChangeListener,
DataInputContainerListener,
ActionListener,
SliderListener {
    private static final long serialVersionUID = 1L;
    private ROIMaskDataImpl data = null;
    private TableContainer tableContainer = null;
    private JCheckBox negative = null;
    private JLabel warning = null;
    private DataInputContainer valueNoData = null;
    private SliderText slider = null;
    private ActionListener listener = null;

    public ROIMaskPanelImpl() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getTableContainer(), gridBagConstraints1);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.gridy = 0;
        this.add((Component)this.getWarning(), gridBagConstraints1);
        gridBagConstraints1.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints1.gridy = 2;
        this.add((Component)this.getInverse(), gridBagConstraints1);
        gridBagConstraints1.gridy = 3;
        this.add((Component)this.getValueNoData(), gridBagConstraints1);
        gridBagConstraints1.gridy = 4;
        this.add((Component)this.getSlider().getComponent(), gridBagConstraints1);
    }

    public JComponent getComponent() {
        return this;
    }

    public ROIMaskData getDataModel() {
        if (this.data == null) {
            this.data = new ROIMaskDataImpl(this);
        }
        return this.data;
    }

    public TableContainer getTableContainer() {
        if (this.tableContainer == null) {
            String[] columnNames = new String[]{" ", "Nombre", ""};
            int[] columnWidths = new int[]{22, 334, 0};
            this.tableContainer = new TableContainer(columnNames, columnWidths);
            this.tableContainer.setPreferredSize(new Dimension(0, 130));
            this.tableContainer.setModel("CheckBoxModel");
            this.tableContainer.initialize();
            this.tableContainer.setControlVisible(false);
            this.tableContainer.setMoveRowsButtonsVisible(false);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMinWidth(22);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMaxWidth(22);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMinWidth(0);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMaxWidth(0);
            this.tableContainer.getModel().addTableModelListener(this);
        }
        return this.tableContainer;
    }

    public JCheckBox getInverse() {
        if (this.negative == null) {
            this.negative = new JCheckBox();
            this.negative.setText(Messages.getText((String)"inversa"));
            this.negative.addChangeListener(this);
            this.negative.addActionListener(this);
        }
        return this.negative;
    }

    public JLabel getWarning() {
        if (this.warning == null) {
            this.warning = new JLabel(Messages.getText((String)"rois_needed"));
            this.warning.setVisible(false);
        }
        return this.warning;
    }

    public DataInputContainer getValueNoData() {
        if (this.valueNoData == null) {
            this.valueNoData = new DataInputContainer();
            this.valueNoData.setLabelText(Messages.getText((String)"value"));
            this.valueNoData.setValue("-99999");
            this.valueNoData.getDataInputField().addValueChangedListener((DataInputContainerListener)this);
            this.valueNoData.addValueChangedListener((DataInputContainerListener)this);
        }
        return this.valueNoData;
    }

    public SliderText getSlider() {
        if (this.slider == null) {
            this.slider = RasterSwingLocator.getSwingManager().createSliderText(0, 100, 0, false);
            this.slider.setDecimal(true);
            this.slider.setBorder("");
            this.slider.addValueChangedListener((SliderListener)this);
        }
        return this.slider;
    }

    public void activeSlider(boolean b) {
        if (b) {
            this.getSlider().setControlEnabled(true);
            this.getValueNoData().setControlEnabled(false);
        } else {
            this.getSlider().setControlEnabled(false);
            this.getValueNoData().setControlEnabled(true);
        }
    }

    public void addRow(Object[] row) throws NotInitializeException {
        this.getTableContainer().addRow(row);
    }

    public void clearTable() throws NotInitializeException {
        this.getTableContainer().removeAllRows();
    }

    public void setValueNoData(double value) {
        this.getValueNoData().setValue(value + "");
    }

    public void showWarning(boolean show) {
        this.getWarning().setVisible(show);
    }

    public void addListener(ActionListener listener) {
        this.listener = listener;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this.getTableContainer(), 0, "UPDATE"));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this.getValueNoData(), 0, "UPDATE"));
        }
    }

    public void actionValueChanged(EventObject e) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this.getSlider(), 0, "UPDATE"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(e);
        }
    }

    public void actionValueChanged(SliderEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this.getSlider(), 0, "UPDATE"));
        }
    }

    public void actionValueDragged(SliderEvent e) {
    }
}

