/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.swing.impl.viewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.gvsig.ods.lib.api.ODSDocument;
import org.gvsig.ods.swing.api.ODSViewer;
import org.gvsig.ods.swing.impl.viewer.DefaultODSViewer;
import org.gvsig.pdf.swing.api.EmbeddedViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.Invocable;

public class EmbeddedViewerODS
implements EmbeddedViewer<ODSDocument> {
    private JComponent odsComponent;
    private ODSViewer odsViewer;
    private ODSDocument currentDocument;
    private Invocable messageHandler;

    public void put(ODSDocument value) {
        block9: {
            if (this.odsViewer == null) {
                return;
            }
            try {
                this.currentDocument = value;
                if (value == null) {
                    this.clear();
                    return;
                }
                try {
                    this.odsViewer.clean();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) {
                    this.odsViewer.put(null);
                } else if (value instanceof ODSDocument) {
                    this.odsViewer.put(value);
                }
            }
            catch (Exception ex) {
                if (this.messageHandler == null) break block9;
                this.messageHandler.call(new Object[]{"Can't load PDF"});
            }
        }
    }

    public void setReadOnly(boolean readonly) {
        if (this.odsComponent != null) {
            this.odsComponent.setEnabled(!readonly);
        }
    }

    public void setMessageHandler(Invocable messageHandler) {
        this.messageHandler = messageHandler;
    }

    public boolean supportShowInWindow() {
        return true;
    }

    public Action createShowInWindowAction() {
        ShowInWindowAction action = new ShowInWindowAction();
        return action;
    }

    public void clear() {
        this.currentDocument = null;
        this.odsViewer.clean();
    }

    public void showInWindow() {
        DefaultODSViewer viewer;
        WindowManager wmanager;
        block2: {
            wmanager = ToolsSwingLocator.getWindowManager();
            viewer = new DefaultODSViewer();
            try {
                viewer.put(this.currentDocument);
            }
            catch (IOException ex) {
                if (this.messageHandler == null) break block2;
                this.messageHandler.call(new Object[]{"Not able to open pdf on new window."});
            }
        }
        viewer.setMode(1);
        JComponent panel = viewer.asJComponent();
        panel.setPreferredSize(new Dimension(650, 600));
        wmanager.showWindow(panel, "PDF Visor", WindowManager.MODE.WINDOW);
    }

    public JComponent asJComponent() {
        this.odsViewer = new DefaultODSViewer();
        this.odsComponent = this.odsViewer.asJComponent();
        return this.odsComponent;
    }

    private class ShowInWindowAction
    extends AbstractAction {
        public ShowInWindowAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
            this.putValue("Name", "");
            this.putValue("SmallIcon", iconTheme.get("form-open-ods"));
            this.putValue("ShortDescription", i18n.getTranslation("_Show_in_new_window"));
            this.putValue("ActionCommandKey", "ShowInWindow");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EmbeddedViewerODS.this.showInWindow();
        }
    }
}

