/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl.report;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTemplateReportCustomActionFactory
implements ReportActionFactory.ReportCustomActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyTemplateReportCustomActionFactory.class);

    public String getName() {
        return "CopyTemplateReport";
    }

    public Action createCustomAction(ActionEvent event, DALActionFactory.DALActionContext context) {
        final JFeaturesForm featuresForm = (JFeaturesForm)context.get("featuresform");
        if (featuresForm == null) {
            return null;
        }
        if (event == null || (event.getModifiers() & 1) != 1) {
            return null;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        AbstractAction action = new AbstractAction(i18n.getTranslation("_Copy_template")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyTemplateReportCustomActionFactory.this.doCopyTemplate(featuresForm);
            }
        };
        return action;
    }

    private void doCopyTemplate(JFeaturesForm featuresForm) {
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            JDynForm form = featuresForm.getFormset().getForm();
            DynFormDefinition formdef = form.getDefinition();
            FeatureStore store = featuresForm.getFeatureStore();
            String tableName = store.getName();
            List groups = formdef.getGroups();
            String template_top = StringUtils.join((Iterable)IOUtils.readLines((InputStream)this.getClass().getResourceAsStream("/org/gvsig/pdf/swing/impl/report/report_template_top.txt"), (Charset)StandardCharsets.UTF_8), (String)"\n");
            String template_bottom = StringUtils.join((Iterable)IOUtils.readLines((InputStream)this.getClass().getResourceAsStream("/org/gvsig/pdf/swing/impl/report/report_template_bottom.txt"), (Charset)StandardCharsets.UTF_8), (String)"\n");
            template_top = StringUtils.replace((String)template_top, (String)"$$TABLENAME$$", (String)tableName);
            template_bottom = StringUtils.replace((String)template_bottom, (String)"$$TABLENAME$$", (String)tableName);
            StringBuilder builder = new StringBuilder();
            builder.append(template_top);
            builder.append("<table style=\"border: none;\" cellspacing=\"2\" cellpadding=\"0\">\n");
            for (String group : groups) {
                String tablabel = group;
                tablabel = StringUtils.isBlank((CharSequence)tablabel) ? i18n.getTranslation("General") : i18n.getTranslation(tablabel);
                builder.append("<tr>\n");
                builder.append("<td colspan=\"2\">\n<br/><i>").append(StringEscapeUtils.escapeHtml3((String)tablabel)).append("</i>").append("</td>\n");
                builder.append("</tr>\n");
                List fields = formdef.getDefinitions(group);
                for (DynFormFieldDefinition fieldDefinition : fields) {
                    JDynFormField jfield;
                    if (fieldDefinition.isHidden() || (jfield = form.getField(fieldDefinition.getName())) == null || fieldDefinition.isHidden() || fieldDefinition.getDataType().isContainer()) continue;
                    String value = "<%=$REPORT.formatFieldValue(ROW,'" + jfield.getName() + "')%>";
                    builder.append("  <tr style=\"page-break-inside: avoid;\">\n");
                    if (jfield.useEmptyLabel()) {
                        builder.append("    <td colspan=\"2\">").append(value).append("</td>\n");
                    } else {
                        builder.append("    <td valign=\"top\" style=\"white-space:nowrap;\">");
                        if (fieldDefinition.isMandatory()) {
                            builder.append("<b>").append(fieldDefinition.getLabel()).append("</b>");
                        } else {
                            builder.append(fieldDefinition.getLabel());
                        }
                        builder.append(": ").append("</td>\n");
                        builder.append("    <td>").append(value).append("</td>\n");
                    }
                    builder.append("  </tr>\n");
                }
            }
            builder.append("</table>\n");
            builder.append(template_bottom);
            ToolsSwingLocator.getToolsSwingManager().putInClipboard(builder.toString());
            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog("Copied the template to the clipboard.", "Reports", 1);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create template of report", (Throwable)ex);
        }
    }

    public static void selfRegister() {
        DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
        dalSwingManager.registerReportsCustomAction((ReportActionFactory.ReportCustomActionFactory)new CopyTemplateReportCustomActionFactory(), false);
    }
}

