/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl.viewer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.io.IOUtils;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.util.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPDFViewer
implements PDFViewer {
    private PDFDocument pdf = null;
    private SwingController controller = new SwingController();
    private JPanel component = null;
    private int mode;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPDFViewer.class);

    public DefaultPDFViewer() {
        this.controller.setIsEmbeddedComponent(true);
        this.mode = 0;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected void buildLightViewer() {
        Properties props = new Properties();
        props.setProperty("application.viewerpreferences.form.highlight", "false");
        props.setProperty("application.toolbar.show.utility.save", "false");
        props.setProperty("application.toolbar.show.utility.save", "true");
        props.setProperty("application.toolbar.show.utility.open", "false");
        props.setProperty("application.toolbar.show.utility.print", "true");
        props.setProperty("application.toolbar.show.utility.upane", "false");
        props.setProperty("application.toolbar.show.annotation.highlight", "false");
        props.setProperty("application.toolbar.show.annotation.selection", "false");
        props.setProperty("application.toolbar.show.annotation.text", "false");
        props.setProperty("application.toolbar.show.annotation", "false");
        props.setProperty("application.toolbar.show.tool", "false");
        props.setProperty("application.showLocalStorageDialogs", "false");
        PropertiesManager propertiesManager = new PropertiesManager(System.getProperties(), props, ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
        propertiesManager.setInt("document.viewtype", 2);
        propertiesManager.setInt("document.pagefitMode", 4);
        SwingViewBuilder viewBuilder = new SwingViewBuilder(this.controller, propertiesManager);
        this.component = viewBuilder.buildViewerPanel();
    }

    protected void buildCompleteViewer() {
        SwingViewBuilder frameBuilder = new SwingViewBuilder(this.controller);
        this.component = frameBuilder.buildViewerPanel();
    }

    public PDFDocument getPDF() {
        return this.pdf;
    }

    public void put(PDFDocument pdf) throws IOException {
        this.pdf = pdf;
        if (pdf != null) {
            InputStream in = null;
            try {
                in = pdf.getInputStream();
                this.controller.openDocument(in, "PDF", null);
            }
            catch (IOException ex) {
                LOGGER.warn("Can't open document pdf", (Throwable)ex);
                throw new IOException(ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public JComponent asJComponent() {
        if (this.component == null) {
            if (this.mode == 0) {
                this.buildLightViewer();
            } else if (this.mode == 1) {
                this.buildCompleteViewer();
            }
        }
        return this.component;
    }

    public void clean() {
        this.controller.closeDocument();
    }

    public void dispose() {
        this.controller.dispose();
        this.controller = null;
        DisposeUtils.disposeQuietly((Disposable)this.pdf);
        this.pdf = null;
    }
}

