/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.naming.directory.SearchResult;
import org.castor.core.util.Messages;
import org.castor.xml.BackwardCompatibilityContext;
import org.castor.xml.InternalContext;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportEventListener;
import org.exolab.castor.dsml.ImportExportException;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Importer {
    private InternalContext _xmlContext = new BackwardCompatibilityContext();
    private ImportDescriptor _importDesc;
    private ImportEventListener _listener;

    public void setImportDescriptor(ImportDescriptor importDesc) {
        this._importDesc = importDesc;
    }

    public ImportDescriptor getImportDescriptor() {
        if (this._importDesc == null) {
            this._importDesc = new ImportDescriptor();
        }
        return this._importDesc;
    }

    public void setImportEventListener(ImportEventListener listener) throws TooManyListenersException {
        if (this._listener != null) {
            throw new TooManyListenersException(Messages.message((String)"dsml.onlyOneListener"));
        }
        this._listener = listener;
    }

    public ImportEventListener getImportEventListener() {
        return this._listener;
    }

    public void importDocument(InputStream stream) throws ImportExportException {
        this.importDocument(this._xmlContext.getParser(), new InputSource(stream));
    }

    public void importDocument(Reader reader) throws ImportExportException {
        this.importDocument(this._xmlContext.getParser(), new InputSource(reader));
    }

    public void importDocument(Parser parser, InputSource input) throws ImportExportException {
        Consumer consumer = this.createConsumer();
        parser.setDocumentHandler(consumer);
        try {
            parser.parse(input);
        }
        catch (SAXException except) {
            throw new ImportExportException(except);
        }
        catch (IOException except) {
            throw new ImportExportException(except);
        }
        if (consumer.getResults() != null) {
            this.importEntries(consumer.getResults());
        }
    }

    public void readImportDescriptor(InputStream input) throws IOException, SAXException {
        this.readImportDescriptor(this._xmlContext.getParser(), new InputSource(input));
    }

    public void readImportDescriptor(Reader input) throws IOException, SAXException {
        this.readImportDescriptor(this._xmlContext.getParser(), new InputSource(input));
    }

    protected void readImportDescriptor(Parser parser, InputSource input) throws IOException, SAXException {
        ImportDescriptor desc = new ImportDescriptor();
        parser.setDocumentHandler(desc);
        parser.parse(input);
        this.setImportDescriptor(desc);
    }

    protected void notify(String name, int flag) {
        if (this._listener != null) {
            this._listener.processedEntry(name, flag);
        }
    }

    protected abstract Consumer createConsumer();

    public abstract void importEntries(Enumeration<SearchResult> var1) throws ImportExportException;
}

