/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.gvsig.compat.net.Downloader;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.DownloaderCredentials;

public interface DownloaderManager
extends Downloader {
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_DELETE = "DELETE";

    public static boolean urlStartsWith(String url_s, String prefix) {
        try {
            URL baseUrl = new URL(prefix);
            URL url = new URL(url_s);
            if (!StringUtils.equals((CharSequence)baseUrl.getHost(), (CharSequence)url.getHost())) {
                return false;
            }
            return StringUtils.startsWith((CharSequence)url.getPath(), (CharSequence)baseUrl.getPath());
        }
        catch (MalformedURLException ex) {
            return StringUtils.startsWith((CharSequence)url_s, (CharSequence)prefix);
        }
    }

    public static boolean areSameURLs(String url1_s, String url2_s) {
        try {
            URL url1 = new URL(url1_s);
            URL url2 = new URL(url2_s);
            if (!StringUtils.equals((CharSequence)url1.getHost(), (CharSequence)url2.getHost())) {
                return false;
            }
            return StringUtils.equals((CharSequence)url1.getPath(), (CharSequence)url2.getPath());
        }
        catch (MalformedURLException ex) {
            return StringUtils.equals((CharSequence)url1_s, (CharSequence)url2_s);
        }
    }

    public void addOrReplaceCredentials(DownloaderCredentials var1);

    public DownloaderAuthenticationConfig getAuthenticationConfigurationService(String var1);

    public Collection<DownloaderAuthenticationConfig> getAuthenticationConfigurationServices();

    public DownloaderAuthenticationFactory getDownloaderAuthenticationFactory(String var1);

    public Collection<DownloaderAuthenticationFactory> getAuthenticationTypes();

    public Collection<DownloaderCredentials> getCredentials();

    public DownloaderCredentials getCredentials(URL var1);

    public DownloaderCredentials getCredentials(String var1);

    public void removeCredentials(DownloaderCredentials var1);

    public void removeCredentials(String var1);

    public void removeAuthenticationConfigurationService(DownloaderAuthenticationConfig var1);

    public void registerAuthenticationConfigurationService(DownloaderAuthenticationConfig var1);

    public void registerAuthenticationType(DownloaderAuthenticationFactory var1);

    public void registerAuthenticationConfigurationService(String var1);

    public String getAuthenticationConfigurationServiceAsString(String var1);

    public void propagateCredentials(String var1, Collection<String> var2);

    public String getAuthorizationToken(URL var1);

    public File downloadFile(URL var1, String var2, ContentType var3, String var4, String var5, ICancellable var6, int var7, boolean var8, boolean var9) throws IOException, ConnectException, UnknownHostException;

    public DownloaderCredentials getAuthenticatedCredentials(URL var1);

    public String getAuthenticatedUser(URL var1);
}

