/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.impl.DefaultScriptingManager;
import org.gvsig.scripting.impl.Unit;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnit
implements ScriptingUnit,
Unit {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractUnit.class);
    protected DefaultScriptingManager manager;
    protected String id;
    protected String name = null;
    protected String description;
    protected String createdBy;
    protected String version;
    protected ScriptingFolder parent;
    protected String typename;
    protected Set<PropertyChangeListener> changeListener;
    protected boolean saved;
    private Map<String, String> properties;

    public AbstractUnit(ScriptingFolder parent, String typename, ScriptingManager manager, String id) {
        this.parent = parent;
        this.manager = (DefaultScriptingManager)manager;
        this.typename = typename;
        this.id = id;
        this.changeListener = null;
        this.properties = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeListener == null) {
            this.changeListener = new HashSet<PropertyChangeListener>();
        }
        this.changeListener.add(listener);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (this.changeListener == null) {
            return;
        }
        for (PropertyChangeListener listener : this.changeListener) {
            try {
                if (listener == null) continue;
                listener.propertyChange(event);
            }
            catch (Exception ex) {
                LOGGER.warn("Problems firing PropertyChangeListener to listener " + listener + ".", (Throwable)ex);
            }
        }
    }

    public void firePropertyChangeListener(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, newValue);
        this.firePropertyChange(event);
    }

    public String getTypeName() {
        return this.typename;
    }

    @Override
    public abstract void load(ScriptingFolder var1, String var2);

    public void reload() {
        this.load(this.getParent(), this.getId());
    }

    public String toString() {
        if (this.getName() == null) {
            return "(" + this.getClass().getSimpleName() + ")";
        }
        return this.getName();
    }

    protected void setParent(ScriptingFolder parent) {
        this.parent = parent;
    }

    public ScriptingManager getManager() {
        return this.manager;
    }

    public File getFileResource(String extension) {
        return new File(this.getParent().getFile(), this.id + extension).getAbsoluteFile();
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            return this.id;
        }
        return this.name;
    }

    public void setDescription(String description) {
        this.firePropertyChangeListener("description", description, this.description);
        this.description = description;
    }

    public void setCreatedBy(String createdBy) {
        this.firePropertyChangeListener("createdBy", createdBy, this.createdBy);
        this.createdBy = createdBy;
    }

    public void setVersion(String version) {
        this.firePropertyChangeListener("version", version, this.version);
        this.version = version;
    }

    @Override
    public void setId(String id) {
        this.firePropertyChangeListener("id", id, this.id);
        this.id = FilenameUtils.getBaseName((String)id);
    }

    public void setName(String name) {
        this.firePropertyChangeListener("name", name, this.name);
        this.name = name;
    }

    public ScriptingFolder getParent() {
        return this.parent;
    }

    public String getUserPath() {
        ArrayList<String> parts = new ArrayList<String>();
        for (AbstractUnit unit = this; unit != null; unit = unit.getParent()) {
            parts.add(0, unit.getName());
        }
        return String.join((CharSequence)"/", parts);
    }

    protected void save(Ini prefs) {
        prefs.put("Unit", "type", (Object)StringUtils.defaultString((String)this.getTypeName()));
        prefs.put("Unit", "name", (Object)this.getName());
        prefs.put("Unit", "description", (Object)StringUtils.defaultString((String)this.getDescription()));
        prefs.put("Unit", "createdBy", (Object)StringUtils.defaultString((String)this.getCreatedBy()));
        prefs.put("Unit", "version", (Object)StringUtils.defaultString((String)this.getVersion()));
        if (this.properties != null) {
            for (Map.Entry<String, String> property : this.properties.entrySet()) {
                String name = property.getKey();
                String value = property.getValue();
                prefs.put("properties", name, (Object)value);
            }
        }
        try {
            prefs.store();
        }
        catch (IOException e) {
            File f = prefs.getFile();
            String fname = f == null ? "(null)" : f.getAbsolutePath();
            String msg = "Can't save inf file '" + fname + "'.";
            LOGGER.warn(msg);
            throw new RuntimeException(msg, e);
        }
    }

    protected void loadInf(Ini prefs) {
        String typename = this.getInfString(prefs, "Unit", "type", this.getTypeName());
        if (!this.getTypeName().equalsIgnoreCase(typename)) {
            File f = prefs.getFile();
            String fname = f == null ? "(null)" : f.getAbsolutePath();
            LOGGER.warn("inconsistent type in inf file '" + fname + "'. Curent type '" + this.getTypeName() + "', type from inf file '" + typename + "'.");
        }
        this.setName(this.getInfString(prefs, "Unit", "name", this.getName()));
        this.setDescription(this.getInfString(prefs, "Unit", "description", null));
        this.setCreatedBy(this.getInfString(prefs, "Unit", "createdBy", null));
        this.setVersion(this.getInfString(prefs, "Unit", "version", null));
        Profile.Section sec = (Profile.Section)prefs.get((Object)"properties");
        if (sec != null) {
            for (Map.Entry entry : sec.entrySet()) {
                this.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected Object getInfValue(Ini prefs, String section, String option, Object defaultValue) {
        String r = prefs.get((Object)section, (Object)option);
        if (r == null) {
            return defaultValue;
        }
        return r;
    }

    protected String getInfString(Ini prefs, String section, String option, Object defaultValue) {
        String s = (String)this.getInfValue(prefs, section, option, defaultValue);
        if (s != null && s.trim().length() < 1) {
            return null;
        }
        return s;
    }

    protected int getInfInt(Ini prefs, String section, String option, int defaultValue) {
        String s = (String)this.getInfValue(prefs, section, option, String.valueOf(defaultValue));
        if (s != null && s.trim().length() < 1) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    protected boolean getInfBoolean(Ini prefs, String section, String option, boolean defaultValue) {
        String s = prefs.get((Object)section, (Object)option);
        if (s == null) {
            return defaultValue;
        }
        return BooleanUtils.toBoolean((String)s);
    }

    protected void console_println(String s) {
        LOGGER.info(s);
    }

    public void create(ScriptingFolder folder, String id) {
        this.setParent(folder);
        this.setId(id);
        File file = new File(folder.getFile(), id + ".inf");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LOGGER.warn("Can't create inf file in '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public File getFile() {
        if (this.getId() == null) {
            return null;
        }
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent().getFile() == null) {
            return null;
        }
        return new File(this.getParent().getFile(), this.getId() + ".inf");
    }

    public URL getURL() {
        File f = this.getFile();
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Unit)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        File f = this.getFile();
        if (f != null) {
            return "#$FILE$#".hashCode() + f.getAbsolutePath().hashCode();
        }
        if (this.getId() != null) {
            return "#$ID$#".hashCode() + this.getId().hashCode();
        }
        return super.hashCode();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isASystemUnit() {
        String pathUnit;
        try {
            pathUnit = this.getParent().getFile().getCanonicalPath();
        }
        catch (IOException ex) {
            pathUnit = this.getParent().getFile().getAbsolutePath();
        }
        if (!pathUnit.endsWith(File.separator)) {
            pathUnit = pathUnit + File.separator;
        }
        List libs = this.getManager().getLibFolders();
        for (File lib : libs) {
            String pathLib;
            try {
                pathLib = lib.getCanonicalPath();
            }
            catch (IOException ex) {
                pathLib = lib.getAbsolutePath();
            }
            if (!pathLib.endsWith(File.separator)) {
                pathLib = pathLib + File.separator;
            }
            if (!pathUnit.startsWith(pathLib)) continue;
            return true;
        }
        return false;
    }
}

