/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.scripting.DataFolderFound;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.impl.FileUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.packageutils.Version;
import org.gvsig.tools.util.FolderSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFolderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataFolderManager.class);
    private static final String DATAFOLDER_FILENAME = "data";
    private final ScriptingManager manager;

    public DataFolderManager(ScriptingManager manager) {
        this.manager = manager;
    }

    private File getHomeFolder() {
        return this.manager.getHomeFolder();
    }

    private void createFolder(File f) {
        if (!f.exists()) {
            try {
                FileUtils.forceMkdir(f);
                LOGGER.info("Created scripting folder '" + f.getAbsolutePath() + "'");
            }
            catch (Throwable e) {
                LOGGER.warn("Can't Create scripting folder '" + f.getAbsolutePath() + "'");
            }
        }
    }

    public File getDataFolder(String id) {
        File f = FileUtils.getFile(this.getHomeFolder(), DATAFOLDER_FILENAME, id);
        this.createFolder(f);
        return f;
    }

    public void registerDataFolder(ScriptingFolder folderScript, String id) {
        DataFolderRegister register = new DataFolderRegister();
        DataFolderRegisterEntry entry = register.get(id);
        if (entry != null) {
            return;
        }
        register.put(id, folderScript.getUserPath(), false);
        register.save();
    }

    public List<DataFolderFound> searchOldVersions(Version currentVersion, FolderSet folder) {
        ArrayList<DataFolderFound> founds = new ArrayList<DataFolderFound>();
        DataFolderRegister register = new DataFolderRegister();
        for (DataFolderRegisterEntry entry : register) {
            if (entry.processed) continue;
            this.searchOldVersions(founds, currentVersion, folder, entry.folderId, entry.folderPath);
        }
        if (founds.isEmpty()) {
            return null;
        }
        return founds;
    }

    private void searchOldVersions(List<DataFolderFound> founds, final Version currentVersion, FolderSet folderSet, final String dataFolderId, String dataFolderName) {
        final PackageManager versionFactory = ToolsLocator.getPackageManager();
        Object[] folders = folderSet.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                try {
                    String name = pathname.getName();
                    Version version = versionFactory.createVersion(name);
                    if (currentVersion.compareTo((Object)version) == 0) {
                        return false;
                    }
                    File dataFolder = FileUtils.getFile(pathname, DataFolderManager.DATAFOLDER_FILENAME, dataFolderId);
                    if (dataFolder.exists() && dataFolder.isDirectory()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
        if (ArrayUtils.isEmpty((Object[])folders)) {
            return;
        }
        File newDataFolder = FileUtils.getFile(this.getHomeFolder(), DATAFOLDER_FILENAME, dataFolderId);
        ScriptingFolder applicationFolder = (ScriptingFolder)this.manager.getUnit(dataFolderName);
        if (applicationFolder == null) {
            return;
        }
        DefaultDataFolderFound dataFolderFound = null;
        for (Object folder : folders) {
            File oldDataFolder = FileUtils.getFile((File)folder, DATAFOLDER_FILENAME, dataFolderId);
            Version oldDataFolderVersion = versionFactory.createVersion(FilenameUtils.getBaseName((String)((File)folder).getName()));
            if (dataFolderFound != null && oldDataFolderVersion.compareTo((Object)dataFolderFound.getOldDataFolderVersion()) <= 0) continue;
            dataFolderFound = new DefaultDataFolderFound(dataFolderId, applicationFolder, newDataFolder, oldDataFolder, oldDataFolderVersion);
        }
        if (dataFolderFound != null) {
            founds.add(dataFolderFound);
        }
    }

    private class DefaultDataFolderFound
    implements DataFolderFound {
        private final String dataFolderId;
        private final ScriptingFolder applicationFolder;
        private final File newDataFolder;
        private final File oldDataFolder;
        private final Version oldDataFolderVersion;

        public DefaultDataFolderFound(String dataFolderId, ScriptingFolder applicationFolder, File newDataFolder, File oldDataFolder, Version oldDataFolderVersion) {
            this.dataFolderId = dataFolderId;
            this.applicationFolder = applicationFolder;
            this.newDataFolder = newDataFolder;
            this.oldDataFolder = oldDataFolder;
            this.oldDataFolderVersion = oldDataFolderVersion;
        }

        public String getDataFolderId() {
            return this.dataFolderId;
        }

        public ScriptingFolder getApplicationFolder() {
            return this.applicationFolder;
        }

        public String getApplicationName() {
            if (this.applicationFolder == null) {
                return null;
            }
            return this.applicationFolder.getName();
        }

        public File getNewDataFolder() {
            return this.newDataFolder;
        }

        public File getOldDataFolder() {
            return this.oldDataFolder;
        }

        public Version getOldDataFolderVersion() {
            return this.oldDataFolderVersion;
        }

        public void restore() {
            try {
                FileUtils.copyDirectory(this.oldDataFolder, this.newDataFolder);
                DataFolderRegister register = new DataFolderRegister();
                DataFolderRegisterEntry entry = register.get(this.dataFolderId);
                entry.processed = true;
                register.put(entry);
                register.save();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't restore data folder found.", ex);
            }
        }

        public void leave() {
            DataFolderRegister register = new DataFolderRegister();
            DataFolderRegisterEntry entry = register.get(this.dataFolderId);
            entry.processed = true;
            register.put(entry);
            register.save();
        }
    }

    private class DataFolderRegister
    implements Iterable<DataFolderRegisterEntry> {
        private static final String DATAFOLDER_REGISTER_FILENAME = "data.properties";
        private static final String ID_KEY_SUFFIX = ".id";
        private static final String PATH_KEY_SUFFIX = ".path";
        private static final String PROCESSED_KEY_SUFFIX = ".processed";
        private Properties props;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public DataFolderRegister() {
            File f = FileUtils.getFile(DataFolderManager.this.getHomeFolder(), DATAFOLDER_REGISTER_FILENAME);
            this.props = new Properties();
            if (f.exists()) {
                FileInputStream inStream = null;
                try {
                    inStream = new FileInputStream(f);
                    this.props.load(inStream);
                }
                catch (Exception exception) {
                    IOUtils.closeQuietly((InputStream)inStream);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }

        private String getPathKey(String id) {
            return id + PATH_KEY_SUFFIX;
        }

        private String getProcessedKey(String id) {
            return id + PROCESSED_KEY_SUFFIX;
        }

        private String getIdKey(String id) {
            return id + ID_KEY_SUFFIX;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() {
            File f = FileUtils.getFile(DataFolderManager.this.getHomeFolder(), DATAFOLDER_REGISTER_FILENAME);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(f);
                this.props.store(out, "");
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }

        @Override
        public Iterator<DataFolderRegisterEntry> iterator() {
            HashSet<String> ids = new HashSet<String>();
            for (Object key : this.props.keySet()) {
                if (!StringUtils.endsWith((CharSequence)((String)key), (CharSequence)ID_KEY_SUFFIX)) continue;
                ids.add(this.props.getProperty((String)key));
            }
            final Iterator it = ids.iterator();
            return new Iterator<DataFolderRegisterEntry>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public DataFolderRegisterEntry next() {
                    String id = (String)it.next();
                    return DataFolderRegister.this.get(id);
                }
            };
        }

        public DataFolderRegisterEntry get(String id) {
            if (!this.props.containsKey(this.getIdKey(id))) {
                return null;
            }
            DataFolderRegisterEntry entry = new DataFolderRegisterEntry();
            entry.folderId = id;
            entry.folderPath = this.props.getProperty(this.getPathKey(id));
            entry.processed = BooleanUtils.toBoolean((String)this.props.getProperty(this.getProcessedKey(id)));
            return entry;
        }

        public void put(DataFolderRegisterEntry entry) {
            this.put(entry.folderId, entry.folderPath, entry.processed);
        }

        public void put(String id, String path, boolean processed) {
            this.props.setProperty(this.getIdKey(id), id);
            this.props.setProperty(this.getPathKey(id), path);
            this.props.setProperty(this.getProcessedKey(id), BooleanUtils.toStringTrueFalse((boolean)processed));
        }
    }

    private class DataFolderRegisterEntry {
        public String folderId;
        public String folderPath;
        public boolean processed;

        private DataFolderRegisterEntry() {
        }
    }
}

