/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.tika.Tika;
import org.gvsig.scripting.ScriptingExternalFile;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.impl.AbstractUnit;
import org.gvsig.scripting.impl.EncodingUtils;

public class DefaultScriptingExternalFile
extends AbstractUnit
implements ScriptingExternalFile {
    private File externFile = null;
    private String mimeType = null;
    private static Tika tika = null;

    public DefaultScriptingExternalFile(ScriptingFolder parent, ScriptingManager manager, String id) {
        super(parent, "ExternalFile", manager, id);
        this.externFile = new File(parent.getFile(), id);
    }

    @Override
    public void load(ScriptingFolder folder, String id) {
    }

    public boolean rename(String newId) {
        try {
            File newf = new File(this.externFile.getParentFile(), newId);
            FileUtils.moveFile((File)this.externFile, (File)newf);
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't rename '" + this.id + "' to '" + newId + "'.", ex);
        }
    }

    @Override
    public void create(ScriptingFolder folder, String id) {
        File file = this.externFile;
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LOGGER.warn("Can't create inf file in '" + file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    @Override
    public void create(ScriptingFolder folder, String id, String language) {
        this.create(folder, id);
    }

    public boolean remove() {
        return FileUtils.deleteQuietly((File)this.externFile);
    }

    public boolean move(ScriptingFolder target) {
        File target_f = target.getFile();
        File source_f = this.getExternalFile();
        try {
            FileUtils.copyFile((File)source_f, (File)target_f);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String[] getIconNames() {
        return new String[]{"scripting-icon-externalfile", "scripting-icon-externalfile-open"};
    }

    public File getExternalFile() {
        return this.externFile;
    }

    @Override
    public File getFile() {
        if (this.getId() == null) {
            return null;
        }
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent().getFile() == null) {
            return null;
        }
        return this.externFile;
    }

    public List<File> getFiles() {
        ArrayList<File> l = new ArrayList<File>();
        l.add(this.externFile);
        return l;
    }

    public String getMimeType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        if (tika == null) {
            tika = new Tika();
        }
        try {
            this.mimeType = tika.detect(this.externFile);
        }
        catch (IOException ex) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    public void setContents(String text) {
        try {
            Charset encoding = Charsets.toCharset((String)EncodingUtils.getEncoding(text));
            FileUtils.write((File)this.externFile, (CharSequence)text, (Charset)encoding);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getContentsAsText() {
        try {
            Charset encoding = Charsets.toCharset((String)EncodingUtils.getEncoding(this.externFile));
            return FileUtils.readFileToString((File)this.externFile, (Charset)encoding);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

