/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.lib.impl;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPDFDocument
implements PDFDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPDFDocument.class);
    private Object source;
    private int nummberOfPages = -1;
    private PDDocument document = null;

    public void setSource(Object source) {
        this.source = source;
        this.nummberOfPages = -1;
        this.document = null;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof InputStream) {
            return (InputStream)this.source;
        }
        if (this.source instanceof File) {
            File fileSource = (File)this.source;
            try {
                is = new FileInputStream(fileSource);
            }
            catch (IOException ex) {
                LOGGER.warn("Not been able to convert file to input stream", (Throwable)ex);
                throw new IOException(ex);
            }
        } else if (this.source instanceof URL) {
            URL urlSource = (URL)this.source;
            try {
                is = urlSource.openStream();
            }
            catch (IOException ex) {
                LOGGER.warn("Not been able to open URL stream", (Throwable)ex);
                throw new IOException(ex);
            }
        } else if (this.source instanceof String) {
            String strSource = (String)this.source;
            if (StringUtils.startsWithIgnoreCase((CharSequence)strSource, (CharSequence)"<html>")) {
                byte[] pdfbytes = this.html2pdf(strSource);
                if (pdfbytes == null) {
                    throw new IOException();
                }
                is = new ByteArrayInputStream(pdfbytes);
            } else {
                File f = new File(strSource);
                if (f.exists()) {
                    try {
                        is = new FileInputStream(f);
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.warn("Not been able to load existing file", (Throwable)ex);
                        throw new IOException(ex);
                    }
                } else {
                    try {
                        URL url = new URL(strSource);
                        is = url.openStream();
                        is.available();
                    }
                    catch (Exception ex) {
                        try {
                            byte[] data = Hex.decodeHex((char[])strSource.toCharArray());
                            is = new ByteArrayInputStream(data);
                        }
                        catch (DecoderException ex2) {
                            try {
                                byte[] data = Base64.decodeBase64((String)strSource);
                                is = new ByteArrayInputStream(data);
                            }
                            catch (Exception ex3) {
                                throw new IOException(ex3);
                            }
                        }
                    }
                }
            }
        } else if (this.source instanceof byte[]) {
            byte[] byteSource = (byte[])this.source;
            is = new ByteArrayInputStream(byteSource);
        }
        return is;
    }

    public byte[] toByteArray() {
        if (this.source != null) {
            try {
                InputStream is = this.getInputStream();
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                return bytes;
            }
            catch (IOException ex) {
                LOGGER.warn("Not been able to convert pdf to byte array", (Throwable)ex);
            }
        }
        return null;
    }

    private String bytearray_hex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte abyte : data) {
            int v = abyte & 0xFF;
            builder.append(String.format("%02x", v));
        }
        return builder.toString();
    }

    public String toHexString() {
        byte[] data = this.toByteArray();
        return this.bytearray_hex(data);
    }

    public int getNumberOfPages() {
        if (this.source == null) {
            return -1;
        }
        if (this.nummberOfPages >= 0) {
            return this.nummberOfPages;
        }
        try {
            InputStream is = this.getInputStream();
            this.document = PDDocument.load((InputStream)is);
            this.nummberOfPages = this.document.getNumberOfPages();
            return this.nummberOfPages;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public SimpleImage toImage() {
        return this.toImage(0, 300);
    }

    public SimpleImage toImage(int page) {
        return this.toImage(page, 300);
    }

    public SimpleImage toImage(int page, int dpis) {
        if (this.source == null) {
            return null;
        }
        if (page < 0) {
            return null;
        }
        try {
            if (this.document == null) {
                InputStream is = this.getInputStream();
                this.document = PDDocument.load((InputStream)is);
                this.nummberOfPages = this.document.getNumberOfPages();
            }
            if (page >= this.nummberOfPages) {
                return null;
            }
            PDFRenderer pdfRenderer = new PDFRenderer(this.document);
            BufferedImage img = pdfRenderer.renderImageWithDPI(page, (float)dpis, ImageType.RGB);
            return ToolsSwingLocator.getToolsSwingManager().createSimpleImage((Object)img);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public void dispose() {
        IOUtils.closeQuietly((Closeable)this.document);
        this.source = null;
        this.nummberOfPages = -1;
        this.document = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] html2pdf(String html) {
        byte[] byArray;
        ByteArrayOutputStream pdfstream = null;
        try {
            if (StringUtils.contains((CharSequence)html, (CharSequence)"<br>")) {
                html = StringUtils.replace((String)html, (String)"<br>", (String)"<br/>");
            }
            if (StringUtils.contains((CharSequence)html, (CharSequence)"&nbsp;")) {
                html = StringUtils.replace((String)html, (String)"&nbsp;", (String)"&#xA0;");
            }
            pdfstream = new ByteArrayOutputStream();
            Document jsoupDoc = Jsoup.parse((String)html);
            W3CDom w3cDom = new W3CDom();
            org.w3c.dom.Document w3cDoc = w3cDom.fromJsoup(jsoupDoc);
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.useFastMode();
            builder.toStream((OutputStream)pdfstream);
            builder.withW3cDocument(w3cDoc, "file://localhost/");
            Class<?> cls = this.getClass();
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSans.ttf"), "Sans", Integer.valueOf(400), BaseRendererBuilder.FontStyle.NORMAL, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSans-Bold.ttf"), "Sans", Integer.valueOf(700), BaseRendererBuilder.FontStyle.NORMAL, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSans-Oblique.ttf"), "Sans", Integer.valueOf(400), BaseRendererBuilder.FontStyle.OBLIQUE, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSans-BoldOblique.ttf"), "Sans", Integer.valueOf(700), BaseRendererBuilder.FontStyle.OBLIQUE, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSerif.ttf"), "Serif", Integer.valueOf(400), BaseRendererBuilder.FontStyle.NORMAL, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSerif-Bold.ttf"), "Serif", Integer.valueOf(700), BaseRendererBuilder.FontStyle.NORMAL, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSerif-Italic.ttf"), "Serif", Integer.valueOf(400), BaseRendererBuilder.FontStyle.ITALIC, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuSerif-BoldItalic.ttf"), "Serif", Integer.valueOf(700), BaseRendererBuilder.FontStyle.ITALIC, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuMono.ttf"), "Mono", Integer.valueOf(400), BaseRendererBuilder.FontStyle.NORMAL, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuMono-Bold.ttf"), "Mono", Integer.valueOf(700), BaseRendererBuilder.FontStyle.NORMAL, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuMono-Oblique.ttf"), "Mono", Integer.valueOf(400), BaseRendererBuilder.FontStyle.OBLIQUE, true);
            builder.useFont(() -> cls.getResourceAsStream("dejavu/DejaVuMono-BoldOblique.ttf"), "Mono", Integer.valueOf(700), BaseRendererBuilder.FontStyle.OBLIQUE, true);
            builder.run();
            byArray = pdfstream.toByteArray();
        }
        catch (Throwable t) {
            try {
                LOGGER.warn("Can't convert HTML to PDF.", t);
                byte[] byArray2 = null;
                return byArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(pdfstream);
            }
        }
        IOUtils.closeQuietly((OutputStream)pdfstream);
        return byArray;
    }
}

