/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.DependenciesCalculator;
import org.gvsig.installer.lib.api.Dependency;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.PackageInfoReader;
import org.gvsig.installer.lib.api.PackageInfoWriter;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.api.creation.MakePackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.impl.DefaultDependenciesCalculator;
import org.gvsig.installer.lib.impl.DefaultDependency;
import org.gvsig.installer.lib.impl.DefaultInstallerProviderManager;
import org.gvsig.installer.lib.impl.DefaultPackageInfo;
import org.gvsig.installer.lib.impl.DefaultVersion;
import org.gvsig.installer.lib.impl.creation.DefaultMakePackageService;
import org.gvsig.installer.lib.impl.info.InstallerInfoFileReader;
import org.gvsig.installer.lib.impl.info.InstallerInfoFileWriter;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.AbstractManager;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.ProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstallerManager
extends AbstractManager
implements InstallerManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultInstallerManager.class);
    private static final String INSTALLER_MANAGER_EXTENSION_POINT = "InstallerManagerExtensionPoint";
    private static final String INSTALLER_CREATION_SERVICE_NAME = "InstallerCreationService";
    private static final String INSTALLER_EXECUTION_SERVICE_NAME = "InstallerExecutionService";
    private ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
    private String packageSetNameFormat = "gvSIG-desktop-{0}-{1}-{2}-{4}-{5}-{6}-{7}.gvspks";
    private String packageNameFormat = "gvSIG-desktop-{0}-{1}-{2}-{4}-{5}-{6}-{7}.gvspkg";
    private String packageIndexNameFormat = "gvSIG-desktop-{0}-{1}-{2}-{4}-{5}-{6}-{7}.gvspki";
    private URL BaseDownloadURL = null;
    private Version version = null;
    private List<LocalRepositoryLocation> localRepositoriesLocation = null;
    private Map<String, File> defaultRepositoryLocation = new HashMap<String, File>();
    private String operatingSystemName;
    private String operatingSystemFamily;
    private String operatingSystemVersion;

    public DefaultInstallerManager() {
        super((ProviderManager)new DefaultInstallerProviderManager());
        this.localRepositoriesLocation = new LocalRepositoriesLocations();
    }

    public String getPackageSetNameFormat() {
        return this.packageSetNameFormat;
    }

    public void setPackageSetNameFormat(String packageSetNameFormat) {
        this.packageSetNameFormat = packageSetNameFormat;
    }

    public String getPackageNameFormat() {
        return this.packageNameFormat;
    }

    public void setPackageNameFormat(String packageNameFormat) {
        this.packageNameFormat = packageNameFormat;
    }

    public String getPackageIndexNameFormat() {
        return this.packageIndexNameFormat;
    }

    public void setPackageIndexNameFormat(String packageIndexNameFormat) {
        this.packageIndexNameFormat = packageIndexNameFormat;
    }

    public MakePluginPackageService getMakePluginPackageService() throws MakePluginPackageServiceException {
        ExtensionPoint ep = this.extensionPoints.add(INSTALLER_MANAGER_EXTENSION_POINT);
        try {
            Object[] args = new Object[]{this};
            return (MakePluginPackageService)ep.create(INSTALLER_CREATION_SERVICE_NAME, args);
        }
        catch (Exception e) {
            throw new MakePluginPackageServiceException("Exception creating the installer service to create installers", (Throwable)e);
        }
    }

    public InstallPackageService getInstallPackageService() throws InstallPackageServiceException {
        ExtensionPoint ep = this.extensionPoints.add(INSTALLER_MANAGER_EXTENSION_POINT);
        try {
            Object[] args = new Object[]{this};
            return (InstallPackageService)ep.create(INSTALLER_EXECUTION_SERVICE_NAME, args);
        }
        catch (Exception e) {
            throw new InstallerCreationException(e);
        }
    }

    public void registerMakePluginPackageService(Class<? extends MakePluginPackageService> clazz) {
        ExtensionPoint extensionPoint = this.extensionPoints.add(INSTALLER_MANAGER_EXTENSION_POINT, "");
        extensionPoint.append(INSTALLER_CREATION_SERVICE_NAME, "", clazz);
    }

    public void registerInstallPackageService(Class<? extends InstallPackageService> clazz) {
        ExtensionPoint extensionPoint = this.extensionPoints.add(INSTALLER_MANAGER_EXTENSION_POINT, "");
        extensionPoint.append(INSTALLER_EXECUTION_SERVICE_NAME, "", clazz);
    }

    public Service getService(DynObject parameters) throws ServiceException {
        return null;
    }

    public String getPackageSetFileName(PackageInfo info) {
        Object[] parameters = this.getPackageNameFormatParameters(info);
        return MessageFormat.format(this.getPackageSetNameFormat(), parameters);
    }

    public String getPackageFileName(PackageInfo info) {
        Object[] parameters = this.getPackageNameFormatParameters(info);
        return MessageFormat.format(this.getPackageNameFormat(), parameters);
    }

    public String getPackageIndexFileName(PackageInfo info) {
        Object[] parameters = this.getPackageNameFormatParameters(info);
        return MessageFormat.format(this.getPackageIndexNameFormat(), parameters);
    }

    private Object[] getPackageNameFormatParameters(PackageInfo info) {
        Object[] parameters = new Object[]{info.getGvSIGVersion(), info.getCode(), info.getVersion(), info.getBuild(), info.getState(), info.getOperatingSystem(), info.getArchitecture(), info.getJavaVM()};
        return parameters;
    }

    public PackageInfo[] getInstalledPackages(File pluginsDirectory) throws MakePluginPackageServiceException {
        MakePluginPackageService service = this.getMakePluginPackageService();
        return service.getInstalledPackages();
    }

    public PackageInfo[] getInstalledPackages() throws MakePluginPackageServiceException {
        MakePluginPackageService service = this.getMakePluginPackageService();
        return service.getInstalledPackages();
    }

    public String getDefaultPackageFileExtension() {
        return "gvspkg";
    }

    public String getDefaultPackageSetFileExtension() {
        return "gvspks";
    }

    public String getDefaultIndexSetFileExtension() {
        return "gvspki";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadOperatingSystemInfo() {
        block6: {
            String osversion;
            String osname;
            block7: {
                osname = System.getProperty("os.name");
                osversion = System.getProperty("os.version");
                if (!osname.toLowerCase().startsWith("linux")) break block7;
                this.operatingSystemFamily = "lin";
                FileInputStream fis = null;
                try {
                    Properties p = new Properties();
                    fis = new FileInputStream("/etc/os-release");
                    p.load(fis);
                    this.operatingSystemName = p.getProperty("ID", null);
                    this.operatingSystemVersion = p.getProperty("VERSION_ID", null);
                }
                catch (Exception exception) {
                    IOUtils.closeQuietly(fis);
                    break block6;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
                break block6;
            }
            if (osname.toLowerCase().startsWith("window")) {
                this.operatingSystemFamily = "win";
                String s = osname.replace(" ", "");
                s = s.replace("_", "");
                this.operatingSystemName = s = s.replace("-", "");
                this.operatingSystemVersion = osversion;
            } else {
                String s = osname.replace(" ", "");
                s = s.replace("_", "");
                this.operatingSystemFamily = s = s.replace("-", "");
                this.operatingSystemName = null;
                this.operatingSystemVersion = osversion;
            }
        }
    }

    public String getOperatingSystem() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.operatingSystemFamily);
        if (this.operatingSystemName != null) {
            builder.append("_");
            builder.append(this.operatingSystemName);
            if (this.operatingSystemVersion != null) {
                builder.append("_");
                builder.append(this.operatingSystemVersion);
            }
        }
        return builder.toString();
    }

    public String getOperatingSystemFamily() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        return this.operatingSystemFamily;
    }

    public String getOperatingSystemName() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        return this.operatingSystemName;
    }

    public String getOperatingSystemVersion() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        return this.operatingSystemVersion;
    }

    public String getArchitecture() {
        String osarch = System.getProperty("os.arch");
        if (osarch.toLowerCase().startsWith("i386")) {
            return "x86";
        }
        if (osarch.toLowerCase().startsWith("i686")) {
            return "x86";
        }
        if (osarch.toLowerCase().startsWith("x86_64")) {
            return "x86_64";
        }
        if (osarch.toLowerCase().startsWith("x86")) {
            return "x86";
        }
        if (osarch.toLowerCase().startsWith("amd64")) {
            return "x86_64";
        }
        return osarch;
    }

    public Dependency createDependency(PackageInfo packageInfo) {
        return new DefaultDependency(packageInfo);
    }

    public Dependency createDependency() {
        return new DefaultDependency();
    }

    public DependenciesCalculator createDependenciesCalculator(InstallPackageService installService) {
        return new DefaultDependenciesCalculator(installService);
    }

    public Version createVersion() {
        if (this.version == null) {
            return new DefaultVersion();
        }
        Version v = null;
        try {
            v = (Version)this.version.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return v;
    }

    public PackageInfoReader getDefaultPackageInfoReader() {
        return new InstallerInfoFileReader();
    }

    public PackageInfoWriter getDefaultPackageInfoWriter() {
        return new InstallerInfoFileWriter();
    }

    public MakePackageService createMakePackage(File packageFolder, PackageInfo packageInfo) {
        return new DefaultMakePackageService(this, packageFolder, packageInfo);
    }

    public PackageInfo createPackageInfo() {
        return new DefaultPackageInfo();
    }

    public PackageInfo createPackageInfo(InputStream stream) throws BaseException {
        DefaultPackageInfo pkg = new DefaultPackageInfo();
        PackageInfoReader reader = this.getDefaultPackageInfoReader();
        reader.read((PackageInfo)pkg, stream);
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInfo createPackageInfo(File file) throws BaseException {
        FileInputStream fis = null;
        PackageInfo pkg = null;
        try {
            fis = new FileInputStream(file);
            pkg = this.createPackageInfo(fis);
            fis.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return pkg;
    }

    public URL getDownloadBaseURL() {
        return this.BaseDownloadURL;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public void setVersion(Version version) {
        try {
            this.version = (Version)version.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public Version getVersionEx() {
        try {
            return (Version)this.version.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setDownloadBaseURL(URL url) {
        this.BaseDownloadURL = url;
    }

    public void setVersion(String version) {
        if (this.version == null) {
            this.version = new DefaultVersion();
        }
        this.version.parse(version);
    }

    public File getDefaultLocalAddonRepository() {
        File f = this.defaultRepositoryLocation.get("plugin");
        return f;
    }

    public void setDefaultLocalAddonRepository(File defaultAddonsRepository) {
        this.defaultRepositoryLocation.put("plugin", defaultAddonsRepository);
        this.localRepositoriesLocation.add(new LocalRepositoryLocation(defaultAddonsRepository, "plugin"));
    }

    public void addLocalAddonRepository(File path) {
        this.addLocalAddonRepository(path, "plugin");
    }

    public File getDefaultLocalAddonRepository(String packageType) {
        return this.getDefaultLocalAddonRepository(packageType, 0);
    }

    public boolean needAdminRights() {
        List<File> folders = this.getLocalAddonRepositories();
        for (File folder : folders) {
            if (this.canWrite(folder)) continue;
            return true;
        }
        return false;
    }

    private boolean canWrite(File f) {
        if (!f.canWrite()) {
            return false;
        }
        File f2 = new File(f, "test.dir");
        if (f2.mkdir()) {
            f2.delete();
            return true;
        }
        return false;
    }

    public File getDefaultLocalAddonRepository(String packageType, int access) {
        File f = this.defaultRepositoryLocation.get(packageType);
        switch (access) {
            case 1: {
                if (!this.canWrite(f)) break;
                return f;
            }
            default: {
                if (!f.canRead()) break;
                return f;
            }
        }
        List<File> repositoriesLocaltions = this.getLocalAddonRepositories(packageType);
        block6: for (File repositoryLocation : repositoriesLocaltions) {
            switch (access) {
                case 1: {
                    if (!this.canWrite(repositoryLocation)) continue block6;
                    return repositoryLocation;
                }
            }
            if (!repositoryLocation.canRead()) continue;
            return repositoryLocation;
        }
        return null;
    }

    public void setDefaultLocalAddonRepository(File defaultAddonsRepository, String packageType) {
        this.defaultRepositoryLocation.put(packageType, defaultAddonsRepository);
        this.localRepositoriesLocation.add(new LocalRepositoryLocation(defaultAddonsRepository, packageType));
    }

    public void addLocalAddonRepository(File path, String type) {
        this.localRepositoriesLocation.add(new LocalRepositoryLocation(path, type));
    }

    public String getDefaultLocalRepositoryType(File file) {
        for (LocalRepositoryLocation location : this.localRepositoriesLocation) {
            if (!location.contains(file)) continue;
            return location.getDefaultType();
        }
        return null;
    }

    public List<File> getLocalAddonRepositories() {
        return this.getLocalAddonRepositories(null);
    }

    public List<File> getLocalAddonRepositories(String type) {
        ArrayList<File> l = new ArrayList<File>();
        for (LocalRepositoryLocation location : this.localRepositoriesLocation) {
            if (type != null && !location.support(type)) continue;
            l.add(location.getLocation());
        }
        return l;
    }

    public List<File> getAddonFolders() {
        return this.getAddonFolders(null);
    }

    public List<File> getAddonFolders(String type) {
        ArrayList<File> addonFolders = new ArrayList<File>();
        List<File> localAddonRepositories = this.getLocalAddonRepositories(type);
        for (int i = 0; i < localAddonRepositories.size(); ++i) {
            File repoPath = localAddonRepositories.get(i);
            if (!repoPath.isDirectory() || !repoPath.exists()) continue;
            File[] folderRepoList = repoPath.listFiles();
            for (int j = 0; j < folderRepoList.length; ++j) {
                File pkginfofile;
                File addonFolder = folderRepoList[j];
                if (!addonFolder.isDirectory() || !(pkginfofile = new File(addonFolder, "package.info")).exists()) continue;
                addonFolders.add(addonFolder);
            }
        }
        return addonFolders;
    }

    public File getAddonFolder(String code) {
        List<File> packagePaths = this.getAddonFolders();
        for (int i = 0; i < packagePaths.size(); ++i) {
            try {
                File pkgfile = new File(packagePaths.get(i), "package.info");
                PackageInfo pkg = this.createPackageInfo(pkgfile);
                if (!pkg.getCode().equalsIgnoreCase(code)) continue;
                return packagePaths.get(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public List<byte[]> getPublicKeys() {
        byte[] rawkey;
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/gvsig/installer/lib/keys/key.public");
            rawkey = new byte[is.available()];
            is.read(rawkey);
            is.close();
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        keys.add(rawkey);
        return keys;
    }

    public boolean hasProviderToThisPackage(PackageInfo packageInfo) {
        InstallerProviderManager provmgr = (InstallerProviderManager)this.getProviderManager();
        try {
            return provmgr.getProviderFactory(packageInfo.getType()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public class InstallerCreationException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 759329820705535873L;
        private static final String message = "Error creating the installer service to install plugins";
        private static final String KEY = "_Error_creating_the_installer_service_to_install_plugins";

        public InstallerCreationException(Exception e) {
            super(message, (Throwable)e, KEY, 759329820705535873L);
        }
    }

    private static class LocalRepositoriesLocations
    extends ArrayList<LocalRepositoryLocation> {
        private LocalRepositoriesLocations() {
        }

        public LocalRepositoryLocation getLocation(File location) {
            Iterator it = super.iterator();
            while (it.hasNext()) {
                LocalRepositoryLocation x = (LocalRepositoryLocation)it.next();
                if (!x.is(location)) continue;
                return x;
            }
            return null;
        }

        @Override
        public boolean add(LocalRepositoryLocation location) {
            LocalRepositoryLocation old = this.getLocation(location.getLocation());
            if (old != null) {
                old.addType(location);
                return true;
            }
            return super.add(location);
        }
    }

    private static class LocalRepositoryLocation {
        private File location;
        private Set<String> types;

        public LocalRepositoryLocation(File localtion, String type) {
            this.location = localtion;
            this.types = new HashSet<String>();
            this.addType(type);
        }

        public LocalRepositoryLocation(File localtion) {
            this(localtion, null);
        }

        public void addType(String type) {
            if (!StringUtils.isBlank((CharSequence)type)) {
                this.types.add(type);
            }
        }

        public void addType(LocalRepositoryLocation location) {
            this.types.addAll(location.getTypes());
        }

        public Collection<String> getTypes() {
            return this.types;
        }

        public File getLocation() {
            return this.location;
        }

        public String getDefaultType() {
            if (this.types.isEmpty()) {
                return null;
            }
            return this.types.iterator().next();
        }

        public boolean is(File location) {
            return location.equals(this.location);
        }

        public boolean contains(File file) {
            return file.getAbsolutePath().startsWith(this.location.getAbsolutePath());
        }

        public boolean contains(PackageInfo packageInfo) {
            if (!this.support(packageInfo.getType())) {
                return false;
            }
            String packageInfoName = packageInfo.getCode() + File.separator + "package.info";
            File packageInfoFile = new File(this.location, packageInfoName);
            return packageInfoFile.exists();
        }

        public boolean support(String type) {
            for (String atype : this.types) {
                if (atype == null || !atype.equalsIgnoreCase(type)) continue;
                return true;
            }
            return false;
        }
    }
}

