/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.impl.DefaultDependencies;
import org.gvsig.installer.lib.impl.DefaultVersion;
import org.gvsig.installer.lib.impl.utils.DeleteFile;
import org.gvsig.installer.lib.impl.utils.Download;
import org.gvsig.installer.lib.impl.utils.SignUtil;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.packageutils.StringWithAlias;
import org.gvsig.tools.packageutils.impl.DefaultStringWithAlias;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageInfo
implements PackageInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPackageInfo.class);
    private StringWithAlias code = null;
    private String name = null;
    private String description = null;
    private Version version = null;
    private boolean official;
    private List<File> auxFiles = new ArrayList<File>();
    private String antScript = null;
    private String type = "unknow";
    private Boolean signed = false;
    private Boolean broken = false;
    private String state = "devel";
    private String operatingSystemFamily = "all";
    private String operatingSystemName = null;
    private String operatingSystemVersion = null;
    private String architecture = "all";
    private String javaVM = "j1_5";
    private String owner = "";
    private URL ownerURL = null;
    private URL sources = null;
    private String gvSIGVersion = "";
    private String defaultDownloadURL = null;
    private String modelVersion = "1.0.1";
    private Dependencies dependencies = null;
    private List<String> categories = null;
    private URL webURL = null;
    private static PackageManager packageManager = null;

    public DefaultPackageInfo() {
        this.version = new DefaultVersion().parse("0.0.1");
        this.dependencies = new DefaultDependencies();
        this.categories = new ArrayList<String>();
    }

    public String getCode() {
        if (this.code == null) {
            return null;
        }
        return this.code.toString();
    }

    public StringWithAlias getAllCodes() {
        return this.code;
    }

    private String getAliasAsString() {
        if (this.code == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        Iterator alias = this.code.getAlias().iterator();
        while (alias.hasNext()) {
            String ss = (String)alias.next();
            s.append(ss);
            if (!alias.hasNext()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    public boolean hasThisCode(String code) {
        if (this.code == null) {
            return code == null;
        }
        return this.code.equalsIgnoreCase((Object)code);
    }

    public boolean hasThisCode(StringWithAlias code) {
        if (this.code == null) {
            return code == null;
        }
        return this.code.equalsIgnoreCase((Object)code);
    }

    public String getID() {
        String id = this.getCode() + "#" + this.getVersion() + "#" + this.getOperatingSystem() + "#" + this.getArchitecture();
        return id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getBuild() {
        return this.version.getBuild();
    }

    public String getState() {
        return this.state;
    }

    public boolean isOfficial() {
        return this.official;
    }

    public void setCode(String code) {
        this.code = code == null ? null : new DefaultStringWithAlias(code);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        if (version == null) {
            return;
        }
        int prev = this.version.getBuild();
        this.version.parse(version);
        int curr = this.version.getBuild();
        if (prev != 0 && curr == 0) {
            this.version.setBuild(prev);
        }
    }

    public void setVersion(Version version) {
        try {
            int prev = this.version.getBuild();
            this.version = (Version)version.clone();
            int curr = this.version.getBuild();
            if (prev != 0 && curr == 0) {
                this.version.setBuild(prev);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBuild(int build) {
        this.version.setBuild(build);
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public String getOperatingSystem() {
        StringBuilder operatingSystem = new StringBuilder();
        operatingSystem.append(this.operatingSystemFamily);
        if (!StringUtils.isEmpty((CharSequence)this.operatingSystemName)) {
            operatingSystem.append("_");
            operatingSystem.append(this.operatingSystemName);
            if (!StringUtils.isEmpty((CharSequence)this.operatingSystemVersion)) {
                operatingSystem.append("_");
                operatingSystem.append(this.operatingSystemVersion);
            }
        }
        return operatingSystem.toString();
    }

    public void setOperatingSystem(String operatingSystem) {
        if (StringUtils.isEmpty((CharSequence)operatingSystem)) {
            this.operatingSystemFamily = "all";
            this.operatingSystemName = null;
            this.operatingSystemVersion = null;
        } else if (operatingSystem.contains("_")) {
            String[] s = operatingSystem.split("_");
            switch (s.length) {
                case 2: {
                    this.operatingSystemFamily = s[0];
                    this.operatingSystemName = s[1];
                    break;
                }
                case 3: {
                    this.operatingSystemFamily = s[0];
                    this.operatingSystemName = s[1];
                    this.operatingSystemVersion = s[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can't parse OS '" + operatingSystem + "'.");
                }
            }
        } else {
            this.operatingSystemFamily = operatingSystem;
        }
    }

    public String getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemFamily(String operatingSystemFamily) {
        this.operatingSystemFamily = operatingSystemFamily;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getJavaVM() {
        return this.javaVM;
    }

    public void setJavaVM(String javaVM) {
        this.javaVM = javaVM;
    }

    public String getAntScript() {
        return this.antScript;
    }

    public void setAntScript(String antScript) {
        this.antScript = antScript;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGvSIGVersion() {
        return this.gvSIGVersion;
    }

    public void setGvSIGVersion(String gvSIGVersion) {
        this.gvSIGVersion = gvSIGVersion;
    }

    private URL internalGetDownloadURL() {
        if (this.defaultDownloadURL != null) {
            try {
                return new URL(this.defaultDownloadURL);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error converting to URL the package download url: " + this.defaultDownloadURL, e);
            }
        }
        return null;
    }

    public URL getDownloadURL() {
        InstallerManager manager = InstallerLocator.getInstallerManager();
        if (manager == null) {
            return null;
        }
        return this.getDownloadURL(manager.getDownloadBaseURL());
    }

    public URL getDownloadURL(URL baseURL) {
        try {
            return this.internalGetDownloadURL();
        }
        catch (RuntimeException runtimeException) {
            try {
                return new URL(baseURL, this.defaultDownloadURL);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error converting to URL the package download url, with the base URL: " + baseURL + ", the package download URL: " + this.defaultDownloadURL, e);
            }
        }
    }

    public String getDownloadURLAsString() {
        return this.defaultDownloadURL;
    }

    public void setDownloadURL(URL defaultDownloadURL) {
        this.defaultDownloadURL = defaultDownloadURL.toString();
    }

    public void setDownloadURL(String defaultDownloadURL) {
        this.defaultDownloadURL = defaultDownloadURL;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public URL getOwnerURL() {
        return this.ownerURL;
    }

    public void setOwnerURL(URL sources) {
        this.ownerURL = sources;
    }

    public URL getSourcesURL() {
        return this.sources;
    }

    public void setSourcesURL(URL sources) {
        this.sources = sources;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString()).append(" (");
        this.append(buffer, "code", this.getCode());
        this.append(buffer, "name", this.getName());
        this.append(buffer, "description", this.getDescription());
        this.append(buffer, "gvSIG-version", this.getGvSIGVersion());
        this.append(buffer, "version", this.getVersion());
        this.append(buffer, "buildNumber", this.getBuild());
        this.append(buffer, "operating-system", this.getOperatingSystem());
        this.append(buffer, "architecture", this.getArchitecture());
        this.append(buffer, "java-version", this.getJavaVM());
        this.append(buffer, "download-url", this.getDownloadURL());
        this.append(buffer, "state", this.getState());
        this.append(buffer, "official", this.isOfficial());
        this.append(buffer, "type", this.getType());
        this.append(buffer, "model-version", this.getModelVersion());
        this.append(buffer, "owner", this.getOwner());
        this.append(buffer, "owner-url", this.getOwnerURL());
        this.append(buffer, "sources-url", this.getSourcesURL());
        this.append(buffer, "dependencies", this.getDependencies());
        this.append(buffer, "web-url", this.getWebURL());
        this.append(buffer, "categories", this.getCategories());
        this.append(buffer, "code-alias", this.getAliasAsString());
        return buffer.append(')').toString();
    }

    public String toStringCompact() {
        return String.format("%1$-8.8s %2$-40s %3$-20.20s %4$-5.5s %5$-5.5s %6$-6.6s %7$-5.5s %8$s %8$s", this.type, this.code, this.version, this.state, this.getOperatingSystem(), this.architecture, this.javaVM, this.dependencies, this.getAliasAsString());
    }

    private DefaultPackageInfo append(StringBuffer buffer, String key, Object value) {
        buffer.append("\n\t").append(key).append(": ").append(value == null ? "" : value);
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPackageInfo clone = (DefaultPackageInfo)super.clone();
        clone.auxFiles = new ArrayList<File>(this.auxFiles);
        return clone;
    }

    public File downloadFile() throws InstallPackageServiceException {
        return this.downloadFile(null);
    }

    public File downloadFile(SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        File file = null;
        try {
            Download download = new Download(taskStatus);
            String versionRelativePath = "../../pool/" + this.getCode() + "/" + this.getPackageFileName();
            file = this.downloadFromRelativeURL(download, versionRelativePath);
            if (file == null) {
                String buildRelativePath = "../../../../pool/" + this.getCode() + "/" + this.getPackageFileName();
                file = this.downloadFromRelativeURL(download, buildRelativePath);
            }
            if (file == null) {
                file = this.downloadFromPackageInfoURL(download);
            }
        }
        catch (InstallPackageServiceException ex) {
            LOG.info("Can't download package '" + this.getCode() + "' from server '" + this.getBaseURL().toString() + "'.", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            LOG.info("Can't download package '" + this.getCode() + "' from server '" + this.getBaseURL().toString() + "'.", (Throwable)ex);
            throw ex;
        }
        if (file == null) {
            LOG.info("Can't download package '" + this.getCode() + "' from server '" + this.getBaseURL().toString() + "'.");
        }
        return file;
    }

    private URL getBaseURL() {
        InstallerManager manager = InstallerLocator.getInstallerManager();
        URL baseURL = manager.getDownloadBaseURL();
        return baseURL;
    }

    private File downloadFromRelativeURL(Download download, String buildRelativePath) {
        InstallerManager manager = InstallerLocator.getInstallerManager();
        URL baseURL = manager.getDownloadBaseURL();
        try {
            URL downloadURL = new URL(baseURL, buildRelativePath);
            return download.downloadFile(downloadURL, null);
        }
        catch (IOException e) {
            LOG.debug("Package " + this.getName() + " not found relative to the build index URL: " + baseURL + ", in the URL: " + buildRelativePath, (Throwable)e);
            return null;
        }
    }

    private File downloadFromPackageInfoURL(Download download) throws FileDownloadException {
        URL url = this.getDownloadURL();
        try {
            return download.downloadFile(url, null);
        }
        catch (SSLHandshakeException ex) {
            try {
                url = new URL("http", url.getHost(), url.getPort(), url.getFile());
                return download.downloadFile(url, null);
            }
            catch (Exception ex1) {
                throw new FileDownloadException(this.getDownloadURL(), ex1);
            }
        }
        catch (Exception ex) {
            throw new FileDownloadException(this.getDownloadURL(), ex);
        }
    }

    private String getPackageFileName() {
        Object[] values = new Object[]{"gvSIG-desktop", this.getGvSIGVersion(), this.getCode(), this.getVersion(), this.getState(), this.getOperatingSystem(), this.getArchitecture(), this.getJavaVM()};
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length - 1; ++i) {
            buffer.append(values[i]).append('-');
        }
        buffer.append(values[values.length - 1]).append(".gvspkg");
        return buffer.toString();
    }

    public void addFileToCopy(File file) {
        this.auxFiles.add(file);
    }

    public File getFileToCopy(int i) {
        return this.auxFiles.get(i);
    }

    public void removeFileToCopy(File file) {
        this.auxFiles.remove(file);
    }

    public void clearFilesToCopy() {
        this.auxFiles.clear();
    }

    public List<File> getFilesToCopy() {
        return this.auxFiles;
    }

    public boolean removeInstallFolder(File folder) {
        DeleteFile delete = new DeleteFile();
        boolean success = delete.delete(folder);
        this.setAntScript(null);
        this.clearFilesToCopy();
        return success;
    }

    public boolean removeFilesFolder(File folder) {
        DeleteFile delete = new DeleteFile();
        return delete.delete(folder);
    }

    public boolean matchID(String string) {
        boolean PART_CODE = false;
        boolean PART_VERSION = true;
        int PART_OS = 2;
        int PART_ARCH = 3;
        String id = this.getID();
        String[] parts = string.split("#");
        switch (parts.length) {
            case 1: {
                return parts[0].equals(this.getCode());
            }
            case 2: {
                if (!parts[0].equals(this.getCode())) {
                    return false;
                }
                DefaultVersion version = new DefaultVersion();
                try {
                    version.parse(parts[1]);
                }
                catch (InvalidParameterException ex) {
                    return false;
                }
                return ((Object)version).equals(this.getVersion());
            }
            case 4: {
                if (!parts[0].equals(this.getCode())) {
                    return false;
                }
                if (!"any".equalsIgnoreCase(parts[1])) {
                    org.gvsig.tools.packageutils.impl.DefaultVersion version = new org.gvsig.tools.packageutils.impl.DefaultVersion();
                    try {
                        version.parse(parts[1]);
                    }
                    catch (InvalidParameterException ex) {
                        return false;
                    }
                    if (!version.equals(this.getVersion())) {
                        return false;
                    }
                }
                if (!"any".equalsIgnoreCase(parts[2])) {
                    if ("current".equalsIgnoreCase(parts[2])) {
                        if (!this.getOperatingSystemFamily().equalsIgnoreCase(this.getPackageManager().getOperatingSystemFamily())) {
                            return false;
                        }
                        if (!StringUtils.isEmpty((CharSequence)this.getOperatingSystemName())) {
                            if (!this.getOperatingSystemName().equalsIgnoreCase(this.getPackageManager().getOperatingSystemName())) {
                                return false;
                            }
                            if (!StringUtils.isEmpty((CharSequence)this.getOperatingSystemVersion()) && !this.getOperatingSystemVersion().equalsIgnoreCase(this.getPackageManager().getOperatingSystemVersion())) {
                                return false;
                            }
                        }
                    } else if (!this.getOperatingSystem().equalsIgnoreCase(parts[2])) {
                        return false;
                    }
                }
                return "any".equalsIgnoreCase(parts[3]) || !("current".equalsIgnoreCase(parts[3]) ? !this.getArchitecture().equalsIgnoreCase(this.getPackageManager().getArchitecture()) : !this.getArchitecture().equalsIgnoreCase(parts[3]));
            }
        }
        return string.equals(id);
    }

    private PackageManager getPackageManager() {
        if (packageManager == null) {
            packageManager = ToolsLocator.getPackageManager();
        }
        return packageManager;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Dependencies dependencies) {
        this.dependencies = dependencies;
    }

    public void setDependencies(String dependencies) {
        this.dependencies = dependencies == null ? null : new DefaultDependencies().parse(dependencies);
    }

    public boolean equals(Object obj) {
        PackageInfo other;
        try {
            other = (PackageInfo)obj;
        }
        catch (Exception e) {
            return false;
        }
        if (!this.code.equalsIgnoreCase((Object)other.getCode())) {
            return false;
        }
        if (!this.version.check("=", other.getVersion())) {
            return false;
        }
        if (!this.getOperatingSystem().equalsIgnoreCase(other.getOperatingSystem())) {
            return false;
        }
        if (!this.gvSIGVersion.equalsIgnoreCase(other.getGvSIGVersion())) {
            return false;
        }
        if (!this.state.equalsIgnoreCase(other.getState())) {
            return false;
        }
        if (!this.architecture.equalsIgnoreCase(other.getArchitecture())) {
            return false;
        }
        if (!this.javaVM.equalsIgnoreCase(other.getJavaVM())) {
            return false;
        }
        if (!this.type.equalsIgnoreCase(other.getType())) {
            return false;
        }
        return this.official == other.isOfficial();
    }

    public URL getWebURL() {
        return this.webURL;
    }

    public void setWebURL(URL webURL) {
        this.webURL = webURL;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List categoriesList) {
        for (int i = 0; i < categoriesList.size(); ++i) {
            if (this.categories.contains(categoriesList.get(i))) continue;
            this.categories.add((String)categoriesList.get(i));
        }
    }

    public String getCategoriesAsString() {
        String categoriesString = "";
        for (int i = 0; i < this.categories.size(); ++i) {
            categoriesString = i + 1 < this.categories.size() ? categoriesString + this.categories.get(i) + ", " : categoriesString + this.categories.get(i);
        }
        return categoriesString;
    }

    public void addCategoriesAsString(String categoriesString) {
        if (categoriesString == null) {
            return;
        }
        categoriesString.trim();
        String[] cadena = categoriesString.split(",");
        for (int i = 0; i < cadena.length; ++i) {
            String trimCadena = cadena[i].trim();
            if (this.categories.contains(trimCadena) || trimCadena == "") continue;
            this.categories.add(trimCadena);
        }
    }

    public void checkSignature(byte[] pkgdata) {
        this.signed = false;
        SignUtil signutil = null;
        List keys = InstallerLocator.getInstallerManager().getPublicKeys();
        if (keys.size() < 1) {
            this.signed = false;
            return;
        }
        for (byte[] rawkey : keys) {
            signutil = new SignUtil(rawkey);
            if (!signutil.canVerify()) continue;
            int status = signutil.verify(pkgdata);
            switch (status) {
                case 0: {
                    this.signed = true;
                    return;
                }
                case 2: {
                    this.signed = false;
                    return;
                }
            }
        }
        this.broken = true;
    }

    public boolean isBroken() {
        return this.broken != false;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public Version getApplicationVersion() {
        return null;
    }

    public void setApplicationVersion(Version version) {
    }

    public void setValue(String name, Object value) {
    }

    public Object getValue(String name) {
        return null;
    }

    public String getPreferedPackageFileName() {
        return null;
    }

    public class FileDownloadException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 8640183295766490512L;
        private static final String message = "File '%(url)s' download error";
        private static final String KEY = "_File_XurlX_download_error";

        public FileDownloadException(URL url, Exception e) {
            super(message, (Throwable)e, KEY, 8640183295766490512L);
            this.setValue("url", url.toString());
        }
    }
}

