/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.struct;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSStatusImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSDimension;
import org.gvsig.raster.wmts.ogc.struct.WMTSResourceURL;
import org.gvsig.raster.wmts.ogc.struct.WMTSTile;

public class TemplateSupport {
    private List<WMTSDimension> dimensions = null;
    private List<WMTSResourceURL> resourcesURL = null;

    public TemplateSupport(List<WMTSDimension> dimensions, List<WMTSResourceURL> resourcesURL) {
        this.dimensions = dimensions;
        this.resourcesURL = resourcesURL;
    }

    public List<WMTSDimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<WMTSDimension>();
        }
        return this.dimensions;
    }

    public List<WMTSResourceURL> getResourceURL() {
        if (this.resourcesURL == null) {
            this.resourcesURL = new ArrayList<WMTSResourceURL>();
        }
        return this.resourcesURL;
    }

    public void buildResourceURLListFromTemplate(WMTSStatus status) {
        if (StringUtils.isBlank((CharSequence)status.getStyle())) {
            return;
        }
        String template = this.getTemplate(status.getFormat(), status.getStyle());
        String dimensionValueToWrite = status.getValueForDimension();
        if (template == null) {
            return;
        }
        if (dimensionValueToWrite == null) {
            dimensionValueToWrite = this.getDimensionValueToWriteInTemplate(template);
        }
        this.replacePatternsInTemplate(template, status, dimensionValueToWrite);
    }

    private String getDimensionValueToWriteInTemplate(String template) {
        for (int iDimension = 0; iDimension < this.getDimensions().size(); ++iDimension) {
            WMTSDimension dim = this.getDimensions().get(iDimension);
            String idDim = dim.getIdentifier();
            if (!template.toLowerCase().contains("{" + idDim.toLowerCase() + "}")) continue;
            return dim.getDefaultValue();
        }
        return null;
    }

    private void replacePatternsInTemplate(String template, WMTSStatus status, String dimensionValue) {
        String idDimensionToBeReplaced = this.getDimensionIDToReplace(template);
        template = template.replaceAll("(?i)\\{" + idDimensionToBeReplaced + "\\}", dimensionValue);
        template = template.replace("{TileMatrixSet}", status.getTileMatrixSet());
        template = template.replace("{TileMatrix}", status.getTileMatrix());
        template = template.replace("{style}", status.getStyle());
        for (int i = 0; i < status.getTileList().size(); ++i) {
            WMTSTile tile = (WMTSTile)status.getTileList().get(i);
            String url = new String(template);
            url = url.replace("{TileRow}", tile.getRow() + "");
            url = url.replace("{TileCol}", tile.getCol() + "");
            ((WMTSStatusImpl)status).addResourceURL(tile.getRow() + "" + tile.getCol() + "", url);
        }
    }

    private String getDimensionIDToReplace(String template) {
        for (int iDimension = 0; iDimension < this.getDimensions().size(); ++iDimension) {
            WMTSDimension dim = this.getDimensions().get(iDimension);
            String idDim = dim.getIdentifier();
            if (!template.toLowerCase().contains("{" + idDim.toLowerCase() + "}")) continue;
            return idDim;
        }
        return null;
    }

    private String getTemplate(String format, String style) {
        if (StringUtils.isBlank((CharSequence)style)) {
            return null;
        }
        for (int iResourceURL = 0; iResourceURL < this.getResourceURL().size(); ++iResourceURL) {
            String template;
            String currentFormat = this.getResourceURL().get(iResourceURL).getFormat();
            if (currentFormat == null || !currentFormat.equals(format) || !this.isStyleSupported(template = this.getResourceURL().get(iResourceURL).getTemplate(), style)) continue;
            return template;
        }
        return null;
    }

    private boolean isStyleSupported(String template, String style) {
        if (StringUtils.contains((CharSequence)template, (CharSequence)"{style}")) {
            return true;
        }
        Pattern p = Pattern.compile("/" + style + "/", 2);
        Matcher m = p.matcher(template);
        return m.find();
    }
}

