/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.struct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSBaseStruct;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSLayerImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSTheme;

public abstract class WMTSThemeImpl
extends WMTSBaseStruct
implements WMTSTheme {
    private List<WMTSTheme> theme = null;
    private List<String> layerRef = null;
    private WMTSLayerImpl layer = null;

    public void setLayer(WMTSLayerImpl layer) {
        this.layer = layer;
    }

    public WMTSLayer getLayer() {
        return this.layer;
    }

    public List<WMTSTheme> getThemeList() {
        if (this.theme == null) {
            this.theme = new ArrayList<WMTSTheme>();
        }
        return this.theme;
    }

    public List<String> getLayerRef() {
        if (this.layerRef == null) {
            this.layerRef = new ArrayList<String>();
        }
        return this.layerRef;
    }

    public void calculateLayers(List<WMTSLayer> layers) {
        int i;
        if (this.theme != null && this.theme.size() > 0) {
            for (i = 0; i < this.theme.size(); ++i) {
                ((WMTSThemeImpl)this.theme.get(i)).calculateLayers(layers);
            }
        }
        if (this.layerRef != null && this.layerRef.size() > 0) {
            for (i = 0; i < layers.size(); ++i) {
                WMTSLayerImpl tmpLayer = (WMTSLayerImpl)layers.get(i);
                for (int j = 0; j < this.layerRef.size(); ++j) {
                    String layerRef_I = this.layerRef.get(j);
                    if (tmpLayer.getTitle().compareTo(layerRef_I) != 0) continue;
                    this.layer = tmpLayer;
                }
            }
        }
    }

    public WMTSTheme getNodeByName(String name) {
        WMTSThemeImpl result = null;
        if (this.theme == null) {
            return null;
        }
        for (int i = 0; i < this.theme.size(); ++i) {
            WMTSThemeImpl t = (WMTSThemeImpl)this.theme.get(i);
            String title = t.getTitle();
            result = title.compareTo(name) == 0 ? t : t.getNodeByName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getChildCount() {
        if (this.theme == null || this.theme.size() == 0) {
            return 0;
        }
        int acum = 0;
        for (int i = 0; i < this.theme.size(); ++i) {
            acum += 1 + ((WMTSThemeImpl)this.theme.get(i)).getChildCount();
        }
        return acum;
    }

    public WMTSTheme getChildren(int index) {
        if (this.theme != null) {
            return this.theme.get(index);
        }
        return null;
    }

    public int getIndexOfChild(WMTSTheme child) {
        if (this.theme != null) {
            for (int i = 0; i < this.theme.size(); ++i) {
                if (child != this.getChildren(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        return this.getTitle();
    }

    public void sort() {
        if (CollectionUtils.isEmpty(this.theme)) {
            return;
        }
        Collections.sort(this.theme, new Comparator<WMTSTheme>(){

            @Override
            public int compare(WMTSTheme o1, WMTSTheme o2) {
                return StringUtils.compare((String)o1.getTitle(), (String)o2.getTitle(), (boolean)true);
            }
        });
    }
}

