/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.struct;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import org.gvsig.raster.wmts.ogc.struct.WMTSTile;

public class WMTSTileImpl
implements WMTSTile {
    public int wPx;
    public int hPx;
    public int row;
    public int col;
    public double ulx;
    public double uly;
    public double lrx;
    public double lry;
    public File file;

    public WMTSTileImpl(int[] size, int[] position, double[] coords) {
        this.row = position[0];
        this.col = position[1];
        this.ulx = coords[0];
        this.uly = coords[1];
        this.lrx = coords[2];
        this.lry = coords[3];
        this.wPx = size[0];
        this.hPx = size[1];
    }

    public WMTSTileImpl(int wPx, int hPx, int row, int col, double ulx, double uly, double lrx, double lry) {
        this.row = row;
        this.col = col;
        this.ulx = ulx;
        this.uly = uly;
        this.lrx = lrx;
        this.lry = lry;
        this.wPx = wPx;
        this.hPx = hPx;
    }

    public double getULX() {
        return this.ulx;
    }

    public double getULY() {
        return this.uly;
    }

    public double getLRX() {
        return this.lrx;
    }

    public double getLRY() {
        return this.lry;
    }

    public int getWidthPx() {
        return this.wPx;
    }

    public int getHeightPx() {
        return this.hPx;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        double psX = (this.lrx - this.ulx) / (double)this.wPx;
        double psY = (this.lry - this.uly) / (double)this.hPx;
        AffineTransform t = new AffineTransform(psX, 0.0, 0.0, psY, this.ulx - psX / 2.0, this.uly + psY / 2.0);
        try {
            t.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public WMTSTile cloneTile() {
        WMTSTileImpl status = new WMTSTileImpl(this.wPx, this.hPx, this.row, this.col, this.ulx, this.uly, this.lrx, this.lry);
        status.file = this.file;
        return status;
    }
}

