/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.wmts_1_0_0;

import java.io.File;
import java.io.IOException;
import org.gvsig.raster.wmts.ogc.impl.EncodingXMLParser;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSProtocolHandler;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSServerDescription;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSStatusImpl;
import org.gvsig.raster.wmts.ogc.impl.request.WMTSGetCapabilitiesRequest;
import org.gvsig.raster.wmts.ogc.impl.request.WMTSGetFeatureInfoRequest;
import org.gvsig.raster.wmts.ogc.impl.request.WMTSGetTileRequest;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSLayerImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSTileMatrixSetImpl;
import org.gvsig.raster.wmts.ogc.impl.wmts_1_0_0.request.WMTSGetCapabilitiesRequest1_0_0;
import org.gvsig.raster.wmts.ogc.impl.wmts_1_0_0.request.WMTSGetFeatureInfoRequest1_0_0;
import org.gvsig.raster.wmts.ogc.impl.wmts_1_0_0.request.WMTSGetTileRequest1_0_0;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WMTSProtocolHandler1_0_0
extends WMTSProtocolHandler {
    private String gmlTag = "ows:";

    public WMTSProtocolHandler1_0_0() {
        this.version = "1.0.0";
        this.name = "WMS1.0.0";
    }

    @Override
    public boolean parseCapabilities(File f) {
        EncodingXMLParser parser = null;
        parser = new EncodingXMLParser();
        if (this.getServerDescription() != null) {
            this.getServerDescription().clear();
        }
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "Capabilities");
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (this.compareName(parser, "ServiceIdentification")) {
                                this.getServerDescription().getServiceIdentification().parse(parser);
                                break;
                            }
                            if (this.compareName(parser, "ServiceProvider")) {
                                this.getServerDescription().getServiceProvider().parse(parser);
                                break;
                            }
                            if (this.compareName(parser, "OperationsMetadata")) {
                                this.getServerDescription().getOperationsMetadata().parse(parser);
                                break;
                            }
                            if (this.compareName(parser, "Contents")) {
                                this.parseServiceContent(parser, this.getServerDescription());
                                break;
                            }
                            if (!this.compareName(parser, "Themes")) break;
                            this.getServerDescription().getThemes().parse(parser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException parser_ex) {
            parser_ex.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        this.getServerDescription().getThemes().calculateLayers(this.getServerDescription().getLayerList());
        this.getServerDescription().getLayerListAsThemes().loadThemesWithLayerInfo(this.getServerDescription().getLayerList(), this.getServerDescription());
        for (int i = 0; i < this.getServerDescription().getLayerList().size(); ++i) {
            WMTSLayerImpl layer = (WMTSLayerImpl)this.getServerDescription().getLayerList().get(i);
            layer.linkTileMatrixSets(this.getServerDescription().getTileMatrixSet());
        }
        return true;
    }

    private void parseServiceContent(KXmlParser parser, WMTSServerDescription content) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (this.compareName(parser, "Layer")) {
                        WMTSLayerImpl layer = content.buildNewLayer();
                        layer.setForceChangeAxisOrder(this.forceChangeAxisOrder);
                        layer.parse(parser);
                        break;
                    }
                    if (this.compareName(parser, "OtherSource")) {
                        this.parseOtherSource(parser);
                        break;
                    }
                    if (!this.compareName(parser, "TileMatrixSet")) break;
                    WMTSTileMatrixSetImpl mSet = (WMTSTileMatrixSetImpl)content.createVersionObject("WMTSTileMatrixSet");
                    mSet.setForceChangeAxisOrder(this.forceChangeAxisOrder);
                    mSet.parse(parser, content.getTileMatrixSet());
                    break;
                }
                case 3: {
                    if (!this.compareName(parser, "Contents")) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseOtherSource(KXmlParser parser) throws IOException, XmlPullParserException {
        parser.skipSubTree();
    }

    private boolean compareName(KXmlParser parser, String name) {
        String s = parser.getName();
        return s.compareTo(name) == 0 || s.compareTo(this.gmlTag + name) == 0;
    }

    @Override
    public WMTSGetCapabilitiesRequest createGetCapabilitiesRequest() {
        return new WMTSGetCapabilitiesRequest1_0_0(this.getServerDescription(), (WMTSProtocolHandler)this);
    }

    @Override
    public WMTSGetTileRequest createGetTileRequest(WMTSStatusImpl status) {
        return new WMTSGetTileRequest1_0_0(status, this);
    }

    @Override
    public WMTSGetFeatureInfoRequest createGetFeatureInfoRequest(WMTSStatusImpl status, int x, int y) {
        return new WMTSGetFeatureInfoRequest1_0_0(status, this, x, y);
    }
}

