/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend;

import java.awt.Color;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageData;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.DefaultUrbanHorizontalSignageData;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrbanHorizontalSignageConfig
implements UrbanHorizontalSignageConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUrbanHorizontalSignageConfig.class);
    private String widthFieldName;
    private String continuityFieldName;
    private String holesLengthFieldName;
    private String holesColorFieldName;
    private String paintHolesFieldName;
    private String segmentsLengthFieldName;
    private String segmentsColorFieldName;
    private String roundVertexFieldName;
    private int gapWidth = 15;
    private String targetColorFieldName;
    private String targetLenghtFieldName;
    private String targetAreaFieldName;

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.widthFieldName = state.getString("widthFieldName");
        this.continuityFieldName = state.getString("continuityFieldName");
        this.holesLengthFieldName = state.getString("holesLengthFieldName");
        this.holesColorFieldName = state.getString("holesColorFieldName");
        this.paintHolesFieldName = state.getString("paintHolesFieldName");
        this.segmentsLengthFieldName = state.getString("segmentsLengthFieldName");
        this.segmentsColorFieldName = state.getString("segmentsColorFieldName");
        this.roundVertexFieldName = state.getString("roundVertexFieldName");
        this.gapWidth = state.getInt("gapWidth", 15);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("widthFieldName", this.widthFieldName);
        state.set("continuityFieldName", this.continuityFieldName);
        state.set("holesLengthFieldName", this.holesLengthFieldName);
        state.set("holesColorFieldName", this.holesColorFieldName);
        state.set("paintHolesFieldName", this.paintHolesFieldName);
        state.set("segmentsLengthFieldName", this.segmentsLengthFieldName);
        state.set("segmentsColorFieldName", this.segmentsColorFieldName);
        state.set("roundVertexFieldName", this.roundVertexFieldName);
        state.set("gapWidth", this.gapWidth);
    }

    public String getWidthFieldName() {
        return this.widthFieldName;
    }

    public void setWidthFieldName(String fieldName) {
        this.widthFieldName = fieldName;
    }

    public String getContinuityFieldName() {
        return this.continuityFieldName;
    }

    public void setContinuityFieldName(String fieldName) {
        this.continuityFieldName = fieldName;
    }

    public String getSegmentsColorFieldName() {
        return this.segmentsColorFieldName;
    }

    public void setSegmentsColorFieldName(String fieldName) {
        this.segmentsColorFieldName = fieldName;
    }

    public String getSegmentsLengthFieldName() {
        return this.segmentsLengthFieldName;
    }

    public void setSegmentsLengthFieldName(String fieldName) {
        this.segmentsLengthFieldName = fieldName;
    }

    public String getPaintHolesFieldName() {
        return this.paintHolesFieldName;
    }

    public void setPaintHolesFieldName(String fieldName) {
        this.paintHolesFieldName = fieldName;
    }

    public String getHolesColorFieldName() {
        return this.holesColorFieldName;
    }

    public void setHolesColorFieldName(String fieldName) {
        this.holesColorFieldName = fieldName;
    }

    public String getHolesLengthFieldName() {
        return this.holesLengthFieldName;
    }

    public void setHolesLengthFieldName(String fieldName) {
        this.holesLengthFieldName = fieldName;
    }

    public String getRoundVertexFieldName() {
        return this.roundVertexFieldName;
    }

    public void setRoundVertexFieldName(String fieldName) {
        this.roundVertexFieldName = fieldName;
    }

    public int getGapWidth() {
        return this.gapWidth;
    }

    public void setGapWith(int value) {
        this.gapWidth = value;
    }

    public UrbanHorizontalSignageData getValues(Feature feature) {
        DefaultUrbanHorizontalSignageData data = new DefaultUrbanHorizontalSignageData();
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        FeatureType ftype = feature.getType();
        double valueDouble = (double)feature.getIntOrDefault(this.widthFieldName, 0) / 100.0;
        data.setWidth(valueDouble);
        int valueInt = feature.getIntOrDefault(this.continuityFieldName, 1);
        data.setContinuity(valueInt);
        Color valueColor = (Color)feature.getOrDefault(this.segmentsColorFieldName, 96, (Object)UrbanHorizontalSignageData.DEFAULT_SEGMENT_COLOR_VALUE);
        data.setSegmentsColor(valueColor);
        valueDouble = (double)feature.getIntOrDefault(this.segmentsLengthFieldName, 0) / 100.0;
        data.setSegmentsLength(valueDouble);
        valueDouble = (double)feature.getIntOrDefault(this.holesLengthFieldName, 0) / 100.0;
        data.setHolesLength(valueDouble);
        boolean valueBoolean = feature.getBooleanOrDefault(this.paintHolesFieldName, false);
        data.setPaintHoles(valueBoolean);
        valueColor = (Color)feature.getOrDefault(this.holesColorFieldName, 96, (Object)UrbanHorizontalSignageData.DEFAULT_HOLES_COLOR_VALUE);
        data.setHolesColor(valueColor);
        valueBoolean = feature.getBooleanOrDefault(this.roundVertexFieldName, false);
        data.setRoundVertex(valueBoolean);
        data.setGapWidth((double)this.getGapWidth() / 100.0);
        return data;
    }

    public String getTargetColorFieldName() {
        return this.targetColorFieldName;
    }

    public void setTargetColorFieldName(String fieldName) {
        this.targetColorFieldName = fieldName;
    }

    public String getTargetLenghtFieldName() {
        return this.targetLenghtFieldName;
    }

    public void setTargetLenghtFieldName(String fieldName) {
        this.targetLenghtFieldName = fieldName;
    }

    public String getTargetAreaFieldName() {
        return this.targetAreaFieldName;
    }

    public void setTargetAreaFieldName(String fieldName) {
        this.targetAreaFieldName = fieldName;
    }

    public UrbanHorizontalSignageConfig clone() throws CloneNotSupportedException {
        return (UrbanHorizontalSignageConfig)super.clone();
    }
}

