/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.geosocial.twitter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.geosocial.twitter.Geocoding;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.List;
import winterwell.jtwitter.Twitter;

public class SearchTwitterAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String SEARCH_STRING = "SEARCH_STRING";
    public static final String INIT_DATE = "INIT_DATE";
    public static final String END_DATE = "END_DATE";
    public static final String POINT = "POINT";
    public static final String SEARCH_RADIUS = "SEARCH_RADIUS";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Search_twitter"));
        this.setGroup(Sextante.getText((String)"Geosocial"));
        try {
            this.m_Parameters.addString(SEARCH_STRING, Sextante.getText((String)"Search_string"));
            this.m_Parameters.addString(INIT_DATE, Sextante.getText((String)"init_date"));
            this.m_Parameters.addString(END_DATE, Sextante.getText((String)"end_date"));
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"Search_coordinate"));
            this.m_Parameters.addNumericalValue(SEARCH_RADIUS, Sextante.getText((String)"Search_radius_km"), 2, 50.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String sSearch = this.m_Parameters.getParameterValueAsString(SEARCH_STRING);
        String sInitDate = this.m_Parameters.getParameterValueAsString(INIT_DATE);
        String sEndDate = this.m_Parameters.getParameterValueAsString(END_DATE);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(POINT);
        double dRadius = this.m_Parameters.getParameterValueAsDouble(SEARCH_RADIUS);
        Class[] types = new Class[]{String.class, String.class};
        String[] sFields = new String[]{"user", "message"};
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Resultado"), 0, types, sFields);
        Twitter twitter = new Twitter();
        twitter.setMaxResults(300);
        twitter.setSearchLocation(pt.getX(), pt.getY(), Double.toString(dRadius) + "km");
        try {
            Date initDate = new Date(sInitDate);
            twitter.setSinceDate(initDate);
        }
        catch (Exception initDate) {
            // empty catch block
        }
        try {
            Date endDate = new Date(sEndDate);
            twitter.setUntilDate(endDate);
        }
        catch (Exception endDate) {
            // empty catch block
        }
        this.setProgressText(Sextante.getText((String)"retrieving_tweets"));
        List<Twitter.Status> stati = new Twitter().search(sSearch, null, 90);
        this.setProgressText(Sextante.getText((String)"processing_tweets"));
        GeometryFactory gm = new GeometryFactory();
        for (int i = 0; i < stati.size() && this.setProgress(i, stati.size()); ++i) {
            try {
                Twitter.Status status = stati.get(i);
                String sPosition = status.getGeo();
                if (sPosition == null) {
                    Twitter.User user = twitter.show(status.getUser().getScreenName());
                    sPosition = Geocoding.getCoordinates(user.getLocation());
                }
                String sLatitude = sPosition.substring(0, sPosition.indexOf(","));
                String sLongitude = sPosition.substring(sPosition.indexOf(",") + 1);
                double dLatitude = Double.parseDouble(sLatitude);
                double dLongitude = Double.parseDouble(sLongitude);
                Point point = gm.createPoint(new Coordinate(dLongitude, dLatitude));
                Object[] record = new Object[]{status.getUser().getScreenName(), status.getText()};
                output.addFeature((Geometry)point, record);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !this.m_Task.isCanceled();
    }
}

