/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.accCostCombined;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;

public class AccCostCombinedAlgorithm
extends GeoAlgorithm {
    public static final String ISOCOST = "ISOCOST";
    public static final String ANISOCOST = "ANISOCOST";
    public static final String COSTDIR = "COSTDIR";
    public static final String KFACTOR = "KFACTOR";
    public static final String FEATURES = "FEATURES";
    public static final String ACCCOST = "ACCCOST";
    public static final String CLOSESTPOINT = "CLOSESTPOINT";
    private static final int NO_DATA = -1;
    private static final double[][] ANGLES = new double[][]{{315.0, 0.0, 45.0}, {270.0, 0.0, 90.0}, {225.0, 180.0, 135.0}};
    int m_iNX;
    int m_iNY;
    double m_dK;
    IRasterLayer m_IsotropicCost;
    IRasterLayer m_AnisotropicCost;
    IRasterLayer m_CostDir;
    IRasterLayer m_Features;
    IRasterLayer m_AccCost;
    IRasterLayer m_ClosestPoint;
    ArrayList m_CentralPoints;
    ArrayList m_AdjPoints;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Accumulated_cost__combined"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(ISOCOST, Sextante.getText((String)"Isotropic_cost"), true);
            this.m_Parameters.addInputRasterLayer(ANISOCOST, Sextante.getText((String)"Anisotropic_cost"), true);
            this.m_Parameters.addInputRasterLayer(COSTDIR, Sextante.getText((String)"Direction_of_maximum_cost_[degrees]"), true);
            this.m_Parameters.addInputRasterLayer(FEATURES, Sextante.getText((String)"Origin-destination_points"), true);
            this.m_Parameters.addNumericalValue(KFACTOR, Sextante.getText((String)"K"), 2.0, 2);
            this.addOutputRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"));
            this.addOutputRasterLayer(CLOSESTPOINT, Sextante.getText((String)"Closest_points"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iPoint = 1;
        this.m_CentralPoints = new ArrayList();
        this.m_AdjPoints = new ArrayList();
        this.m_IsotropicCost = this.m_Parameters.getParameterValueAsRasterLayer(ISOCOST);
        this.m_AnisotropicCost = this.m_Parameters.getParameterValueAsRasterLayer(ANISOCOST);
        this.m_CostDir = this.m_Parameters.getParameterValueAsRasterLayer(COSTDIR);
        this.m_Features = this.m_Parameters.getParameterValueAsRasterLayer(FEATURES);
        this.m_dK = this.m_Parameters.getParameterValueAsDouble(KFACTOR);
        this.m_AccCost = this.getNewRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"), 5);
        this.m_ClosestPoint = this.getNewRasterLayer(CLOSESTPOINT, Sextante.getText((String)"Closest_points"), 3);
        AnalysisExtent extent = this.m_AccCost.getWindowGridExtent();
        this.m_IsotropicCost.setWindowExtent(extent);
        this.m_IsotropicCost.setInterpolationMethod(4);
        this.m_AnisotropicCost.setWindowExtent(extent);
        this.m_AnisotropicCost.setInterpolationMethod(4);
        this.m_CostDir.setWindowExtent(extent);
        this.m_CostDir.setInterpolationMethod(4);
        this.m_Features.setWindowExtent(extent);
        this.m_Features.setInterpolationMethod(0);
        this.m_iNX = this.m_IsotropicCost.getNX();
        this.m_iNY = this.m_IsotropicCost.getNY();
        this.m_AccCost.setNoDataValue(-1.0);
        this.m_AccCost.assignNoData();
        this.m_ClosestPoint.setNoDataValue(-1.0);
        this.m_ClosestPoint.assignNoData();
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Features.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || this.m_Features.isNoDataValue(dValue)) continue;
                this.m_CentralPoints.add(new GridCell(x, y, (double)iPoint));
                this.m_AccCost.setCellValue(x, y, 0.0);
                this.m_ClosestPoint.setCellValue(x, y, (double)iPoint);
                ++iPoint;
            }
        }
        this.calculateCost();
        return !this.m_Task.isCanceled();
    }

    private void calculateCost() {
        while (this.m_CentralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                int iPoint = (int)cell.getValue();
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int x2 = x + i;
                        int y2 = y + j;
                        double dCostInDir = this.getCostInDir(x, y, i, j);
                        if (dCostInDir == -1.0) continue;
                        double dAccCost = this.m_AccCost.getCellValueAsDouble(x, y);
                        dAccCost += dCostInDir * Math.sqrt(i * i + j * j);
                        double dPrevAccCost = this.m_AccCost.getCellValueAsDouble(x2, y2);
                        if (!this.m_AccCost.isNoDataValue(dPrevAccCost) && !(dPrevAccCost > dAccCost)) continue;
                        this.m_AccCost.setCellValue(x2, y2, dAccCost);
                        this.m_ClosestPoint.setCellValue(x2, y2, (double)iPoint);
                        this.m_AdjPoints.add(new GridCell(x2, y2, (double)iPoint));
                    }
                }
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }

    private double getCostInDir(int x, int y, int iH, int iV) {
        double dAngle = ANGLES[iV + 1][iH + 1];
        int x2 = x + iH;
        int y2 = y + iV;
        double dCostDir1 = this.m_CostDir.getCellValueAsDouble(x, y);
        double dCostDir2 = this.m_CostDir.getCellValueAsDouble(x2, y2);
        double dCost1 = this.m_AnisotropicCost.getCellValueAsDouble(x, y);
        double dCost2 = this.m_AnisotropicCost.getCellValueAsDouble(x2, y2);
        double dIsoCost1 = this.m_IsotropicCost.getCellValueAsDouble(x, y);
        double dIsoCost2 = this.m_IsotropicCost.getCellValueAsDouble(x2, y2);
        if (this.m_AnisotropicCost.isNoDataValue(dCost1) || this.m_AnisotropicCost.isNoDataValue(dCost1) || this.m_IsotropicCost.isNoDataValue(dIsoCost1) || this.m_IsotropicCost.isNoDataValue(dIsoCost2) || this.m_CostDir.isNoDataValue(dCostDir1) || this.m_CostDir.isNoDataValue(dCostDir1)) {
            return -1.0;
        }
        double dDifAngle1 = Math.abs(dCostDir1 - dAngle);
        double dDifAngle2 = Math.abs(dCostDir2 - dAngle);
        dDifAngle1 = Math.toRadians(dDifAngle1);
        dDifAngle2 = Math.toRadians(dDifAngle1);
        dCost1 = Math.pow(Math.cos(dDifAngle1), this.m_dK) / 2.0 * dCost1 + dIsoCost1;
        dCost2 = Math.pow(Math.cos(dDifAngle2), this.m_dK) / 2.0 * dCost2 + dIsoCost2;
        return dCost1 + dCost2;
    }
}

