/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.ahp;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class AHPAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String PAIRWISE = "PAIRWISE";
    public static final String RESULT = "RESULT";
    public static final String STATS = "STATS";
    private static final double[] RI = new double[]{0.0, 0.0, 0.58, 0.9, 1.12, 1.24, 1.32, 1.41, 1.45, 1.49, 1.51, 1.48, 1.56, 1.57, 1.59};
    private String[] m_sNames;
    private double[] m_dWeights;
    private ITable m_Pairwise;
    private double[][] m_dPairwise;
    private ArrayList layers;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Analytical_Hierarchy_Process__AHP"));
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Layers"), 1, true);
            this.m_Parameters.addInputTable(PAIRWISE, Sextante.getText((String)"Pairwise_comparisons"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
            this.addOutputText(STATS, Sextante.getText((String)"Statistics"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        this.layers = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_Pairwise = this.m_Parameters.getParameterValueAsTable(PAIRWISE);
        if (this.layers.size() == 0 || this.layers.size() > RI.length) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_wrong_number_of_layers"));
        }
        this.getWeights();
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Analytical_Hierarchy_Process"), 5);
        IRasterLayer[] windows = new IRasterLayer[this.layers.size()];
        for (i = 0; i < this.layers.size(); ++i) {
            windows[i] = (IRasterLayer)this.layers.get(i);
            windows[i].setWindowExtent(result.getWindowGridExtent());
            windows[i].setInterpolationMethod(4);
        }
        int iNX = result.getWindowGridExtent().getNX();
        int iNY = result.getWindowGridExtent().getNY();
        double[] dValues = new double[this.layers.size()];
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                boolean bNoDataValue = false;
                for (i = 0; i < dValues.length; ++i) {
                    dValues[i] = windows[i].getCellValueAsDouble(x, y);
                    if (!windows[i].isNoDataValue(dValues[i])) continue;
                    bNoDataValue = true;
                    break;
                }
                if (bNoDataValue) {
                    result.setNoData(x, y);
                    continue;
                }
                double dResult = 0.0;
                for (i = 0; i < dValues.length; ++i) {
                    dResult += dValues[i] * this.m_dWeights[i];
                }
                result.setCellValue(x, y, dResult);
            }
        }
        this.showInfo();
        return !this.m_Task.isCanceled();
    }

    private void getWeights() throws GeoAlgorithmExecutionException {
        int iRow;
        int iCol;
        int j;
        int i;
        int[] iField = new int[this.layers.size()];
        this.m_dPairwise = new double[this.layers.size()][this.layers.size()];
        this.m_sNames = new String[this.layers.size()];
        for (i = 0; i < this.layers.size(); ++i) {
            String sName;
            IRasterLayer layer = (IRasterLayer)this.layers.get(i);
            this.m_sNames[i] = sName = layer.getName();
            boolean bMatchFound = false;
            for (j = 0; j < this.m_Pairwise.getFieldCount(); ++j) {
                String sFieldName = this.m_Pairwise.getFieldName(j);
                if (!sName.equals(sFieldName)) continue;
                bMatchFound = true;
                iField[i] = j;
                break;
            }
            if (bMatchFound) continue;
            throw new GeoAlgorithmExecutionException("AHP Could not Assign weights");
        }
        i = 0;
        IRecordsetIterator iter = this.m_Pairwise.iterator();
        while (iter.hasNext()) {
            Object[] record = iter.next().getValues();
            for (j = 0; j < iField.length; ++j) {
                this.m_dPairwise[i][j] = new Double(record[iField[i]].toString());
            }
            ++i;
        }
        iter.close();
        double[] dSum = new double[this.m_dPairwise.length];
        for (iCol = 0; iCol < this.m_dPairwise.length; ++iCol) {
            for (iRow = 0; iRow < this.m_dPairwise.length; ++iRow) {
                int n = iCol;
                dSum[n] = dSum[n] + this.m_dPairwise[iRow][iCol];
            }
        }
        for (iCol = 0; iCol < this.m_dPairwise.length; ++iCol) {
            for (iRow = 0; iRow < this.m_dPairwise.length; ++iRow) {
                double[] dArray = this.m_dPairwise[iRow];
                int n = iCol;
                dArray[n] = dArray[n] / dSum[iCol];
            }
        }
        this.m_dWeights = new double[this.m_dPairwise.length];
        iRow = 0;
        while (iRow < this.m_dPairwise.length) {
            for (iCol = 0; iCol < this.m_dPairwise.length; ++iCol) {
                int n = iRow;
                this.m_dWeights[n] = this.m_dWeights[n] + this.m_dPairwise[iRow][iCol];
            }
            int n = iRow++;
            this.m_dWeights[n] = this.m_dWeights[n] / (double)this.m_dPairwise.length;
        }
    }

    private void showInfo() {
        int i;
        HTMLDoc doc = new HTMLDoc();
        doc.open("AHP");
        doc.addHeader("AHP", 2);
        doc.addHeader(Sextante.getText((String)"Analytical_Hierarchy_Process_Weights"), 3);
        doc.startUnorderedList();
        for (i = 0; i < this.m_dWeights.length; ++i) {
            doc.addListElement(this.m_sNames[i] + ": " + Double.toString(this.m_dWeights[i]));
        }
        doc.closeUnorderedList();
        double dRelSum = 0.0;
        for (i = 0; i < this.m_dPairwise.length; ++i) {
            double dSum = 0.0;
            for (int j = 0; j < this.m_dPairwise.length; ++j) {
                dSum += this.m_dWeights[j] * this.m_dPairwise[i][j];
            }
            dRelSum += dSum / this.m_dWeights[i];
        }
        double dLambda = dRelSum / (double)this.m_dWeights.length;
        double dConsistency = (dLambda - (double)this.m_dWeights.length) / (double)(this.m_dWeights.length - 1);
        double dCR = dConsistency / RI[this.m_dWeights.length];
        if (dCR < 0.1) {
            doc.addBoldText(Sextante.getText((String)"Warning_Inconsistent_weighting_values"));
            Sextante.addWarningToLog((String)("AHP:" + Sextante.getText((String)"Warning_Inconsistent_weighting_values")));
        }
        doc.close();
        this.addOutputText(STATS, "AHP", doc.getHTMLCode());
    }
}

