/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.cluster;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.util.ArrayList;
import java.util.Arrays;

public class ClusterAlgorithm
extends GeoAlgorithm {
    public static final String RESULTLAYER = "RESULTLAYER";
    public static final String RESULTTABLE = "RESULTTABLE";
    public static final String INPUT = "INPUT";
    public static final String NUMCLASS = "NUMCLASS";
    private int m_iNX;
    private int m_iNY;
    private int m_iClasses;
    private int[] m_iCells;
    private int m_iThreshold;
    private double[][] m_dMean;
    private ArrayList m_Bands;
    private int[] m_iBands;
    private IRasterLayer[] m_Windows;
    private IRasterLayer m_Result;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setIsDeterminatedProcess(false);
        this.setName(Sextante.getText((String)"Unsupervised_classification__clustering"));
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Bands"), 7, true);
            this.m_Parameters.addNumericalValue(NUMCLASS, Sextante.getText((String)"Number_of_classes"), 1, 3.0, 2.0, 2.147483647E9);
            this.addOutputRasterLayer(RESULTLAYER, Sextante.getText((String)"Clusters"));
            this.addOutputTable(RESULTTABLE, Sextante.getText((String)"Statistics"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Bands = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_iClasses = this.m_Parameters.getParameterValueAsInt(NUMCLASS);
        if (this.m_Bands.size() == 0 || this.m_iClasses < 2) {
            return false;
        }
        this.m_Result = this.getNewRasterLayer(RESULTLAYER, Sextante.getText((String)"Clusters"), 3);
        this.m_Windows = new IRasterLayer[this.m_Bands.size()];
        this.m_iBands = new int[this.m_Bands.size()];
        for (int i = 0; i < this.m_Bands.size(); ++i) {
            RasterLayerAndBand band = (RasterLayerAndBand)this.m_Bands.get(i);
            this.m_iBands[i] = band.getBand();
            this.m_Windows[i] = band.getRasterLayer();
            this.m_Windows[i].setWindowExtent(this.m_Result.getWindowGridExtent());
            this.m_Windows[i].setInterpolationMethod(4);
        }
        this.m_dMean = new double[this.m_iClasses][this.m_Windows.length];
        this.m_iCells = new int[this.m_iClasses];
        this.m_iNX = this.m_Result.getWindowGridExtent().getNX();
        this.m_iNY = this.m_Result.getWindowGridExtent().getNY();
        if (this.classify()) {
            this.createTable();
            return true;
        }
        return false;
    }

    private void createTable() throws UnsupportedOutputChannelException {
        int i;
        String[] sFields = new String[this.m_Bands.size() + 2];
        Class[] types = new Class[this.m_Bands.size() + 2];
        Object[] values = new Object[this.m_Bands.size() + 2];
        sFields[0] = "Class";
        sFields[1] = "Count";
        types[0] = Integer.class;
        types[1] = Integer.class;
        for (i = 0; i < this.m_Bands.size(); ++i) {
            RasterLayerAndBand band = (RasterLayerAndBand)this.m_Bands.get(i);
            sFields[i + 2] = new String(band.getRasterLayer().getName() + "[" + Integer.toString(band.getBand()) + "]");
            types[i + 2] = Double.class;
        }
        ITable table = this.getNewTable(RESULTTABLE, Sextante.getText((String)"Classification"), types, sFields);
        for (i = 0; i < this.m_iClasses; ++i) {
            values[0] = new Integer(i);
            values[1] = new Integer(this.m_iCells[i]);
            for (int j = 0; j < this.m_Bands.size(); ++j) {
                values[j + 2] = new Double(this.m_dMean[i][j]);
            }
            table.addRecord(values);
        }
    }

    private boolean classify() {
        int iChangedCells;
        double[] dValues = new double[this.m_Windows.length];
        this.initValues();
        double[][] dNewMean = new double[this.m_iClasses][this.m_Windows.length];
        do {
            int i;
            Arrays.fill(this.m_iCells, 0);
            iChangedCells = 0;
            for (i = 0; i < this.m_iClasses; ++i) {
                Arrays.fill(dNewMean[i], 0.0);
            }
            for (int y = 0; y < this.m_iNY; ++y) {
                for (int x = 0; x < this.m_iNX; ++x) {
                    int iPrevClass = this.m_Result.getCellValueAsInt(x, y);
                    if (this.m_Result.isNoDataValue((double)iPrevClass)) continue;
                    for (i = 0; i < this.m_Windows.length; ++i) {
                        dValues[i] = this.m_Windows[i].getCellValueAsDouble(x, y, this.m_iBands[i]);
                    }
                    int iClass = this.getClass(dValues);
                    this.m_Result.setCellValue(x, y, (double)iClass);
                    for (i = 0; i < this.m_Windows.length; ++i) {
                        double[] dArray = dNewMean[iClass];
                        int n = i;
                        dArray[n] = dArray[n] + dValues[i];
                    }
                    int n = iClass;
                    this.m_iCells[n] = this.m_iCells[n] + 1;
                    if (iClass == iPrevClass) continue;
                    ++iChangedCells;
                }
            }
            for (i = 0; i < this.m_Windows.length; ++i) {
                for (int j = 0; j < this.m_iClasses; ++j) {
                    double[] dArray = dNewMean[j];
                    int n = i;
                    dArray[n] = dArray[n] / (double)this.m_iCells[j];
                }
            }
            double[][] swap = this.m_dMean;
            this.m_dMean = dNewMean;
            dNewMean = swap;
            this.setProgressText(Sextante.getText((String)"Modified_cells") + Integer.toString(iChangedCells));
            if (!this.m_Task.isCanceled()) continue;
            return false;
        } while (iChangedCells > this.m_iThreshold);
        return true;
    }

    private int getClass(double[] dValues) {
        int iClass = 0;
        double dMinDist = Double.MAX_VALUE;
        for (int i = 0; i < this.m_iClasses; ++i) {
            double dDist = 0.0;
            for (int j = 0; j < dValues.length; ++j) {
                double dDif = this.m_dMean[i][j] - dValues[j];
                dDist += dDif * dDif;
            }
            if (!(dDist < dMinDist)) continue;
            dMinDist = dDist;
            iClass = i;
        }
        return iClass;
    }

    private void initValues() {
        int i;
        int iCells = 0;
        double[] dMin = new double[this.m_Windows.length];
        double[] dMax = new double[this.m_Windows.length];
        for (i = 0; i < this.m_Windows.length; ++i) {
            dMin[i] = Double.MAX_VALUE;
            dMax[i] = Double.NEGATIVE_INFINITY;
        }
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                boolean bNoData = false;
                for (i = 0; i < this.m_Windows.length; ++i) {
                    double dValue = this.m_Windows[i].getCellValueAsDouble(x, y, this.m_iBands[i]);
                    if (!this.m_Windows[i].isNoDataValue(dValue)) {
                        dMin[i] = Math.min(dMin[i], dValue);
                        dMax[i] = Math.max(dMax[i], dValue);
                        continue;
                    }
                    bNoData = true;
                }
                if (bNoData) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                ++iCells;
                this.m_Result.setCellValue(x, y, 0.0);
            }
        }
        for (i = 0; i < this.m_Windows.length; ++i) {
            double dStep = (dMax[i] - dMin[i]) / (double)(this.m_iClasses + 2);
            for (int j = 0; j < this.m_iClasses; ++j) {
                this.m_dMean[j][i] = dMin[i] + dStep * (double)(j + 1);
            }
        }
        this.m_iThreshold = (int)((double)iCells * 0.02);
    }
}

