/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.cva;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CVAAlgorithm
extends GeoAlgorithm {
    public static final String A1 = "A1";
    public static final String A2 = "A2";
    public static final String B1 = "B1";
    public static final String B2 = "B2";
    public static final String ANGLE = "ANGLE";
    public static final String DIST = "DIST";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Change_Vector_Analysis"));
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(A1, Sextante.getText((String)"Layer_1__init"), true);
            this.m_Parameters.addInputRasterLayer(A2, Sextante.getText((String)"Layer_2__init"), true);
            this.m_Parameters.addInputRasterLayer(B1, Sextante.getText((String)"Layer_1__final"), true);
            this.m_Parameters.addInputRasterLayer(B2, Sextante.getText((String)"Layer_2__final"), true);
            this.addOutputRasterLayer(ANGLE, Sextante.getText((String)"Angle"));
            this.addOutputRasterLayer(DIST, Sextante.getText((String)"Modulus"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer layerA1 = this.m_Parameters.getParameterValueAsRasterLayer(A1);
        IRasterLayer layerA2 = this.m_Parameters.getParameterValueAsRasterLayer(A2);
        IRasterLayer layerB1 = this.m_Parameters.getParameterValueAsRasterLayer(B1);
        IRasterLayer layerB2 = this.m_Parameters.getParameterValueAsRasterLayer(B2);
        IRasterLayer Distance = this.getNewRasterLayer(DIST, Sextante.getText((String)"Modulus"), 5);
        IRasterLayer Angle2 = this.getNewRasterLayer(ANGLE, Sextante.getText((String)"Angle"), 5);
        AnalysisExtent extent = Distance.getWindowGridExtent();
        layerA1.setWindowExtent(extent);
        layerA2.setWindowExtent(extent);
        layerB1.setWindowExtent(extent);
        layerB2.setWindowExtent(extent);
        int iNX = extent.getNX();
        int iNY = extent.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double a1 = layerA1.getCellValueAsDouble(x, y);
                double a2 = layerA2.getCellValueAsDouble(x, y);
                double b1 = layerB1.getCellValueAsDouble(x, y);
                double b2 = layerB2.getCellValueAsDouble(x, y);
                if (layerA1.isNoDataValue(a1) || layerA2.isNoDataValue(a2) || layerB1.isNoDataValue(b1) || layerB2.isNoDataValue(b2)) {
                    Distance.setNoData(x, y);
                    Angle2.setNoData(x, y);
                    continue;
                }
                double dDist = Math.sqrt((a1 - a2) * (a1 - a2) + (b1 - b2) * (b1 - b2));
                double dAngle = Math.atan((a1 - a2) / (b1 - b2));
                Distance.setCellValue(x, y, dDist);
                Angle2.setCellValue(x, y, dAngle);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

