/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.sumOfCostFromAllPoints;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;

public class SumOfCostFromAllPointsAlgorithm
extends GeoAlgorithm {
    private static final int NO_DATA = -1;
    public static final String COST = "COST";
    public static final String FEATURES = "FEATURES";
    public static final String ACCCOST = "ACCCOST";
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Cost;
    IRasterLayer m_Features;
    IRasterLayer m_AccCost;
    IRasterLayer m_TotalCost;
    ArrayList m_CentralPoints;
    ArrayList m_AdjPoints;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Sum_of_cost_to_all_points"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(COST, Sextante.getText((String)"Unitary_cost"), true);
            this.m_Parameters.addInputRasterLayer(FEATURES, Sextante.getText((String)"Origin-destination_points"), true);
            this.addOutputRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_CentralPoints = new ArrayList();
        this.m_AdjPoints = new ArrayList();
        this.m_Cost = this.m_Parameters.getParameterValueAsRasterLayer(COST);
        this.m_Features = this.m_Parameters.getParameterValueAsRasterLayer(FEATURES);
        this.m_TotalCost = this.getNewRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"), 5);
        AnalysisExtent extent = this.m_TotalCost.getWindowGridExtent();
        this.m_AccCost = this.getTempRasterLayer(5, extent);
        this.m_Cost.setWindowExtent(extent);
        this.m_Cost.setInterpolationMethod(4);
        this.m_Features.setWindowExtent(extent);
        this.m_Features.setInterpolationMethod(0);
        this.m_iNX = this.m_Cost.getNX();
        this.m_iNY = this.m_Cost.getNY();
        this.m_TotalCost.setNoDataValue(-1.0);
        this.m_TotalCost.assign(0.0);
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Features.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || this.m_Features.isNoDataValue(dValue)) continue;
                this.m_CentralPoints.clear();
                this.m_CentralPoints.add(new GridCell(x, y, 0.0));
                this.m_AccCost.setCellValue(x, y, 0.0);
                this.m_AccCost.setNoDataValue(-1.0);
                this.m_AccCost.assignNoData();
                this.calculateCost();
                if (this.m_Task.isCanceled()) {
                    return false;
                }
                this.m_AccCost.multiply(dValue);
                this.m_TotalCost.add(this.m_AccCost);
            }
        }
        return !this.m_Task.isCanceled();
    }

    private void calculateCost() {
        int j;
        int i;
        double[][] dDist = new double[3][3];
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                dDist[i + 1][j + 1] = Math.sqrt(i * i + j * j);
            }
        }
        while (this.m_CentralPoints.size() != 0) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                double dCost1 = this.m_Cost.getCellValueAsDouble(x, y);
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        int x2 = x + i;
                        int y2 = y + j;
                        double dCost2 = this.m_Cost.getCellValueAsDouble(x2, y2);
                        if (this.m_Cost.isNoDataValue(dCost1) || this.m_Cost.isNoDataValue(dCost2)) continue;
                        double dAccCost = 0.0;
                        dAccCost = this.m_AccCost.getCellValueAsDouble(x, y);
                        dAccCost += (dCost1 + dCost2) / 2.0 * dDist[i + 1][j + 1];
                        double dPrevAccCost = this.m_AccCost.getCellValueAsDouble(x2, y2);
                        if (!this.m_AccCost.isNoDataValue(dPrevAccCost) && !(dPrevAccCost > dAccCost)) continue;
                        this.m_AccCost.setCellValue(x2, y2, dAccCost);
                        this.m_AdjPoints.add(new GridCell(x2, y2, 0.0));
                    }
                }
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }
}

