/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.supervisedClassification;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SupervisedClassificationAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String POLYGONS = "POLYGONS";
    public static final String FIELD = "FIELD";
    public static final String METHOD = "METHOD";
    public static final String CLASSIFICATION = "CLASSIFICATION";
    public static final String CLASSES = "CLASSES";
    public static final int METHOD_PARALELLPIPED = 0;
    public static final int METHOD_MIN_DISTANCE = 1;
    public static final int METHOD_MAX_LIKELIHOOD = 2;
    private int m_iMinX;
    private int m_iMinY;
    private int m_iField;
    private IRasterLayer[] m_Window;
    private IRasterLayer m_Output;
    private ArrayList m_Bands;
    private IVectorLayer m_Polygons;
    private ITable m_Table;
    private HashMap m_Classes;
    private int[] m_iBands;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Parallelepiped"), Sextante.getText((String)"Minimum_distance"), Sextante.getText((String)"Maximum_likelihood")};
        this.setName(Sextante.getText((String)"Supervised_classification"));
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Bands"), 7, true);
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons"), 2, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field_with_class_value"), POLYGONS);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.addOutputRasterLayer(CLASSIFICATION, Sextante.getText((String)"Classification"));
            this.addOutputTable(CLASSES, Sextante.getText((String)"Classes"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_Bands = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_Polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        if (this.m_Bands.size() == 0) {
            throw new GeoAlgorithmExecutionException("At least one band is needed to run this algorithm");
        }
        this.m_Classes = new HashMap();
        this.getClassInformation();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_Output = this.getNewRasterLayer(CLASSIFICATION, Sextante.getText((String)"Classification"), 2);
        this.m_Output.setNoDataValue(-1.0);
        AnalysisExtent ge = this.m_Output.getWindowGridExtent();
        for (int i = 0; i < this.m_Window.length; ++i) {
            this.m_Window[i].setWindowExtent(ge);
        }
        switch (iMethod) {
            case 0: {
                this.doParalellpiped();
            }
            default: {
                this.doMinimumDistance();
            }
            case 2: 
        }
        this.doMaximumLikelihood();
        return !this.m_Task.isCanceled();
    }

    private void getClassInformation() throws UnsupportedOutputChannelException {
        ArrayList stats;
        int i;
        String[] sField = new String[1 + this.m_Bands.size() * 2];
        Class[] types = new Class[1 + this.m_Bands.size() * 2];
        Object[] values = new Object[this.m_Bands.size() * 2 + 1];
        sField[0] = Sextante.getText((String)"Name");
        types[0] = String.class;
        this.m_Window = new IRasterLayer[this.m_Bands.size()];
        for (i = 0; i < this.m_Bands.size(); ++i) {
            RasterLayerAndBand band = (RasterLayerAndBand)this.m_Bands.get(i);
            this.m_iBands = new int[this.m_Bands.size()];
            this.m_iBands[i] = band.getBand();
            this.m_Window[i] = band.getRasterLayer();
            AnalysisExtent extent = this.getAdjustedGridExtent(i);
            this.m_Window[i].setWindowExtent(extent);
            sField[i * 2 + 1] = band.getRasterLayer().getName() + "|" + Integer.toString(band.getBand());
            sField[i * 2 + 2] = band.getRasterLayer().getName() + "|" + Integer.toString(band.getBand());
            types[i * 2 + 1] = Double.class;
            types[i * 2 + 2] = Double.class;
        }
        this.setProgressText(Sextante.getText((String)"Calculating_spectral_signatures"));
        i = 0;
        int iShapeCount = this.m_Polygons.getShapesCount();
        IFeatureIterator featureIter = this.m_Polygons.iterator();
        while (featureIter.hasNext() && this.setProgress(i, iShapeCount)) {
            try {
                IFeature feature = featureIter.next();
                Geometry geometry = feature.getGeometry();
                Object[] record = feature.getRecord().getValues();
                String sClass = record[this.m_iField].toString();
                if (this.m_Classes.containsKey(sClass)) {
                    stats = (ArrayList)this.m_Classes.get(sClass);
                } else {
                    stats = new ArrayList();
                    for (int j = 0; j < this.m_Bands.size(); ++j) {
                        stats.add(new SimpleStats());
                    }
                    this.m_Classes.put(sClass, stats);
                }
                this.doPolygon(geometry, stats);
                ++i;
            }
            catch (IteratorException iteratorException) {}
        }
        featureIter.close();
        if (this.m_Task.isCanceled()) {
            return;
        }
        this.m_Table = this.getNewTable(CLASSES, Sextante.getText((String)"Classes"), types, sField);
        Set set = this.m_Classes.keySet();
        for (Object classID : set) {
            stats = (ArrayList)this.m_Classes.get(classID);
            values[0] = new String(classID.toString());
            for (int iGrid = 0; iGrid < this.m_Bands.size(); ++iGrid) {
                SimpleStats substats = (SimpleStats)stats.get(iGrid);
                values[1 + iGrid * 2] = new Double(substats.getMean());
                values[2 + iGrid * 2] = new Double(substats.getStdDev());
            }
            this.m_Table.addRecord(values);
        }
    }

    private void doPolygon(Geometry geom, ArrayList stats) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part, stats);
        }
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }

    private AnalysisExtent getAdjustedGridExtent(int iLayer) {
        AnalysisExtent ge = new AnalysisExtent();
        Rectangle2D rect = this.m_Polygons.getFullExtent();
        double dMinX = this.m_Window[iLayer].getLayerGridExtent().getXMin();
        double dMinY = this.m_Window[iLayer].getLayerGridExtent().getYMin();
        double dCellSize = this.m_Window[iLayer].getLayerGridExtent().getCellSize();
        this.m_iMinX = (int)Math.floor((rect.getMinX() - dMinX) / dCellSize);
        double iMaxX = Math.ceil((rect.getMaxX() - dMinX) / dCellSize);
        this.m_iMinY = (int)Math.floor((rect.getMinY() - dMinY) / dCellSize);
        double iMaxY = Math.ceil((rect.getMaxY() - dMinY) / dCellSize);
        double dMinX2 = dMinX + (double)this.m_iMinX * dCellSize;
        double dMinY2 = dMinY + (double)this.m_iMinY * dCellSize;
        double dMaxX2 = dMinX + iMaxX * dCellSize;
        double dMaxY2 = dMinY + iMaxY * dCellSize;
        ge.setCellSize(dCellSize);
        ge.setXRange(dMinX2, dMaxX2, true);
        ge.setYRange(dMinY2, dMaxY2, true);
        return ge;
    }

    private void doPolygonPart(Geometry geom, ArrayList stats) {
        Envelope extent = geom.getEnvelopeInternal();
        Coordinate[] points = geom.getCoordinates();
        for (int i = 0; i < this.m_Window.length; ++i) {
            int xStop;
            Coordinate p = new Coordinate();
            SimpleStats substats = (SimpleStats)stats.get(i);
            AnalysisExtent ge = this.m_Window[i].getWindowGridExtent();
            int iNX = ge.getNX();
            int iNY = ge.getNY();
            boolean[] bCrossing = new boolean[iNX];
            int xStart = (int)((extent.getMinX() - ge.getXMin()) / ge.getCellSize()) - 1;
            if (xStart < 0) {
                xStart = 0;
            }
            if ((xStop = (int)((extent.getMaxX() - ge.getXMin()) / ge.getCellSize()) + 1) >= iNX) {
                xStop = iNX - 1;
            }
            int y = 0;
            double yPos = ge.getYMax();
            while (y < iNY) {
                if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                    Arrays.fill(bCrossing, false);
                    Coordinate pLeft = new Coordinate(ge.getXMin() - 1.0, yPos);
                    Coordinate pRight = new Coordinate(ge.getXMax() + 1.0, yPos);
                    Coordinate pb = points[points.length - 1];
                    for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                        Coordinate pa = pb;
                        pb = points[iPoint];
                        if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                        this.getCrossing(p, pa, pb, pLeft, pRight);
                        int ix = (int)((p.x - ge.getXMin()) / ge.getCellSize() + 1.0);
                        if (ix < 0) {
                            ix = 0;
                        } else if (ix >= iNX) {
                            ix = iNX - 1;
                        }
                        bCrossing[ix] = !bCrossing[ix];
                    }
                    boolean bFill = false;
                    for (int x = xStart; x <= xStop; ++x) {
                        double dValue;
                        if (bCrossing[x]) {
                            boolean bl = bFill = !bFill;
                        }
                        if (!bFill || this.m_Window[i].isNoDataValue(dValue = this.m_Window[i].getCellValueAsDouble(x, y))) continue;
                        substats.addValue(dValue);
                    }
                }
                ++y;
                yPos -= ge.getCellSize();
            }
        }
    }

    private void doParalellpiped() {
        int iGrid;
        int iMatchingClass = 0;
        double[][] dMean = new double[this.m_Classes.size()][this.m_Window.length];
        double[][] dStdDev = new double[this.m_Classes.size()][this.m_Window.length];
        int iNX = this.m_Output.getWindowGridExtent().getNX();
        int iNY = this.m_Output.getWindowGridExtent().getNY();
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        int iClass = 0;
        while (iter.hasNext()) {
            ArrayList stats = (ArrayList)this.m_Classes.get(iter.next());
            for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                SimpleStats substats = (SimpleStats)stats.get(iGrid);
                dMean[iClass][iGrid] = substats.getMean();
                dStdDev[iClass][iGrid] = Math.sqrt(substats.getVariance());
            }
            ++iClass;
        }
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                for (iClass = 0; iClass < this.m_Classes.size(); ++iClass) {
                    double dValue;
                    iMatchingClass = iClass;
                    for (iGrid = 0; iGrid < this.m_Window.length && !this.m_Window[iGrid].isNoDataValue(dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y)); ++iGrid) {
                        if (!(Math.abs(this.m_Window[iGrid].getCellValueAsDouble(x, y) - dMean[iClass][iGrid]) > dStdDev[iClass][iGrid])) continue;
                        iMatchingClass = -1;
                        break;
                    }
                    if (iMatchingClass != -1) break;
                }
                if (iMatchingClass != -1) {
                    this.m_Output.setCellValue(x, y, (double)(iMatchingClass + 1));
                    continue;
                }
                this.m_Output.setNoData(x, y);
            }
        }
    }

    private void doMinimumDistance() {
        int iGrid;
        int iMin = 0;
        double[][] dMean = new double[this.m_Classes.size()][this.m_Window.length];
        int iNX = this.m_Output.getWindowGridExtent().getNX();
        int iNY = this.m_Output.getWindowGridExtent().getNY();
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        int iClass = 0;
        while (iter.hasNext()) {
            ArrayList stats = (ArrayList)this.m_Classes.get(iter.next());
            for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                dMean[iClass][iGrid] = ((SimpleStats)stats.get(iGrid)).getMean();
            }
            ++iClass;
        }
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dMin = -1.0;
                for (iClass = 0; iClass < this.m_Classes.size(); ++iClass) {
                    double d = 0.0;
                    for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                        double dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y);
                        if (!this.m_Window[iGrid].isNoDataValue(dValue)) {
                            double e = this.m_Window[iGrid].getCellValueAsDouble(x, y) - dMean[iClass][iGrid];
                            d += e * e;
                            if (!(dMin < 0.0) && !(dMin > d)) continue;
                            dMin = d;
                            iMin = iClass;
                            continue;
                        }
                        dMin = -1.0;
                    }
                }
                if (dMin >= 0.0) {
                    this.m_Output.setCellValue(x, y, (double)(iMin + 1));
                    continue;
                }
                this.m_Output.setNoData(x, y);
            }
        }
    }

    private void doMaximumLikelihood() {
        int iGrid;
        int iMax = 0;
        double[][] dMean = new double[this.m_Classes.size()][this.m_Window.length];
        double[][] dStdDev = new double[this.m_Classes.size()][this.m_Window.length];
        double[][] dK = new double[this.m_Classes.size()][this.m_Window.length];
        int iNX = this.m_Output.getWindowGridExtent().getNX();
        int iNY = this.m_Output.getWindowGridExtent().getNY();
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        int iClass = 0;
        while (iter.hasNext()) {
            ArrayList stats = (ArrayList)this.m_Classes.get(iter.next());
            for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                SimpleStats substats = (SimpleStats)stats.get(iGrid);
                dMean[iClass][iGrid] = substats.getMean();
                dStdDev[iClass][iGrid] = Math.sqrt(substats.getVariance());
                dK[iClass][iGrid] = 1.0 / (dStdDev[iClass][iGrid] * Math.sqrt(Math.PI * 2));
            }
            ++iClass;
        }
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dMax = 0.0;
                for (iClass = 0; iClass < this.m_Classes.size(); ++iClass) {
                    double d = 0.0;
                    for (iGrid = 0; iGrid < this.m_Window.length; ++iGrid) {
                        double dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y);
                        if (!this.m_Window[iGrid].isNoDataValue(dValue)) {
                            double e = (this.m_Window[iGrid].getCellValueAsDouble(x, y) - dMean[iClass][iGrid]) / dStdDev[iClass][iGrid];
                            if (!(dMax < (d += (e = dK[iClass][iGrid] * Math.exp(-0.5 * e * e)) * e))) continue;
                            dMax = d;
                            iMax = iClass;
                            continue;
                        }
                        dMax = -1.0;
                    }
                }
                if (dMax > 0.0) {
                    this.m_Output.setCellValue(x, y, (double)(iMax + 1));
                    continue;
                }
                this.m_Output.setNoData(x, y);
            }
        }
    }
}

