/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.binaryOperators;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public abstract class BinaryOperatorAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String LAYER2 = "LAYER2";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_window;
    private IRasterLayer m_window2;
    protected double m_dValue;
    protected double m_dValue2;

    public void defineCharacteristics() {
        this.setGroup(Sextante.getText((String)"Calculus_tools_for_raster_layer"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addInputRasterLayer(LAYER2, Sextante.getText((String)"Layer") + " 2", true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_window2 = this.m_Parameters.getParameterValueAsRasterLayer(LAYER2);
        this.m_window.setWindowExtent(this.m_AnalysisExtent);
        this.m_window2.setWindowExtent(this.m_AnalysisExtent);
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5, this.m_window.getWindowGridExtent());
        result.setNoDataValue(this.m_OutputFactory.getDefaultNoDataValue());
        result.assignNoData();
        int iNX = this.m_window.getNX();
        int iNY = this.m_window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.m_dValue = this.m_window.getCellValueAsDouble(x, y);
                this.m_dValue2 = this.m_window2.getCellValueAsDouble(x, y);
                if (!this.m_window.isNoDataValue(this.m_dValue) && !this.m_window2.isNoDataValue(this.m_dValue2)) {
                    result.setCellValue(x, y, this.getProcessedValue());
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    protected abstract double getProcessedValue();
}

