/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.generateRandomNormal;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GenerateRandomNormalAlgorithm
extends GeoAlgorithm {
    public static final String PROB = "PROB";
    public static final String STDDEV = "STDDEV";
    public static final String MEAN = "MEAN";
    private IRasterLayer m_Result;
    private double m_dMean;
    private double m_dStdDev;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_dMean = this.m_Parameters.getParameterValueAsDouble(MEAN);
        this.m_dStdDev = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        this.m_Result = this.getNewRasterLayer(PROB, Sextante.getText((String)"New_layer"), 5);
        int iNX = this.m_Result.getWindowGridExtent().getNX();
        int iNY = this.m_Result.getWindowGridExtent().getNY();
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = this.getValue();
                this.m_Result.setCellValue(x, y, dValue);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Random_grid__normal"));
        this.setGroup(Sextante.getText((String)"Raster_creation_tools"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addNumericalValue(MEAN, Sextante.getText((String)"Mean"), 0.0, 2);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Standard_deviation"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(PROB, Sextante.getText((String)"Probability"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    double getValue() {
        double x2;
        double x1;
        double w;
        while ((w = (x1 = 2.0 * Math.random() - 1.0) * x1 + (x2 = 2.0 * Math.random() - 1.0) * x2) >= 1.0) {
        }
        w = Math.sqrt(-2.0 * Math.log(w) / w);
        double y1 = x1 * w;
        return this.m_dMean + this.m_dStdDev * y1;
    }
}

