/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.gridCalculator;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.gridCalculus.gridCalculator.CalculatorKeysPanel;
import es.unex.sextante.gridCalculus.gridCalculator.FormulaParser;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.RasterLayerAndBand;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GridCalculatorParametersPanel
extends GeoAlgorithmParametersPanel {
    private JTextArea jTextExpression;
    private JScrollPane jScrollPane;
    private JTree jTree;
    private JScrollPane jScrollPane1;
    private CalculatorKeysPanel m_KeysPanel;
    private TreeMap m_Constants;
    private GeoAlgorithm m_Algorithm;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        this.setPreferredSize(new Dimension(570, 350));
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{10.0, -1.0, -1.0, -1.0, -1.0, 10.0}, {10.0, -1.0, -1.0, -1.0, 50.0, 5.0, 20.0, 5.0, 20.0, 10.0}});
        thisLayout.setHGap(10);
        thisLayout.setVGap(10);
        this.setLayout((LayoutManager)thisLayout);
        this.setSize(new Dimension(350, 350));
        this.jTextExpression = new JTextArea();
        this.jTextExpression.setLineWrap(true);
        this.jScrollPane = new JScrollPane(this.jTextExpression);
        this.add(this.jScrollPane, "1, 4, 4, 4");
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        this.jTextExpression.setBorder(BorderFactory.createBevelBorder(1));
        this.m_KeysPanel = new CalculatorKeysPanel(this.jTextExpression);
        this.add(this.m_KeysPanel, "3, 1, 4, 3");
        this.jScrollPane1 = new JScrollPane();
        this.add(this.jScrollPane1, "1, 1, 2, 3");
        this.jTree = new JTree();
        this.jScrollPane1.setViewportView(this.jTree);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTree.setBorder(BorderFactory.createBevelBorder(1));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int iRow = GridCalculatorParametersPanel.this.jTree.getRowForLocation(e.getX(), e.getY());
                TreePath path = GridCalculatorParametersPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (iRow != -1 && e.getClickCount() == 2) {
                    GridCalculatorParametersPanel.this.insertTextFromTree(path);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        this.populateTree();
        try {
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
            this.add((Component)this.outputChannelSelectionPanel, "3,6,4,6");
            this.add(new JLabel(Sextante.getText((String)"Result")), "1,6,2,6");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void populateTree() {
        DefaultMutableTreeNode child;
        String sName;
        int i;
        this.jTree.setModel(null);
        IRasterLayer[] layers = SextanteGUI.getInputFactory().getRasterLayers();
        DefaultMutableTreeNode main = new DefaultMutableTreeNode(Sextante.getText((String)"ELEMENTS"));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(Sextante.getText((String)"Layers"));
        for (i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].getBandsCount(); ++j) {
                sName = layers[i].getName() + " Band " + Integer.toString(j + 1);
                child = new DefaultMutableTreeNode(sName);
                node.add(child);
            }
        }
        main.add(node);
        String[] sFunctions = new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ln", "log", "exp", "abs", "rand", "mod", "sqrt", "if"};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Functions"));
        for (i = 0; i < sFunctions.length; ++i) {
            child = new DefaultMutableTreeNode(" " + sFunctions[i] + "() ");
            node.add(child);
        }
        main.add(node);
        String[] sOperators = new String[]{"+", "-", "*", "/", "%", "!", "^", "&&", "||", "<", ">", "<=", ">=", "==", "!="};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Operators"));
        for (i = 0; i < sOperators.length; ++i) {
            child = new DefaultMutableTreeNode(" " + sOperators[i] + " ");
            node.add(child);
        }
        main.add(node);
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Constants"));
        this.m_Constants = new TreeMap();
        this.m_Constants.put("e", " " + Double.toString(Math.E) + " ");
        this.m_Constants.put("Pi", " " + Double.toString(Math.PI) + " ");
        this.m_Constants.put("NODATA", " " + Double.toString(SextanteGUI.getOutputFactory().getDefaultNoDataValue()) + " ");
        for (i = 0; i < layers.length; ++i) {
            sName = Sextante.getText((String)"Cell_size_[") + layers[i].getName() + "]";
            double dCellsize = layers[i].getLayerCellSize();
            this.m_Constants.put(sName, " " + Double.toString(dCellsize) + " ");
        }
        Set set = this.m_Constants.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            child = new DefaultMutableTreeNode(iter.next());
            node.add(child);
        }
        main.add(node);
        this.jTree.setModel(new DefaultTreeModel(main));
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jTree.getCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
    }

    private void insertTextFromTree(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent != null && !parent.toString().equals("[" + Sextante.getText((String)"ELEMENTS") + "]")) {
            String sParentName = parent.toString();
            String s = path.getLastPathComponent().toString();
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Constants]"))) {
                s = this.m_Constants.containsKey(s) ? (String)this.m_Constants.get(s) : "";
            }
            this.jTextExpression.insert(s, this.jTextExpression.getCaretPosition());
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Functions]"))) {
                this.jTextExpression.setCaretPosition(this.jTextExpression.getCaretPosition() - 2);
            }
        }
    }

    public void assignParameters() throws WrongInputException {
        IRasterLayer[] layers = SextanteGUI.getInputFactory().getRasterLayers();
        ArrayList<IRasterLayer> layersList = new ArrayList<IRasterLayer>();
        for (IRasterLayer element : layers) {
            layersList.add(element);
        }
        List<RasterLayerAndBand> array = FormulaParser.getBandsFromFormula(this.jTextExpression.getText(), layersList);
        if (array == null) {
            throw new WrongInputException();
        }
        layersList.clear();
        for (int i = 0; i < array.size(); ++i) {
            RasterLayerAndBand rlab = array.get(i);
            IRasterLayer layer = rlab.getRasterLayer();
            if (layersList.contains(layer)) continue;
            layersList.add(layer);
        }
        try {
            this.m_Algorithm.getParameters().getParameter("LAYERS").setParameterValue(layersList);
            this.m_Algorithm.getParameters().getParameter("FORMULA").setParameterValue((Object)this.jTextExpression.getText());
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            out.setOutputChannel(this.outputChannelSelectionPanel.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            throw new WrongInputException();
        }
    }

    public void setOutputValue(String outputName, String value) {
        this.outputChannelSelectionPanel.setText(value);
    }

    public void setParameterValue(String parameterName, String value) {
        if (parameterName.equals("FORMULA")) {
            this.jTextExpression.setText(value);
        }
    }
}

